/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.main;

import com.javafx.main.Main;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JTextPane;

public class NoJavaFXFallback
extends JApplet
implements ActionListener {
    boolean isInBrowser = false;
    boolean oldJRE = true;
    String requiredJavaFXVersion = null;
    boolean oldJavaFX = false;
    boolean doNotUseJNLPAPI = false;

    public NoJavaFXFallback() {
    }

    public NoJavaFXFallback(boolean needJREUpgrade, boolean needFXUpgrade, String requiredJavaFX) {
        this.isInBrowser = false;
        this.oldJavaFX = needFXUpgrade;
        this.requiredJavaFXVersion = requiredJavaFX;
        this.oldJRE = needJREUpgrade;
        this.doNotUseJNLPAPI = true;
        this.populate();
    }

    private void test() {
        this.oldJRE = Main.isOldJRE();
        try {
            Class<?> jclass = Class.forName("netscape.javascript.JSObject");
            Method m = jclass.getMethod("getWindow", Applet.class);
            this.isInBrowser = m.invoke(null, this) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getText() {
        String text = "This application requires a newer version of the Java runtime. Please download and install the latest Java runtime from java.com.";
        text = this.isInBrowser ? text + " Then restart the browser." : text + " Then restart the application.";
        return text;
    }

    @Override
    public void init() {
        this.requiredJavaFXVersion = this.getParameter("requiredFXVersion");
        this.test();
        this.populate();
    }

    private void populate() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JTextPane l = new JTextPane();
        l.setText(this.getText());
        l.setEditable(false);
        pane.add((Component)l, "Center");
        if (Main.getJavaVersionAsFloat() > 160.0f || Main.getJavaVersionAsFloat() > 150.0f && !this.doNotUseJNLPAPI) {
            JButton installButton = new JButton("Install Now");
            installButton.addActionListener((ActionListener)this);
            pane.add((Component)installButton, "South");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            URL u = new URL("http://java.com/");
            if (this.isInBrowser) {
                this.getAppletContext().showDocument(u);
            } else if (!this.doNotUseJNLPAPI) {
                Class<?> sm = Class.forName("javax.jnlp.ServiceManager");
                Class<?> bs = Class.forName("javax.jnlp.BasicService");
                Method lookup = sm.getMethod("lookup", String.class);
                Method showDoc = bs.getMethod("showDocument", URL.class);
                Object s = lookup.invoke(null, "javax.jnlp.BasicService");
                showDoc.invoke(s, u);
            } else {
                Desktop d = Desktop.getDesktop();
                if (d != null) {
                    d.browse(u.toURI());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

