/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.Coords;
import dangerzone.DangerZone;
import dangerzone.blocks.Blocks;
import dangerzone.world.Chunk;
import dangerzone.world.World;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LightingThread
implements Runnable {
    public int tickmax = 14;
    public List<Coords> requested_list;
    public Lock requested_list_lock = new ReentrantLock();
    int me;

    public LightingThread(int whichami) {
        this.requested_list = new ArrayList<Coords>();
        this.me = whichami;
    }

    @Override
    public void run() {
        boolean restart = false;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Thread thisthread = Thread.currentThread();
        thisthread.setPriority(1);
        int currentdimension = DangerZone.player.dimension;
        while (DangerZone.gameover == 0) {
            this.tickmax = DangerZone.renderdistance;
            while (this.me != 0 && DangerZone.graphics_mode < 3) {
                if (DangerZone.graphics_mode == 2 && this.me < 2) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (DangerZone.graphics_mode < 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            int i = this.tickmax;
            while (i >= -this.tickmax && DangerZone.gameover == 0 && !restart) {
                int j = this.tickmax;
                while (j >= -this.tickmax && DangerZone.gameover == 0 && !restart) {
                    int iz;
                    int ix;
                    double px = DangerZone.player.posx;
                    double pz = DangerZone.player.posz;
                    int pd = DangerZone.player.dimension;
                    if (!(DangerZone.graphics_mode == 3 && (((ix = i * 16 + (int)px) >> 4) + ((iz = j * 16 + (int)pz) >> 4)) % 4 != this.me || DangerZone.graphics_mode == 2 && (((ix = i * 16 + (int)px) >> 4) + ((iz = j * 16 + (int)pz) >> 4) & 1) != this.me || (int)Math.sqrt(i * i + j * j) > this.tickmax)) {
                        if (!DangerZone.f12_on) {
                            this.tickChunk(DangerZone.world, i, j, px, pz, pd);
                        }
                        if (currentdimension != DangerZone.player.dimension) {
                            currentdimension = DangerZone.player.dimension;
                            restart = true;
                        }
                        try {
                            long sleeper = 4L;
                            sleeper += (long)((24 - this.tickmax) / 2);
                            if (DangerZone.wr.fps < 40) {
                                sleeper += 16L;
                            }
                            if (DangerZone.wr.fps < 20) {
                                sleeper += 16L;
                            }
                            if (DangerZone.showcase || DangerZone.graphics_mode < 2) {
                                sleeper += 32L;
                            }
                            if (!DangerZone.showcase && DangerZone.graphics_mode == 3) {
                                sleeper = 1L;
                            }
                            Thread.sleep(sleeper);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (DangerZone.gameover != 0) {
                            return;
                        }
                        Coords cl = null;
                        while (true) {
                            this.requested_list_lock.lock();
                            Iterator<Coords> ii = this.requested_list.iterator();
                            cl = null;
                            if (ii.hasNext()) {
                                cl = ii.next();
                                ii.remove();
                            }
                            this.requested_list_lock.unlock();
                            if (cl == null) break;
                            this.updateLightMaps(DangerZone.world, cl.lv, cl.d, cl.x, cl.y, cl.z);
                            Thread.yield();
                        }
                    }
                    --j;
                }
                --i;
            }
            if (DangerZone.gameover != 0) {
                return;
            }
            if (!restart) continue;
            restart = false;
            this.requested_list_lock.lock();
            Iterator<Coords> ii = this.requested_list.iterator();
            while (ii.hasNext()) {
                ii.remove();
            }
            this.requested_list_lock.unlock();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void tickChunk(World w, int xrel, int zrel, double px, double pz, int pd) {
        int k;
        int i;
        short[] leveldata = null;
        float[] lightmap = null;
        short[] drawn = null;
        if (!w.chunkcache.DecoratedChunkExists(pd, (xrel << 4) + (int)px, 0, (zrel << 4) + (int)pz)) {
            return;
        }
        Chunk c = w.chunkcache.getDecoratedChunk(pd, (xrel << 4) + (int)px, 0, (zrel << 4) + (int)pz);
        if (c == null) {
            return;
        }
        drawn = c.drawn;
        if (drawn == null) {
            return;
        }
        int j = 0;
        while (j < 256) {
            lightmap = w.chunkcache.getDecoratedChunkLightmap(pd, c.chunkX << 4, j, c.chunkZ << 4);
            if (lightmap != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        int m;
                        int n = m = i * 16 + k;
                        lightmap[n] = lightmap[n] * 0.95f;
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
        j = 0;
        while (j < 256) {
            int idown;
            int iup = j + 1;
            if (iup > 255) {
                iup = 255;
            }
            if ((idown = j - 1) < 0) {
                idown = 0;
            }
            if ((drawn == null || drawn[j] != 0 || drawn[iup] != 0 || drawn[idown] != 0) && (leveldata = c.blockdata[j]) != null) {
                i = 0;
                while (i < 16) {
                    k = 0;
                    while (k < 16) {
                        float currentlight;
                        short bid = leveldata[i * 16 + k];
                        if (bid != 0 && (currentlight = Blocks.BlockArray[bid].brightness) != 0.0f) {
                            this.updateLightMaps(w, currentlight, pd, (c.chunkX << 4) + i, j, (c.chunkZ << 4) + k);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void updateLightMaps(World w, float lv, int d, int x, int y, int z) {
        int updist = 11;
        float newv = 0.0f;
        if (DangerZone.renderdistance <= 20) {
            updist = 10;
        }
        if (DangerZone.renderdistance <= 16) {
            updist = 9;
        }
        if (DangerZone.renderdistance <= 12) {
            updist = 8;
        }
        if (DangerZone.renderdistance < 10) {
            updist = 7;
        }
        int i = -updist;
        while (i <= updist) {
            int k = -updist;
            while (k <= updist) {
                int j = -updist;
                while (j <= updist) {
                    float cdist;
                    if (y + j >= 0 && y + j <= 255 && (cdist = (float)Math.sqrt(i * i + j * j + k * k)) < (float)updist) {
                        float cval = lv * ((float)updist - cdist) / (float)updist;
                        float prev = this.getLightMapValue(w, d, x + i, y + j, z + k);
                        if (prev >= 0.0f && cval > 0.0f) {
                            newv = prev;
                            if (cval > newv) {
                                newv = cval;
                            }
                        } else if (prev <= 0.0f && cval < 0.0f) {
                            newv = prev;
                            if (cval < newv) {
                                newv = cval;
                            }
                        } else {
                            newv = prev + cval * cval * Math.signum(cval);
                        }
                        w.chunkcache.setDecoratedChunkLightValue(d, x + i, y + j, z + k, newv);
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    public float getLightMapValue(World w, int d, int x, int y, int z) {
        return w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
    }

    public void addRequest(int d, int x, int y, int z, float val) {
        if (this.requested_list == null) {
            return;
        }
        if (DangerZone.graphics_mode < 0) {
            return;
        }
        this.requested_list_lock.lock();
        if (this.requested_list.size() > 500) {
            this.requested_list_lock.unlock();
            return;
        }
        for (Coords c : this.requested_list) {
            if (c.d != d || c.x != x || c.z != z || c.y != y || c.lv != val) continue;
            this.requested_list_lock.unlock();
            return;
        }
        Coords newc = new Coords();
        newc.d = d;
        newc.x = x;
        newc.y = y;
        newc.z = z;
        newc.lv = val;
        this.requested_list.add(newc);
        this.requested_list_lock.unlock();
    }
}

