/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.threads;

import dangerzone.DangerZone;
import dangerzone.blocks.Blocks;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;

public class CaveBuilder
implements Runnable {
    World w;
    int d;
    int cx;
    int cz;
    int rr;
    float mx;
    float mxl;
    double stx;
    double sty;
    double stz;

    public CaveBuilder(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
        this.w = world;
        this.d = dimension;
        this.cx = chunkx;
        this.cz = chunkz;
        this.rr = recur;
        this.mx = mxw;
        this.mxl = mxlen;
        this.stx = startx;
        this.sty = starty;
        this.stz = startz;
    }

    @Override
    public void run() {
        this.add_a_cave(this.w, this.d, this.cx, this.cz, this.rr, this.mx, this.mxl, this.stx, this.sty, this.stz);
    }

    public void add_a_cave(World world, int dimension, int chunkx, int chunkz, int recur, float mxw, float mxlen, double startx, double starty, double startz) {
        if (!DangerZone.generatecaves) {
            return;
        }
        if (recur > 2) {
            return;
        }
        if (mxw < 0.0f) {
            return;
        }
        if (mxlen < 10.0f) {
            return;
        }
        if (recur == 0 && Fastmath.nextInt(32 + (chunkx & 0x3F) * 8 + (chunkz & 0x3F) * 8) != 0) {
            return;
        }
        double dxz = Fastmath.nextFloat() * 360.0f;
        double dy = (Fastmath.nextFloat() - Fastmath.nextFloat()) * 25.0f;
        double ddxz = Fastmath.nextFloat() - Fastmath.nextFloat();
        double ddy = Fastmath.nextFloat() - Fastmath.nextFloat();
        ddxz *= 2.0;
        double width = 2.0f + Fastmath.nextFloat() * mxw;
        double length = mxlen + Fastmath.nextFloat() * mxlen;
        double curx = startx;
        double cury = starty;
        double curz = startz;
        int i = 0;
        while ((double)i < length) {
            double currentwidth;
            if (cury > 35.0) {
                if (dy > 0.0) {
                    dy = -dy;
                }
                if (ddy > 0.0) {
                    ddy = -ddy;
                }
            }
            if (cury < 0.0) {
                if (dy < 0.0) {
                    dy = -dy;
                }
                if (ddy < 0.0) {
                    ddy = -ddy;
                }
            }
            if (Fastmath.nextInt(25) == 1) {
                Thread.yield();
                this.add_a_cave(world, dimension, chunkx, chunkz, recur + 1, mxw - 1.0f, (float)(length / 2.0), curx, cury, curz);
            }
            if ((currentwidth = (double)((float)Fastmath.sin((double)i / length * Math.PI)) * width) > 1.0) {
                int da = 10;
                if (currentwidth < 4.0) {
                    da = 15;
                }
                if (currentwidth > 6.0) {
                    da = 5;
                }
                double dirang = (float)Math.toRadians(dxz - 90.0);
                double dirax = (float)Fastmath.cos(dirang);
                double diraz = (float)Fastmath.sin(dirang);
                int j = 0;
                while (j < 360) {
                    double currad = 0.0;
                    double ty = (float)Fastmath.sin(Math.toRadians(j));
                    double tt = (float)Fastmath.cos(Math.toRadians(j));
                    double tx = (float)(dirax * tt);
                    double tz = (float)(diraz * tt);
                    while (currad < currentwidth) {
                        int bid;
                        if ((int)(cury + ty * (currad += (double)0.2f)) <= 0 || !Blocks.isSolid(bid = world.getblock(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad)))) continue;
                        world.setblocknonotify(dimension, (int)(curx + tx * currad), (int)(cury + ty * currad), (int)(curz + tz * currad), 0);
                    }
                    j += da;
                }
            }
            curx += Fastmath.cos(Math.toRadians(dxz));
            curz += Fastmath.sin(Math.toRadians(dxz));
            dxz += ddxz;
            cury += Fastmath.sin(Math.toRadians(dy));
            dy += ddy;
            if (Fastmath.nextInt(20) == 1) {
                dy = (Fastmath.nextFloat() - Fastmath.nextFloat()) * 25.0f;
                ddy = Fastmath.nextFloat() - Fastmath.nextFloat();
            }
            if (Fastmath.nextInt(50) == 1) {
                dxz += (double)(Fastmath.nextFloat() * 45.0f);
                ddxz = Fastmath.nextFloat() - Fastmath.nextFloat();
                ddxz *= 2.0;
            }
            ++i;
        }
        Thread.yield();
    }
}

