/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entities;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import dangerzone.rendering.Fastmath;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.TextureMapper;
import dangerzone.rendering.WorldRenderer;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import slick.ColorSlick;
import slick.Texture;
import slick.TextureImpl;
import slick.TrueTypeFont;

public class WorldRendererUtils {
    private static boolean square3D_compiled = false;
    private static int squareid3D;
    private static final int blockrenderwidth = 16;
    public static Texture hotbarbackground;
    public static Texture firetexture;
    private static boolean fire_compiled;
    private static int fire_list1;
    private static int fire_list2;
    private static int fire_list3;
    private static int fire_list4;
    private static int fire_list5;
    private static int fire_list6;
    private static int fire_list7;
    private static int fire_list8;
    private static float sunspin;
    private static int blink;
    private static Entity curr_entity;
    private static int curr_entity_count;
    private static float pitchdir;
    private static float yawdir;
    private static float ticker;
    private static float curr_yaw;
    private static float curr_pitch;

    static {
        hotbarbackground = null;
        firetexture = null;
        fire_compiled = false;
        sunspin = 0.0f;
        blink = 0;
        curr_entity = null;
        curr_entity_count = 0;
        pitchdir = 0.3f;
        yawdir = 0.35f;
        ticker = 0.0f;
        curr_yaw = 0.0f;
        curr_pitch = 0.0f;
    }

    public static void drawShowcaseMonster(int whichview) {
        while (curr_entity == null) {
            curr_entity = Entities.random_entity();
            if (Fastmath.nextInt(100) == 1) {
                curr_entity = DangerZone.player;
            }
            if (WorldRendererUtils.curr_entity.model == null) {
                curr_entity = null;
            }
            if (curr_entity != null && curr_entity.getTexture() == null) {
                curr_entity = null;
            }
            if (curr_entity == null) continue;
            curr_entity.init();
            curr_yaw = Fastmath.nextInt(360);
            curr_pitch = Fastmath.nextInt(60) - 30;
            if (DangerZone.world != null && curr_entity != DangerZone.player) {
                WorldRendererUtils.curr_entity.world = DangerZone.world;
                if (DangerZone.monitor_enable) {
                    DangerZone.world.playSound(curr_entity.getLivingSound(), DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz, 0.5f, 1.0f);
                }
            }
            curr_entity_count = 450;
            if (Fastmath.nextInt(100) <= 49) continue;
            yawdir = -yawdir;
        }
        if (whichview == 0) {
            if ((ticker += 1.0f) > 1000000.0f) {
                ticker = 0.0f;
            }
            curr_yaw += yawdir;
            if ((curr_pitch += pitchdir) > 30.0f) {
                pitchdir = -0.25f;
            }
            if (curr_pitch < -30.0f) {
                pitchdir = 0.25f;
            }
            --curr_entity_count;
        }
        MatrixStack.identity();
        MatrixStack.translate(DangerZone.wr.shift_x, -(curr_entity.getHeight() / 2.0f * 16.0f) + DangerZone.wr.shift_y, -((2.5f + curr_entity.getWidth() * 2.5f + curr_entity.getHeight() * 1.75f) * 16.0f));
        MatrixStack.sendCurrentStack();
        MatrixStack.pushMatrix();
        if (curr_yaw != 0.0f) {
            MatrixStack.rotate(curr_yaw, 0.0f, 1.0f, 0.0f);
        }
        if (curr_pitch != 0.0f) {
            MatrixStack.rotate(curr_pitch, 1.0f, 0.0f, 0.0f);
        }
        MatrixStack.sendCurrentStack();
        MatrixStack.pushMatrix();
        GL11.glColor3f((float)0.95f, (float)0.95f, (float)0.95f);
        ModelBase emodel = WorldRendererUtils.curr_entity.model;
        WorldRendererUtils.loadtexture(curr_entity.getTexture());
        emodel.doScale(curr_entity);
        MatrixStack.sendCurrentStack();
        emodel.render(curr_entity, ticker, 0.11f, 0.0f, 0.0f, 0.0f, 1.0f);
        MatrixStack.popMatrix();
        MatrixStack.popMatrix();
        GL20.glUseProgram((int)0);
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)DangerZone.screen_width, (double)0.0, (double)DangerZone.screen_height, (double)-320.0, (double)320.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        WorldRendererUtils.textAt(DangerZone.font, DangerZone.get_left(whichview) + 50, DangerZone.get_bottom(whichview) + 150, WorldRendererUtils.curr_entity.uniquename);
        if (curr_entity_count <= 0) {
            curr_entity = null;
        }
    }

    public static void loadtexture(Texture lt) {
        if (lt == null) {
            return;
        }
        TextureImpl.unbind();
        lt.bind();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)33880);
    }

    public static void textAt(TrueTypeFont ff, float xpos, float ypos, String text) {
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ff.drawString(0.0f, 0.0f, text, ColorSlick.lightGray);
        GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-xpos), (float)(-ypos), (float)0.0f);
    }

    public static void textAt3D(TrueTypeFont ff, float xpos, float ypos, String text) {
        GL11.glEnable((int)3553);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)33880);
        MatrixStack.translate(xpos, ypos, 0.0f);
        MatrixStack.rotate(180.0f, 1.0f, 0.0f, 0.0f);
        MatrixStack.sendCurrentStack();
        ff.drawString3D(0.0f, 0.0f, text, ColorSlick.lightGray);
    }

    public static void drawSquare() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)8.0f, (float)8.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-8.0f, (float)8.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-8.0f, (float)-8.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)8.0f, (float)-8.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
    }

    private static void addVertexInfoToBuffer(ByteBuffer vbodata, float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        vbodata.putFloat(vx);
        vbodata.putFloat(vy);
        vbodata.putFloat(vz);
        vbodata.putFloat(tx);
        vbodata.putFloat(ty);
        vbodata.putFloat(br);
        vbodata.putFloat(bg);
        vbodata.putFloat(bb);
    }

    public static void drawSquare3D() {
        if (!square3D_compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            stride += 12;
            squareid3D = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)squareid3D);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            ByteBuffer vbodata = BufferUtils.createByteBuffer(4 * stride);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 8.0f, 8.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -8.0f, 8.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -8.0f, -8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 8.0f, -8.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            square3D_compiled = true;
        }
        MatrixStack.sendFinalStack();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)squareid3D);
        GL11.glDrawArrays((int)7, (int)0, (int)4);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL11.glDisable((int)3042);
    }

    public static float getLightMapValue(World w, int d, int x, int y, int z) {
        return w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
    }

    public static float getTotalLightAt(World w, int d, int x, int y, int z) {
        return WorldRendererUtils.getBrightnessForLevel(d, y) + w.chunkcache.getDecoratedChunkLightmapVal(d, x, y, z);
    }

    public static float getBrightnessForLevel(int d, int yp) {
        float tod = DangerZone.world.timetimer % DangerZone.world.lengthOfDay;
        float fsin = (float)Math.sin(Math.toRadians(tod / (float)DangerZone.world.lengthOfDay * 360.0f));
        if ((fsin *= 1.75f) > 1.0f) {
            fsin = 1.0f;
        }
        if (DangerZone.no_dark && fsin < -0.25f) {
            fsin = -0.25f;
        }
        if (fsin < -1.0f) {
            fsin = -1.0f;
        }
        float f = 0.5f + 0.45f * fsin;
        if (yp < 50 && Dimensions.DimensionArray[d].fade_light_level) {
            if (yp < 0) {
                yp = 0;
            }
            float f2 = (float)yp / (50.0f + (50.0f - (float)yp));
            f *= f2;
        }
        return f;
    }

    public static void drawRectangleWithTexture(Texture t, float xpos, float ypos, float xsize, float ysize) {
        DangerZone.wr.forceloadtexture(t);
        float w = t.getWidth();
        float h = t.getHeight();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glScalef((float)(xsize / t.getWidth()), (float)(ysize / t.getHeight()), (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)w, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)h);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)w, (float)h);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    private static void drawhotbarbackground() {
        if (hotbarbackground == null) {
            hotbarbackground = TextureMapper.getTexture("res/menus/bkg1.png");
        }
        GL11.glScalef((float)3.25f, (float)3.25f, (float)3.25f);
        DangerZone.wr.loadtexture(hotbarbackground);
        WorldRendererUtils.drawSquare();
        GL11.glScalef((float)0.30769232f, (float)0.30769232f, (float)0.30769232f);
    }

    public static void textAt(float xpos, float ypos, String text) {
        DangerZone.wr.loadtexture(Blocks.stone.getTexture(0));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)(ypos + (float)DangerZone.font.getHeight()), (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        DangerZone.font.drawString(0.0f, 0.0f, text, ColorSlick.white);
        GL11.glPopMatrix();
    }

    public static void drawcoloredsquare(int xpos, int ypos, int xsize, int ysize, float r, float g, float b, float a) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)xpos, (float)ypos, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)xsize, (float)ysize, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)0.0f, (float)ysize, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glVertex3f((float)xsize, (float)0.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void drawBoss(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        Entity ent = WorldRendererUtils.find_focus_entity(world);
        if (ent == null) {
            return;
        }
        if (!ent.isBoss()) {
            return;
        }
        String crittername = ent.getBossName();
        if (crittername == null) {
            return;
        }
        float critterhealth = ent.getBossHealth();
        if (critterhealth < 0.0f) {
            critterhealth = 0.0f;
        }
        if (critterhealth > 1.0f) {
            critterhealth = 1.0f;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        int top = DangerZone.get_top(inview);
        WorldRendererUtils.textAt(middle - crittername.length() * 5, top - 70, crittername);
        WorldRendererUtils.drawcoloredsquare(middle - 201, top - 91, 402, 7, 0.0f, 0.0f, 0.0f, 255.0f);
        WorldRendererUtils.drawcoloredsquare(middle - 200, top - 90, (int)(400.0f * critterhealth), 5, 1.0f - critterhealth, critterhealth, 0.0f, 255.0f);
        GL11.glPopMatrix();
    }

    public static void drawHotbar(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        InventoryContainer ic = null;
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        GL11.glTranslatef((float)(middle - 300), (float)30.0f, (float)0.0f);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)DangerZone.get_bottom(inview), (float)0.0f);
        }
        int i = 0;
        while (i < 10) {
            WorldRenderer.last_texture = -1;
            if (i == DangerZone.player.gethotbarindex()) {
                DangerZone.wr.setBrightnessFocus();
            }
            WorldRendererUtils.drawhotbarbackground();
            ic = DangerZone.player.getHotbar(i);
            if (ic != null) {
                if (ic.bid != 0) {
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    if (Blocks.showTop(ic.bid)) {
                        DangerZone.wr.drawTexturedSquare(0, Blocks.isSolidForRender(ic.bid), ic.bid);
                    } else {
                        DangerZone.wr.drawTexturedSquare(1, Blocks.isSolidForRender(ic.bid), ic.bid);
                    }
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                }
                if (ic.iid != 0) {
                    int md;
                    Item it;
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    DangerZone.wr.loadtexture(Items.getTexture(ic.iid));
                    WorldRendererUtils.drawSquare();
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    if (ic.count == 1 && ic.currentuses > 0 && ic.getMaxStack() == 1 && (it = ic.getItem()) != null && (md = it.maxuses) > 0) {
                        float xs;
                        float pu = (float)ic.currentuses / (float)md;
                        if (pu > 1.0f) {
                            pu = 1.0f;
                        }
                        if (pu < 0.0f) {
                            pu = 0.0f;
                        }
                        if ((xs = 32.0f * (1.0f - pu)) < 1.0f) {
                            xs = 1.0f;
                        }
                        GL11.glPushMatrix();
                        GL11.glDisable((int)3553);
                        GL11.glTranslatef((float)-16.0f, (float)-18.0f, (float)0.0f);
                        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glBegin((int)7);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)xs, (float)2.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)0.0f, (float)2.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                        GL11.glColor3f((float)pu, (float)(1.0f - pu), (float)0.0f);
                        GL11.glVertex3f((float)xs, (float)0.0f, (float)0.0f);
                        GL11.glEnd();
                        GL11.glEnable((int)3553);
                        GL11.glPopMatrix();
                    }
                }
                if (ic.count > 1) {
                    if (ic.count > 9) {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -12.0f, 10.0f, String.format("%d", ic.count));
                    } else {
                        WorldRendererUtils.textAt(DangerZone.wr.font, -6.0f, 10.0f, String.format("%d", ic.count));
                    }
                }
                DangerZone.wr.setBrightnessNonFocus();
            }
            DangerZone.wr.setBrightnessNonFocus();
            GL11.glTranslatef((float)60.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawHealth(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.heart_texture == null || WorldRenderer.unheart_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        GL11.glTranslatef((float)(middle - 300 - 14), (float)65.0f, (float)0.0f);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)DangerZone.get_bottom(inview), (float)0.0f);
        }
        float h = DangerZone.player.getHealth() / DangerZone.player.getMaxHealth();
        h *= 20.0f;
        int i = 0;
        while (i < 20) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.heart_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.unheart_texture);
            }
            WorldRendererUtils.drawSquare();
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawHunger(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.hungerfull_texture == null || WorldRenderer.hungerempty_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        GL11.glTranslatef((float)((float)middle - 285.0f - 14.0f), (float)75.0f, (float)0.0f);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)DangerZone.get_bottom(inview), (float)0.0f);
        }
        float h = DangerZone.player.getHunger() / DangerZone.player.getMaxHunger();
        h *= 19.0f;
        int i = 0;
        while (i < 19) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.hungerfull_texture);
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.hungerempty_texture);
            }
            WorldRendererUtils.drawSquare();
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawMagic(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (DangerZone.player.getMaxMagic() < 1.0f) {
            return;
        }
        ++blink;
        if (WorldRenderer.magic_texture == null || WorldRenderer.magicempty_texture == null) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        GL11.glTranslatef((float)((float)middle - 270.0f - 14.0f), (float)85.0f, (float)0.0f);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)DangerZone.get_bottom(inview), (float)0.0f);
        }
        float h = DangerZone.player.getMagic() / DangerZone.player.getMaxMagic();
        h *= 18.0f;
        int i = 0;
        while (i < 18) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.magic_texture);
                if (DangerZone.magic_power != 0.0f) {
                    if ((blink & 7) > 3 || (float)i + 0.5f > DangerZone.magic_power * 18.0f) {
                        WorldRendererUtils.drawSquare();
                    }
                } else {
                    WorldRendererUtils.drawSquare();
                }
            } else {
                DangerZone.wr.loadtexture(WorldRenderer.magicempty_texture);
                WorldRendererUtils.drawSquare();
            }
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawAir(World world, int inview) {
        if (DangerZone.current_gui != null) {
            return;
        }
        if (WorldRenderer.bubble_texture == null) {
            return;
        }
        if (!Blocks.isLiquid(world.getblock(DangerZone.player.dimension, (int)DangerZone.player.posx, (int)(DangerZone.player.posy + (double)DangerZone.player.getEyeHeight()), (int)DangerZone.player.posz))) {
            return;
        }
        DangerZone.wr.setBrightnessNonFocus();
        GL11.glPushMatrix();
        int middle = DangerZone.get_middle(inview);
        GL11.glTranslatef((float)((float)middle - 255.0f - 14.0f), (float)95.0f, (float)0.0f);
        if (inview != 0) {
            GL11.glTranslatef((float)0.0f, (float)DangerZone.get_bottom(inview), (float)0.0f);
        }
        float h = DangerZone.player.getAir() / DangerZone.player.getMaxAir();
        h *= 17.0f;
        int i = 0;
        while (i < 17) {
            if (h > (float)i + 0.5f) {
                DangerZone.wr.loadtexture(WorldRenderer.bubble_texture);
                WorldRendererUtils.drawSquare();
            }
            GL11.glTranslatef((float)30.0f, (float)0.0f, (float)0.0f);
            ++i;
        }
        GL11.glPopMatrix();
    }

    public static void drawSunAndMoon(World world, boolean spinit) {
        double dist = 254.0f * (float)DangerZone.renderdistance;
        float scale = (float)DangerZone.renderdistance / 24.0f;
        int tod = world.getTimeOfDay();
        int lod = world.getLengthOfDay();
        boolean moon = false;
        if (tod > lod / 2) {
            tod -= lod / 2;
            moon = true;
        }
        double sposx = DangerZone.player.posx % 16.0 * 16.0;
        double sposy = dist * Math.sin(Math.toRadians((float)tod / (float)lod * 360.0f));
        double sposz = dist * Math.cos(Math.toRadians((float)tod / (float)lod * 360.0f)) + DangerZone.player.posz % 16.0 * 16.0;
        MatrixStack.pushMatrix();
        MatrixStack.translate((float)sposx, (float)(sposy + DangerZone.player.posy * 16.0), (float)sposz);
        DangerZone.wr.setBrightness(1.0f);
        if (!moon) {
            DangerZone.wr.loadtexture(WorldRenderer.sun_texture);
        } else {
            DangerZone.wr.loadtexture(WorldRenderer.moon_texture);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        MatrixStack.sendCurrentStack();
        MatrixStack.pushMatrix();
        MatrixStack.scale(20.0f * scale, 20.0f * scale, 20.0f * scale);
        if (!moon) {
            MatrixStack.scale(2.0f, 2.0f, 2.0f);
        }
        MatrixStack.rotate((float)tod / (float)lod * 360.0f, 1.0f, 0.0f, 0.0f);
        if (spinit && !moon) {
            MatrixStack.sendCurrentStack();
            MatrixStack.pushMatrix();
            MatrixStack.rotate((sunspin += 0.15f) % 360.0f, 0.0f, 0.0f, 1.0f);
        }
        MatrixStack.sendCurrentStack();
        WorldRendererUtils.drawSquare3D();
        GL11.glDisable((int)3042);
        DangerZone.wr.setBrightness();
        if (spinit && !moon) {
            MatrixStack.popMatrix();
        }
        MatrixStack.popMatrix();
        MatrixStack.popMatrix();
    }

    public static void drawEntityOnFire(Entity ent) {
        if (firetexture == null) {
            firetexture = TextureMapper.getTexture("res/misc/fire_side.png");
        }
        if (!fire_compiled) {
            int stride;
            int textureoff = stride = 12;
            int coloroff = stride += 8;
            ByteBuffer vbodata = BufferUtils.createByteBuffer(4 * (stride += 12));
            float offinc = 0.0f;
            fire_list1 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list1);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            int vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list2 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list2);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list3 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list3);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list4 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list4);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list5 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list5);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list6 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list6);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list7 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list7);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            offinc += 0.125f;
            fire_list8 = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)fire_list8);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, 9.0f, 0.0f, 1.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, 9.0f, 0.0f, 0.0f, offinc, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, -9.0f, -9.0f, 0.0f, 0.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            WorldRendererUtils.addVertexInfoToBuffer(vbodata, 9.0f, -9.0f, 0.0f, 1.0f, offinc + 0.125f, 1.0f, 1.0f, 1.0f);
            vbodata.flip();
            vbo_buffer = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)vbo_buffer);
            GL15.glBufferData((int)34962, (ByteBuffer)vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)stride, (long)coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
            vbodata.rewind();
            fire_compiled = true;
        }
        DangerZone.wr.loadtexture(firetexture);
        int which = Fastmath.nextInt(8);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        MatrixStack.translate(0.0f, 10.0f, 0.0f);
        MatrixStack.scale(ent.getWidth(), ent.getHeight() * 1.25f, 1.0f);
        MatrixStack.sendCurrentStack();
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        switch (which) {
            case 0: {
                GL30.glBindVertexArray((int)fire_list1);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 1: {
                GL30.glBindVertexArray((int)fire_list2);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 2: {
                GL30.glBindVertexArray((int)fire_list3);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 3: {
                GL30.glBindVertexArray((int)fire_list4);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 4: {
                GL30.glBindVertexArray((int)fire_list5);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 5: {
                GL30.glBindVertexArray((int)fire_list6);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 6: {
                GL30.glBindVertexArray((int)fire_list7);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
                break;
            }
            case 7: {
                GL30.glBindVertexArray((int)fire_list8);
                GL11.glDrawArrays((int)7, (int)0, (int)4);
                GL30.glBindVertexArray((int)0);
            }
        }
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
        GL11.glEnable((int)3042);
    }

    public static Entity find_focus_entity(World w) {
        double dist;
        ListIterator<Entity> li;
        double delta = 0.0;
        float sightdist = 16.0f;
        Entity tempe = null;
        List<Entity> nearby_list = null;
        ArrayList<Entity> check_list = new ArrayList<Entity>();
        int riddenid = 0;
        Entity ridden = DangerZone.player.getRiddenEntity();
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        double fx = DangerZone.player.posx;
        double fy = DangerZone.player.posy + (double)DangerZone.player.getEyeHeight() + DangerZone.eyeheight_adjust;
        double fz = DangerZone.player.posz;
        int x = (int)fx;
        int y = (int)fy;
        int z = (int)fz;
        double dir = Math.toRadians((DangerZone.player.rotation_yaw_head - 90.0f) % 360.0f);
        double dx = Math.cos(dir);
        double dz = Math.sin(dir);
        double dy = Math.sin(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f));
        double xzscale = Math.abs(Math.cos(Math.toRadians(DangerZone.player.rotation_pitch_head % 360.0f)));
        dx *= xzscale;
        dz *= xzscale;
        dy = -dy;
        nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(25.0f, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            li = nearby_list.listIterator();
            while (li.hasNext()) {
                tempe = li.next();
                dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fy - tempe.posy) * (fy - tempe.posy) + (fz - tempe.posz) * (fz - tempe.posz));
                dist -= 0.25;
                dist -= (double)(tempe.getWidth() / 2.0f);
                if (tempe == DangerZone.player || tempe.canthitme || !(dist < (double)sightdist) || tempe.entityID == riddenid && !(dy < -0.75)) continue;
                check_list.add(tempe);
            }
        }
        if (check_list.isEmpty()) {
            return null;
        }
        int lz = 0;
        int ly = 0;
        int lx = 0;
        while (delta < (double)sightdist) {
            fx = DangerZone.player.posx + dx * delta;
            fy = DangerZone.player.posy + (double)DangerZone.player.getEyeHeight() + DangerZone.eyeheight_adjust + dy * delta;
            fz = DangerZone.player.posz + dz * delta;
            x = (int)fx;
            y = (int)fy;
            z = (int)fz;
            li = check_list.listIterator();
            while (li.hasNext()) {
                tempe = li.next();
                if (!(fy > tempe.posy - 0.25) || !(fy < tempe.posy + (double)tempe.getHeight() + 0.25)) continue;
                dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                dist -= 0.25;
                if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                return tempe;
            }
            if (x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = w.getblock(DangerZone.player.dimension, x, y, z);
                if (DangerZone.player.getInLiquid() && Blocks.isLiquid(bid)) {
                    bid = 0;
                }
                if (bid != 0) {
                    return null;
                }
            }
            delta += 0.25;
        }
        return null;
    }

    private static int find_farthest(List<Integer> inlist, EntityLiving me) {
        int found = 0;
        double farthest = -1.0;
        Iterator<Integer> li = inlist.iterator();
        int indx = 0;
        int ipst = 0;
        while (li.hasNext()) {
            Entity pst;
            ipst = li.next();
            if (ipst <= 0 || ipst >= DangerZone.max_entities || (pst = DangerZone.clientEntityManager.entities[ipst]) == null) continue;
            double dist = pst.getDistanceFromEntity(me);
            if (dist > farthest) {
                farthest = dist;
                found = indx;
            }
            ++indx;
        }
        return found;
    }

    public static void findClosest(List<Integer> DrawMe, int howmany, float maxdist, EntityLiving me, float inyaw, int dim, double x, double y, double z) {
        ArrayList<Integer> retlistEB = new ArrayList<Integer>();
        ArrayList<Integer> retlistO = new ArrayList<Integer>();
        double pi = 3.1415926545;
        float use_fov = DangerZone.fieldOfView;
        double farthestEL = -1.0;
        int farthest_indexEL = 0;
        double farthestEB = -1.0;
        int farthest_indexEB = 0;
        double farthestO = -1.0;
        int farthest_indexO = 0;
        int distmul = 1;
        if (DangerZone.graphics_mode >= 0) {
            distmul = 2;
        }
        if (DangerZone.graphics_mode >= 3) {
            distmul = 3;
        }
        if (DangerZone.isVR) {
            use_fov += 15.0f;
        }
        int inext = 0;
        while (inext < DangerZone.max_entities) {
            int prd;
            double dist;
            Entity ent = DangerZone.clientEntityManager.entities[inext];
            if (ent != null && ent.dimension == dim && (ent.entityID != me.entityID || me.always_draw) && (dist = me.getDistanceFromEntity(ent)) <= (double)(prd = ent.maxrenderdist * distmul) && dist <= (double)maxdist) {
                double rhdir;
                double rr = (float)Math.atan2(ent.display_posz - z, ent.display_posx - x);
                double rdd = Math.abs(rr - (rhdir = Math.toRadians((inyaw - 90.0f) % 360.0f))) % (pi * 2.0);
                if (rdd > pi) {
                    rdd -= pi * 2.0;
                }
                rdd = Math.abs(rdd);
                if ((ent.always_draw || !(me.rotation_pitch_head < 45.0f) && !(me.rotation_pitch_head > 315.0f) || !(dist > 16.0) || !(rdd > pi / 2.0 * (double)use_fov / 45.0) || DangerZone.f5_front || DangerZone.f5_back || DangerZone.f5_side) && !ent.isInvisible() && ent.model != null) {
                    if (howmany < 0) {
                        DrawMe.add(inext);
                    } else if (ent instanceof EntityLiving) {
                        if (DrawMe.size() < howmany) {
                            if (dist > farthestEL) {
                                farthestEL = dist;
                                farthest_indexEL = DrawMe.size();
                            }
                            DrawMe.add(inext);
                        } else if (dist < farthestEL) {
                            DrawMe.remove(farthest_indexEL);
                            DrawMe.add(inext);
                            farthest_indexEL = WorldRendererUtils.find_farthest(DrawMe, me);
                        }
                    } else if (ent instanceof EntityBlockItem) {
                        if (retlistEB.size() < howmany) {
                            if (dist > farthestEB) {
                                farthestEB = dist;
                                farthest_indexEB = retlistEB.size();
                            }
                            retlistEB.add(inext);
                        } else if (dist < farthestEB) {
                            retlistEB.remove(farthest_indexEB);
                            retlistEB.add(inext);
                            farthest_indexEB = WorldRendererUtils.find_farthest(retlistEB, me);
                        }
                    } else if (retlistO.size() < howmany) {
                        if (dist > farthestO) {
                            farthestO = dist;
                            farthest_indexO = retlistO.size();
                        }
                        retlistO.add(inext);
                    } else if (dist < farthestO) {
                        retlistO.remove(farthest_indexO);
                        retlistO.add(inext);
                        farthest_indexO = WorldRendererUtils.find_farthest(retlistO, me);
                    }
                }
            }
            ++inext;
        }
        Iterator li = retlistEB.iterator();
        while (li.hasNext()) {
            DrawMe.add((Integer)li.next());
        }
        li = retlistO.iterator();
        while (li.hasNext()) {
            DrawMe.add((Integer)li.next());
        }
    }

    private static int find_farthestP(List<Particle> inlist, EntityLiving me) {
        int found = 0;
        double farthest = -1.0;
        Iterator<Particle> li = inlist.iterator();
        int indx = 0;
        while (li.hasNext()) {
            Particle pst = li.next();
            double dist = pst.getDistanceFromEntity(me);
            if (dist > farthest) {
                farthest = dist;
                found = indx;
            }
            ++indx;
        }
        return found;
    }

    public static void findClosestP(List<Particle> DrawMeP, int howmany, float maxdist, EntityLiving me, float inyaw, int dim, double x, double y, double z) {
        double farthest = -1.0;
        int farthest_index = 0;
        double pi = 3.1415926545;
        float use_fov = DangerZone.fieldOfView;
        int distmul = 1;
        if (DangerZone.graphics_mode >= 0) {
            distmul = 2;
        }
        if (DangerZone.graphics_mode >= 3) {
            distmul = 3;
        }
        if (DangerZone.isVR) {
            use_fov += 15.0f;
        }
        DangerZone.clientParticleManager.particle_list_lock.lock();
        for (Particle pst : DangerZone.clientParticleManager.particle_list) {
            double rhdir;
            int prd;
            double dist = pst.getDistanceFromEntity(me);
            if (!(dist <= (double)(prd = pst.maxrenderdist * distmul)) || !(dist <= (double)maxdist)) continue;
            double rr = (float)Math.atan2(pst.posz - z, pst.posx - x);
            double rdd = Math.abs(rr - (rhdir = Math.toRadians((inyaw - 90.0f) % 360.0f))) % (pi * 2.0);
            if (rdd > pi) {
                rdd -= pi * 2.0;
            }
            rdd = Math.abs(rdd);
            if ((me.rotation_pitch_head < 45.0f || me.rotation_pitch_head > 315.0f) && dist > 4.0 && rdd > pi / 2.0 * (double)use_fov / 45.0 && !DangerZone.f5_front && !DangerZone.f5_back && !DangerZone.f5_side || pst.model == null) continue;
            if (howmany < 0) {
                DrawMeP.add(pst);
                continue;
            }
            if (DrawMeP.size() < howmany) {
                if (dist > farthest) {
                    farthest = dist;
                    farthest_index = DrawMeP.size();
                }
                DrawMeP.add(pst);
                continue;
            }
            if (!(dist < farthest)) continue;
            DrawMeP.remove(farthest_index);
            DrawMeP.add(pst);
            farthest_index = WorldRendererUtils.find_farthestP(DrawMeP, me);
        }
        DangerZone.clientParticleManager.particle_list_lock.unlock();
    }
}

