/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class VBOBuffer {
    public volatile ByteBuffer vbodata = null;
    public volatile int vcount = 0;
    public volatile int drawvcount = 0;
    public volatile int vmax = 0;
    public volatile int drawvmax = 0;
    private int stride = 0;
    private int textureoff = this.stride = 12;
    private int coloroff = 0;
    private volatile int glvboID = 0;
    private volatile int glvaoID = 0;
    public int textureindex = 0;
    public volatile long VBOid = 0L;
    public boolean isTranslucent = false;
    public int xoff;
    public int zoff;
    public long lastusedframe;
    public volatile int vbostate = 0;

    public VBOBuffer() {
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.vmax = 0;
        this.drawvmax = 0;
        this.vbostate = 0;
        this.glvboID = 0;
        this.glvaoID = 0;
        this.vbodata = null;
        this.isTranslucent = false;
        this.zoff = 0;
        this.xoff = 0;
        this.lastusedframe = 0L;
    }

    public void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        if (this.vbostate == 0) {
            ++this.vcount;
            return;
        }
        if (this.vbostate != 1) {
            return;
        }
        if (this.vcount >= this.vmax) {
            ByteBuffer tmpvbodata = BufferUtils.createByteBuffer((this.vmax + 512) * this.stride + 1024);
            if (tmpvbodata == null) {
                return;
            }
            this.vmax += 512;
            DangerZone.wr.VBOmemorysize += 512 * this.stride;
            if (this.vbodata != null) {
                this.vbodata.position(0);
                this.vbodata.limit(this.vbodata.capacity());
            }
            tmpvbodata.position(0);
            tmpvbodata.limit(tmpvbodata.capacity());
            if (this.vbodata != null) {
                tmpvbodata.put(this.vbodata);
            }
            this.vbodata = tmpvbodata;
            this.vbodata.limit(this.vbodata.capacity());
            this.vbodata.position(this.vcount * this.stride);
        }
        this.vbodata.putFloat(vx);
        this.vbodata.putFloat(vy);
        this.vbodata.putFloat(vz);
        this.vbodata.putFloat(tx);
        this.vbodata.putFloat(ty);
        this.vbodata.putFloat(br);
        this.vbodata.putFloat(bg);
        this.vbodata.putFloat(bb);
        ++this.vcount;
    }

    public void draw() {
        if (this.vbostate == 0) {
            return;
        }
        if (this.vbostate == 3) {
            return;
        }
        if (this.vbodata == null) {
            return;
        }
        if (this.vbostate == 2) {
            if (this.vcount == 0) {
                this.drawvcount = 0;
                this.vbostate = 1;
                return;
            }
            if (this.glvaoID == 0 || this.glvboID == 0) {
                this.glvaoID = GL30.glGenVertexArrays();
                this.glvboID = GL15.glGenBuffers();
                GL30.glBindVertexArray((int)this.glvaoID);
                GL20.glEnableVertexAttribArray((int)0);
                GL20.glEnableVertexAttribArray((int)1);
                GL20.glEnableVertexAttribArray((int)2);
                GL15.glBindBuffer((int)34962, (int)this.glvboID);
                GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35044);
                GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)0L);
                GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)this.stride, (long)this.textureoff);
                GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)this.coloroff);
                GL15.glBindBuffer((int)34962, (int)0);
                GL30.glBindVertexArray((int)0);
                GL20.glDisableVertexAttribArray((int)2);
                GL20.glDisableVertexAttribArray((int)1);
                GL20.glDisableVertexAttribArray((int)0);
            }
            this.drawvcount = this.vcount;
            this.drawvmax = this.vmax;
            GL15.glBindBuffer((int)34962, (int)this.glvboID);
            this.vbodata.position(0);
            this.vbodata.limit(this.drawvcount * this.stride);
            GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            this.vbodata.limit(this.vbodata.capacity());
            this.vbostate = 1;
        }
        if (this.vbostate != 1) {
            return;
        }
        if (this.drawvcount == 0) {
            return;
        }
        if (this.isTranslucent) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        MatrixStack.sendFinalStack();
        GL30.glBindVertexArray((int)this.glvaoID);
        GL11.glDrawArrays((int)7, (int)0, (int)this.drawvcount);
        GL30.glBindVertexArray((int)0);
        if (this.isTranslucent) {
            GL11.glDisable((int)3042);
        }
    }

    public boolean finishDraw() {
        if (this.vbostate == 3) {
            return false;
        }
        if (this.vbostate == 0) {
            this.vbodata = BufferUtils.createByteBuffer((this.vcount + 128) * this.stride + 1024);
            if (this.vbodata == null) {
                return false;
            }
            this.vmax = this.vcount + 128;
            this.vbodata.rewind();
            this.vbodata.limit(this.vbodata.capacity());
            this.vbodata.position(0);
            DangerZone.wr.VBOmemorysize += this.vmax * this.stride;
            this.vcount = 0;
            this.drawvcount = 0;
            this.drawvmax = 0;
            this.vbostate = 1;
            return true;
        }
        if (this.vbostate == 1) {
            if (this.vmax > this.vcount + 128) {
                int downsize = this.vmax - (this.vcount + 128);
                downsize *= this.stride;
                ByteBuffer tmpvbodata = BufferUtils.createByteBuffer((this.vcount + 128) * this.stride + 1024);
                if (tmpvbodata == null) {
                    return false;
                }
                DangerZone.wr.VBOmemorysize -= downsize;
                this.vmax = this.vcount + 128;
                this.vbodata.position(0);
                this.vbodata.limit(this.vcount * this.stride);
                tmpvbodata.position(0);
                tmpvbodata.limit(tmpvbodata.capacity());
                tmpvbodata.put(this.vbodata);
                this.vbodata = tmpvbodata;
                this.vbodata.limit(this.vbodata.capacity());
                this.vbodata.position(this.vcount * this.stride);
                this.drawvmax = 0;
            }
            this.vbostate = 2;
        }
        return false;
    }

    public boolean reset() {
        if (this.vbostate != 1) {
            return false;
        }
        if (this.vbodata == null) {
            return true;
        }
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
        this.vcount = 0;
        return true;
    }

    public void free() {
        if (this.vbostate == 3) {
            return;
        }
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        if (this.glvboID != 0) {
            GL15.glDeleteBuffers((int)this.glvboID);
        }
        this.glvboID = 0;
        if (this.glvaoID != 0) {
            GL30.glDeleteVertexArrays((int)this.glvaoID);
        }
        this.glvaoID = 0;
        if (this.vbodata != null) {
            DangerZone.wr.VBOmemorysize -= this.vbodata.capacity();
        }
        this.drawvcount = 0;
        this.vbostate = 3;
        this.vbodata = null;
    }
}

