/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.network;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.ItemAttribute;
import dangerzone.ListInt;
import dangerzone.Player;
import dangerzone.entities.EntityFurnace;
import dangerzone.network.CustomPacket;
import dangerzone.network.CustomPackets;
import dangerzone.network.NetworkInputBuffer;
import dangerzone.network.NetworkOutputBuffer;

public class FurnaceInventoryPacket
extends CustomPacket {
    public FurnaceInventoryPacket() {
        this.uniquename = "DangerZone:FurnaceInventoryPacket";
        this.packetID = CustomPackets.getIDByName(this.uniquename);
    }

    public void inventoryUpdateToServer(int eid, int index, InventoryContainer ic) {
        NetworkOutputBuffer os = DangerZone.server_connection.getOutputStream();
        if (os == null) {
            return;
        }
        int subtype = 0;
        os.writeInt(this.packetID);
        os.writeInt(eid);
        os.writeInt(subtype);
        os.writeInt(index);
        if (ic != null) {
            os.writeInt(ic.count);
            os.writeInt(ic.bid);
            os.writeInt(ic.iid);
            os.writeInt(ic.currentuses);
            os.writeString(ic.icmeta);
            if (ic.count == 1 && ic.bid == 0 && ic.iid != 0) {
                int atcount = 0;
                if (ic.attributes != null) {
                    atcount = ic.attributes.size();
                }
                os.writeInt(atcount);
                if (atcount > 0) {
                    ItemAttribute ia = null;
                    int k = 0;
                    while (k < atcount) {
                        ia = ic.attributes.get(k);
                        os.writeInt(ia.type);
                        os.writeInt(ia.value);
                        ++k;
                    }
                }
            }
        } else {
            int i = 0;
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
            os.writeString(null);
        }
        DangerZone.server_connection.releaseOutputStream();
    }

    public void requestContents(int eid) {
        NetworkOutputBuffer os = DangerZone.server_connection.getOutputStream();
        if (os == null) {
            return;
        }
        int subtype = 1;
        os.writeInt(this.packetID);
        os.writeInt(eid);
        os.writeInt(subtype);
        DangerZone.server_connection.releaseOutputStream();
    }

    @Override
    public void messageFromServer(NetworkInputBuffer is) {
        int subtype = 0;
        int count = 0;
        int eid = 0;
        int bid = 0;
        int iid = 0;
        int currentuses = 0;
        int index = 0;
        String inmeta = null;
        eid = is.readInt();
        subtype = is.readInt();
        if (subtype == 0) {
            EntityFurnace ce;
            int atcount;
            index = is.readInt();
            count = is.readInt();
            bid = is.readInt();
            iid = is.readInt();
            currentuses = is.readInt();
            inmeta = is.readString();
            InventoryContainer ic = new InventoryContainer();
            ic.count = count;
            ic.bid = bid;
            ic.iid = iid;
            ic.currentuses = currentuses;
            ic.icmeta = inmeta;
            if (ic.count == 1 && ic.bid == 0 && ic.iid != 0 && (atcount = is.readInt()) > 0) {
                int i = 0;
                while (i < atcount) {
                    int attype = is.readInt();
                    int atval = is.readInt();
                    ic.addAttribute(attype, atval);
                    ++i;
                }
            }
            if ((ce = (EntityFurnace)DangerZone.clientEntityManager.findEntityByID(eid)) != null && index >= 0 && index < 50) {
                if (count == 0) {
                    ce.setInventory(index, null);
                } else {
                    ce.setInventory(index, ic);
                }
            }
        }
    }

    public void inventoryUpdateToClient(Player p, int eid, int index, InventoryContainer ic) {
        NetworkOutputBuffer os = p.server_thread.getOutputStream();
        if (os == null) {
            return;
        }
        int subtype = 0;
        os.writeInt(this.packetID);
        os.writeInt(eid);
        os.writeInt(subtype);
        os.writeInt(index);
        if (ic != null) {
            os.writeInt(ic.count);
            os.writeInt(ic.bid);
            os.writeInt(ic.iid);
            os.writeInt(ic.currentuses);
            os.writeString(ic.icmeta);
            if (ic.count == 1 && ic.bid == 0 && ic.iid != 0) {
                int atcount = 0;
                if (ic.attributes != null) {
                    atcount = ic.attributes.size();
                }
                os.writeInt(atcount);
                if (atcount > 0) {
                    ItemAttribute ia = null;
                    int k = 0;
                    while (k < atcount) {
                        ia = ic.attributes.get(k);
                        os.writeInt(ia.type);
                        os.writeInt(ia.value);
                        ++k;
                    }
                }
            }
        } else {
            int i = 0;
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
            os.writeInt(i);
            os.writeString(null);
        }
        p.server_thread.releaseOutputStream();
    }

    public void inventoryUpdateToAllClients(int eid, int d, int index, InventoryContainer ic) {
        DangerZone.server.player_list_lock.lock();
        for (ListInt st : DangerZone.server.server_thread_list) {
            if (DangerZone.server.players[st.index] == null || DangerZone.server.players[st.index].p.dimension != d) continue;
            this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ic);
        }
        DangerZone.server.player_list_lock.unlock();
    }

    @Override
    public void messageFromClient(Player plyr, NetworkInputBuffer is) {
        EntityFurnace ce;
        int subtype = 0;
        int count = 0;
        int eid = 0;
        int bid = 0;
        int iid = 0;
        int currentuses = 0;
        int index = 0;
        String inmeta = null;
        eid = is.readInt();
        subtype = is.readInt();
        if (subtype == 0) {
            EntityFurnace ce2;
            int atcount;
            index = is.readInt();
            count = is.readInt();
            bid = is.readInt();
            iid = is.readInt();
            currentuses = is.readInt();
            inmeta = is.readString();
            InventoryContainer ic = new InventoryContainer();
            ic.count = count;
            ic.bid = bid;
            ic.iid = iid;
            ic.currentuses = currentuses;
            ic.icmeta = inmeta;
            if (ic.count == 1 && ic.bid == 0 && ic.iid != 0 && (atcount = is.readInt()) > 0) {
                int i = 0;
                while (i < atcount) {
                    int attype = is.readInt();
                    int atval = is.readInt();
                    ic.addAttribute(attype, atval);
                    ++i;
                }
            }
            if ((ce2 = (EntityFurnace)DangerZone.server.entityManager.findEntityByID(eid)) != null && index >= 0 && index < 50) {
                if (count == 0) {
                    ce2.setInventory(index, null);
                } else {
                    ce2.setInventory(index, ic);
                }
                DangerZone.server.player_list_lock.lock();
                for (ListInt st : DangerZone.server.server_thread_list) {
                    if (DangerZone.server.players[st.index] == null || DangerZone.server.players[st.index].p.dimension != plyr.dimension) continue;
                    this.inventoryUpdateToClient(DangerZone.server.players[st.index].p, eid, index, ce2.getInventory(index));
                }
                DangerZone.server.player_list_lock.unlock();
            }
        } else if (subtype == 1 && (ce = (EntityFurnace)DangerZone.server.entityManager.findEntityByID(eid)) != null) {
            int i = 0;
            while (i < 50) {
                this.inventoryUpdateToClient(plyr, eid, i, ce.getInventory(i));
                ++i;
            }
        }
    }
}

