/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.items;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityFire;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;

public class ItemFireStick
extends Item {
    public ItemFireStick(String name, String tx) {
        super(name, tx);
        this.maxstack = 1;
        this.maxuses = 50;
        this.brightness = 0.65f;
        this.xoff = 5.4f;
        this.yoff = -4.6f;
        this.zoff = -0.4f;
        this.pitch_off = 9.4f;
        this.yaw_off = 91.2f;
        this.roll_off = 35.0f;
    }

    @Override
    public boolean onLeftClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.doSetOnFire(100);
            clickedon.doAttackFrom(holder, 10, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (holder != null && clickedon != null && holder.world.isServer && clickedon instanceof EntityLiving) {
            clickedon.setOnFire(100);
            clickedon.doAttackFrom(holder, 10, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        if (p != null && p.world.isServer) {
            EntityFire eb = (EntityFire)p.world.createEntityByName("DangerZone:Fire", dimension, (double)x + 0.5, (double)y - 0.0625, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                p.world.spawnEntityInWorld(eb);
            }
            return true;
        }
        return false;
    }
}

