/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TheCount;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Vixen
extends EntityLiving {
    public Vixen(World w) {
        super(w);
        this.width = 0.65f;
        this.height = 1.75f;
        this.uniquename = "DangerZone:Vixen";
        this.has_inventory = true;
        this.setMaxHealth(60.0f);
        this.setHealth(60.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.setExperience(80);
        this.setMaxAir(40.0f);
        this.setAir(40.0f);
        this.searchDistance = 60.0f;
        this.attackRange = 3.0f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    @Override
    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            int itd = Items.bow.itemID;
            InventoryContainer ic = new InventoryContainer();
            ic.iid = itd;
            ic.count = 1;
            ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
            this.setHotbar(0, ic);
            this.sethotbarindex(0);
            ic = new InventoryContainer();
            ic.iid = Items.arrow.itemID;
            ic.count = 64;
            this.setHotbar(1, ic);
            ic = new InventoryContainer();
            ic.iid = Items.arrow.itemID;
            ic.count = 64;
            this.setHotbar(2, ic);
            ic = new InventoryContainer();
            ic.iid = Items.arrow.itemID;
            ic.count = 64;
            this.setHotbar(3, ic);
            ic = new InventoryContainer();
            ic.iid = Items.arrow.itemID;
            ic.count = 64;
            this.setHotbar(4, ic);
            if (this.world.rand.nextInt(6) == 0) {
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = Items.tinhelmet.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(0, ic);
                }
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = Items.tinchestplate.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(1, ic);
                }
                if (this.world.rand.nextInt(2) == 0) {
                    ic = new InventoryContainer();
                    ic.iid = Items.tinleggings.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(2, ic);
                    ic = new InventoryContainer();
                    ic.iid = Items.tinboots.itemID;
                    ic.count = 1;
                    ic.currentuses = this.world.rand.nextInt(ic.getItem().maxuses);
                    this.setArmor(3, ic);
                }
            }
        }
    }

    @Override
    public void doTargetPrep(Entity ent) {
        if (ent == null) {
            this.setRightButtonDownCount(0);
            this.moveSpeed = 0.25f;
            this.setAttacking(false);
        } else if (this.getDistanceFromEntity(ent) > (double)this.attackRange) {
            this.setRightButtonDownCount(this.getRightButtonDownCount() + 10);
            this.lookAtEntity(ent);
            this.setAttacking(true);
            this.moveSpeed = 0.05f;
        } else {
            this.setRightButtonDownCount(0);
            this.setAttacking(true);
            this.moveSpeed = 0.25f;
        }
    }

    @Override
    public void doDistanceAttack(Entity victim) {
        InventoryContainer ic;
        if (this.world.isServer && (ic = this.getHotbar(0)) != null && ic.iid == Items.bow.itemID) {
            float dist;
            this.lookAtEntity(victim);
            float fullholdcount = Items.getfullholdcount(ic.iid);
            float curcount = this.getRightButtonDownCount();
            if (curcount < 20.0f) {
                curcount = 20.0f;
            }
            if (curcount > (fullholdcount *= (dist = (float)this.getDistanceFromEntity(victim)) / this.searchDistance)) {
                Item it = ic.getItem();
                it.rightclickup(this, ic, (int)curcount);
                this.setRightButtonDownCount(0);
            }
        }
    }

    @Override
    public String getLivingSound() {
        return null;
    }

    @Override
    public String getHurtSound() {
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "DangerZone:vixen_hurt1";
        }
        if (which == 1) {
            return "DangerZone:vixen_hurt2";
        }
        if (which == 2) {
            return "DangerZone:vixen_hurt3";
        }
        if (which == 3) {
            return "DangerZone:vixen_hurt4";
        }
        if (which == 4) {
            return "DangerZone:vixen_hurt5";
        }
        if (which == 5) {
            return "DangerZone:vixen_hurt6";
        }
        if (which == 6) {
            return "DangerZone:vixen_hurt7";
        }
        if (which == 7) {
            return "DangerZone:vixen_hurt8";
        }
        if (which == 8) {
            return "DangerZone:vixen_hurt9";
        }
        return null;
    }

    @Override
    public String getDeathSound() {
        return this.getHurtSound();
    }

    @Override
    public String getAttackSound() {
        return null;
    }

    @Override
    public void doDeathDrops() {
        super.doDeathDrops();
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand(this.world, 0, Items.trophyvixen.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
        }
    }

    @Override
    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TheCount) {
            return false;
        }
        if (e instanceof Vixen) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/vixen.png");
        }
        return this.texture;
    }
}

