/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.Explosion;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.ThrownBlockItem;
import dangerzone.threads.ExplosionThread;
import dangerzone.world.World;

public class ThrownInstability
extends ThrownBlockItem {
    public float explosive_power = 1.0f;

    public ThrownInstability(World w) {
        super(w);
        this.uniquename = "DangerZone:ThrownInstability";
        this.setAttackDamage(2.0f);
    }

    @Override
    public void doSpecialEffects(double x, double y, double z) {
        int pfreq = 40;
        if (this.explosive_power >= 10.0f) {
            pfreq = 20;
        }
        if (this.explosive_power >= 100.0f) {
            pfreq = 10;
        }
        if (this.explosive_power >= 1000.0f) {
            pfreq = 5;
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", this.world.rand.nextInt(3) + 2, this.dimension, x, y, z);
        }
        if (this.world.rand.nextInt(pfreq) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", this.world.rand.nextInt(3) + 2, this.dimension, x, y, z);
        }
    }

    @Override
    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (this.explosive_power < 0.01f) {
            return;
        }
        if (he && ent != null) {
            ent.doAttackFromCustom(this.thrower, 9, 2.0f * this.getAttackDamage() * this.explosive_power, false);
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleHurt", 25, this.dimension, x, y, z, 0, 0.25f * (ent.getWidth() + ent.getHeight()) / 4.0f);
            float dir = (float)Math.atan2(ent.posz - z, ent.posx - x);
            float hdist = (float)Math.sqrt((ent.posx - x) * (ent.posx - x) + (ent.posz - z) * (ent.posz - z));
            float ydir = (float)Math.atan2(ent.posy + (double)(ent.getHeight() / 2.0f) - y, hdist);
            float knockback = this.explosive_power / 2.0f;
            knockback /= ent.getWidth() * ent.getHeight();
            if (knockback > 10.0f) {
                knockback = 10.0f;
            }
            ent.motionx = (float)((double)ent.motionx + Math.cos(dir) * (double)knockback * Math.cos(ydir));
            ent.motionz = (float)((double)ent.motionz + Math.sin(dir) * (double)knockback * Math.cos(ydir));
            ent.motiony = (float)((double)ent.motiony + (double)knockback * Math.sin(ydir));
            if (ent instanceof Player) {
                Player pl = (Player)ent;
                pl.server_thread.sendVelocityUpdateToPlayer(ent.motionx, ent.motiony, ent.motionz);
            }
        }
        if ((int)(this.getAttackDamage() * this.explosive_power) <= 99) {
            Explosion.boom(this, this.world, this.dimension, x, y, z, (int)(this.getAttackDamage() * this.explosive_power), true);
        } else {
            ExplosionThread rt = new ExplosionThread(this, this.world, this.dimension, x, y, z, (int)(this.getAttackDamage() * this.explosive_power), true);
            Thread it = new Thread(rt);
            it.setPriority(5);
            it.start();
        }
    }
}

