/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.KVPair;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.BlockRail;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityArrow;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityChest;
import dangerzone.entities.EntityDesk;
import dangerzone.entities.EntityExp;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.EntityMagLev;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.Dimensions;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import slick.Texture;

public class EntityRaft
extends Entity {
    public float ypush = 0.0f;
    public int lastx;
    public int lasty;
    public int lastz;
    public float dist_in_block;
    public float usemotionx;
    public float usemotiony;
    public float usemotionz;
    public float max_speed = 1.75f;
    public boolean turnRight;
    public boolean turnLeft;
    public float spinz = 0.0f;
    public boolean played = false;
    public int levstate = 0;
    public float target_yaw = 0.0f;

    public EntityRaft(World w) {
        super(w);
        this.uniquename = "DangerZone:Raft";
        this.width = 2.5f;
        this.height = 0.25f;
        this.rotation_roll = 0.0f;
        this.lastz = 0;
        this.lasty = 0;
        this.lastx = 0;
        this.dist_in_block = 0.5f;
        this.usemotionz = 0.0f;
        this.usemotiony = 0.0f;
        this.usemotionx = 0.0f;
        this.turnLeft = false;
        this.turnRight = false;
        this.has_inventory = true;
        this.levstate = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update(float deltaT) {
        Entity e;
        double tmpxz;
        int raily;
        int railmeta;
        boolean onrail;
        int railtype;
        float distcheck;
        float velocity;
        float new_rotation_pitch;
        float new_rotation_yaw;
        block142: {
            block145: {
                new_rotation_yaw = 0.0f;
                new_rotation_pitch = 0.0f;
                velocity = (float)Math.sqrt(this.usemotionx * this.usemotionx + this.usemotionz * this.usemotionz);
                if (velocity > this.max_speed) {
                    this.usemotionx *= this.max_speed / velocity;
                    this.usemotionz *= this.max_speed / velocity;
                }
                this.rotation_roll = 0.0f;
                distcheck = 0.25f;
                railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, distcheck);
                onrail = railtype != 0;
                railmeta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)(this.posy + (double)distcheck), (int)this.posz);
                raily = (int)(this.posy + (double)distcheck);
                if (!onrail) {
                    railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, -distcheck);
                    onrail = railtype != 0;
                    railmeta = this.world.getblockmeta(this.dimension, (int)this.posx, (int)(this.posy - (double)distcheck), (int)this.posz);
                    raily = (int)(this.posy - (double)distcheck);
                }
                if (!this.world.isServer) {
                    if (onrail) {
                        double tmp = this.posy - (double)raily;
                        if (railtype == Blocks.waterstatic.blockID) {
                            this.posy -= tmp / 2.0;
                        } else if ((railmeta & 0x10) == 16) {
                            double tmpxz2 = this.posx - (double)((int)this.posx);
                            if ((railmeta & 2) != 0) {
                                tmp = tmpxz2;
                            } else if ((railmeta & 1) != 0) {
                                tmp = 1.0 - tmpxz2;
                            } else if ((railmeta & 8) != 0) {
                                tmp = this.posz - (double)((int)this.posz);
                            } else {
                                tmp = this.posz - (double)((int)this.posz);
                                tmp = 1.0 - tmp;
                            }
                            this.posy = raily;
                            this.posy += tmp + (double)0.01f;
                        }
                    }
                    super.update(deltaT);
                    return;
                }
                if (this.posy < 0.0 || this.posy > 256.0) {
                    this.deadflag = true;
                    super.update(deltaT);
                    return;
                }
                if (this.levstate == 0) break block142;
                new_rotation_pitch = 0.0f;
                float tdiff = new_rotation_pitch - this.rotation_pitch;
                while (tdiff > 180.0f) {
                    tdiff -= 360.0f;
                }
                while (tdiff < -180.0f) {
                    tdiff += 360.0f;
                }
                this.rotation_pitch_motion = tdiff / 6.0f;
                tdiff = this.target_yaw - this.rotation_yaw;
                while (tdiff > 180.0f) {
                    tdiff -= 360.0f;
                }
                while (tdiff < -180.0f) {
                    tdiff += 360.0f;
                }
                this.rotation_yaw_motion = tdiff / 6.0f;
                if (!onrail) break block145;
                if (railtype == Blocks.raildown.blockID) {
                    if (this.levstate != 1) {
                        this.posy -= (double)0.1f;
                        super.update(deltaT);
                        return;
                    }
                    this.levstate = 0;
                    this.dist_in_block = 0.7f;
                    this.posy = raily;
                    this.lastx = (int)this.posx;
                    this.lasty = (int)this.posy;
                    this.lastz = (int)this.posz;
                    break block142;
                } else if (railtype == Blocks.railup.blockID) {
                    if (this.levstate != 2) {
                        this.posy += (double)0.1f;
                        super.update(deltaT);
                        return;
                    }
                    this.levstate = 0;
                    this.dist_in_block = 0.7f;
                    this.posy = raily;
                    this.lastx = (int)this.posx;
                    this.lasty = (int)this.posy;
                    this.lastz = (int)this.posz;
                    break block142;
                } else {
                    this.levstate = 0;
                    this.dist_in_block = 0.5f;
                    this.posy = raily;
                    this.lastx = (int)this.posx;
                    this.lasty = (int)this.posy;
                    this.lastz = (int)this.posz;
                }
                break block142;
            }
            if (railtype == 0 || !Blocks.isSolid(railtype)) {
                if (this.levstate == 1) {
                    this.posy += (double)0.1f;
                }
                if (this.levstate == 2) {
                    this.posy -= (double)0.1f;
                }
                super.update(deltaT);
                return;
            }
            this.levstate = 0;
            this.dist_in_block = 0.0f;
            this.lastx = (int)this.posx;
            this.lasty = (int)this.posy;
            this.lastz = (int)this.posz;
        }
        if (onrail && railtype == Blocks.waterstatic.blockID) {
            this.usemotionx *= 0.95f;
            this.usemotionz *= 0.95f;
        }
        double usex = this.posx;
        double usez = this.posz;
        double usey = this.posy;
        float ddiff = 0.0f;
        float decvel = velocity * deltaT;
        int curdir = 0;
        double ydiff = 0.0;
        if (this.world.rand.nextInt(100) == 1) {
            this.world.playSound("DangerZone:little_splash", this.dimension, usex, usey, usez, 0.25f, 1.0f);
        }
        if (onrail && decvel == 0.0f) {
            new_rotation_yaw = this.alignToRail(railtype, railmeta);
            ydiff = usey - (double)raily;
            if (railtype == Blocks.waterstatic.blockID) {
                usey = (double)raily + ydiff / 2.0;
            } else if ((railmeta & 0x10) == 16) {
                tmpxz = usex - (double)((int)usex);
                if ((railmeta & 2) != 0) {
                    ydiff = tmpxz;
                    new_rotation_pitch = -45.0f;
                    if (this.usemotionx > 0.0f) {
                        new_rotation_pitch = 45.0f;
                        this.usemotionx -= 0.005f;
                    } else {
                        this.usemotionx -= 0.005f;
                    }
                } else if ((railmeta & 1) != 0) {
                    ydiff = 1.0 - tmpxz;
                    new_rotation_pitch = -45.0f;
                    if (this.usemotionx < 0.0f) {
                        new_rotation_pitch = 45.0f;
                        this.usemotionx += 0.005f;
                    } else {
                        this.usemotionx += 0.005f;
                    }
                } else if ((railmeta & 8) != 0) {
                    ydiff = usez - (double)((int)usez);
                    new_rotation_pitch = -45.0f;
                    if (this.usemotionz > 0.0f) {
                        new_rotation_pitch = 45.0f;
                        this.usemotionz -= 0.005f;
                    } else {
                        this.usemotionz -= 0.005f;
                    }
                } else {
                    ydiff = usez - (double)((int)usez);
                    ydiff = 1.0 - ydiff;
                    new_rotation_pitch = 45.0f;
                    if (this.usemotionz > 0.0f) {
                        new_rotation_pitch = -45.0f;
                        this.usemotionz += 0.005f;
                    } else {
                        this.usemotionz += 0.005f;
                    }
                }
                usey = raily;
                usey += ydiff + (double)0.01f;
            } else {
                usey = (double)raily + ydiff / 2.0;
            }
        }
        while (decvel > 0.0f) {
            block146: {
                block150: {
                    block151: {
                        block149: {
                            block148: {
                                block147: {
                                    float usev = decvel;
                                    if (usev > 0.1f) {
                                        usev = 0.1f;
                                    }
                                    decvel -= 0.1f;
                                    this.doEntityCollisions(deltaT, usex, usey, usez, usev);
                                    if (onrail) {
                                        if (railtype != Blocks.waterstatic.blockID) {
                                            double dpos;
                                            int intpos;
                                            if (Math.abs(this.usemotionx) > Math.abs(this.usemotionz)) {
                                                new_rotation_yaw = 90.0f;
                                                curdir = 2;
                                                if (this.usemotionx > 0.0f) {
                                                    new_rotation_yaw = 270.0f;
                                                    curdir = 1;
                                                }
                                                this.usemotionz = 0.0f;
                                                intpos = (int)usez;
                                                dpos = usez - (double)intpos;
                                                usez = dpos < 0.5 ? (usez += (0.5 - dpos) / 2.0) : (usez -= (dpos - 0.5) / 2.0);
                                            } else {
                                                new_rotation_yaw = 0.0f;
                                                curdir = 8;
                                                if (this.usemotionz > 0.0f) {
                                                    new_rotation_yaw = 180.0f;
                                                    curdir = 4;
                                                }
                                                this.usemotionx = 0.0f;
                                                intpos = (int)usex;
                                                dpos = usex - (double)intpos;
                                                usex = dpos < 0.5 ? (usex += (0.5 - dpos) / 2.0) : (usex -= (dpos - 0.5) / 2.0);
                                            }
                                        }
                                        ydiff = usey - (double)raily;
                                        usey = raily;
                                        if (railtype == Blocks.waterstatic.blockID) {
                                            usey = raily;
                                        } else if ((railmeta & 0x10) == 16) {
                                            tmpxz = usex - (double)((int)usex);
                                            if ((railmeta & 2) != 0) {
                                                ydiff = tmpxz;
                                                new_rotation_pitch = -45.0f;
                                                if (this.usemotionx > 0.0f) {
                                                    new_rotation_pitch = 45.0f;
                                                    this.usemotionx -= 0.005f;
                                                } else {
                                                    this.usemotionx -= 0.005f;
                                                }
                                            } else if ((railmeta & 1) != 0) {
                                                ydiff = 1.0 - tmpxz;
                                                new_rotation_pitch = -45.0f;
                                                if (this.usemotionx < 0.0f) {
                                                    new_rotation_pitch = 45.0f;
                                                    this.usemotionx += 0.005f;
                                                } else {
                                                    this.usemotionx += 0.005f;
                                                }
                                            } else if ((railmeta & 8) != 0) {
                                                ydiff = usez - (double)((int)usez);
                                                new_rotation_pitch = -45.0f;
                                                if (this.usemotionz > 0.0f) {
                                                    new_rotation_pitch = 45.0f;
                                                    this.usemotionz -= 0.005f;
                                                } else {
                                                    this.usemotionz -= 0.005f;
                                                }
                                            } else {
                                                ydiff = usez - (double)((int)usez);
                                                ydiff = 1.0 - ydiff;
                                                new_rotation_pitch = 45.0f;
                                                if (this.usemotionz > 0.0f) {
                                                    new_rotation_pitch = -45.0f;
                                                    this.usemotionz += 0.005f;
                                                } else {
                                                    this.usemotionz += 0.005f;
                                                }
                                            }
                                            usey = raily;
                                            usey += ydiff + (double)0.01f;
                                        } else {
                                            usey += ydiff / 2.0;
                                            if (this.dist_in_block > 0.4f && this.dist_in_block < 0.6f) {
                                                int nextdir;
                                                if (this.turnLeft && (nextdir = this.leftTurn(curdir, railmeta)) != 0) {
                                                    switch (nextdir) {
                                                        case 1: {
                                                            this.usemotionx = velocity;
                                                            this.usemotionz = 0.0f;
                                                            break;
                                                        }
                                                        case 2: {
                                                            this.usemotionx = -velocity;
                                                            this.usemotionz = 0.0f;
                                                            break;
                                                        }
                                                        case 4: {
                                                            this.usemotionz = velocity;
                                                            this.usemotionx = 0.0f;
                                                            break;
                                                        }
                                                        case 8: {
                                                            this.usemotionz = -velocity;
                                                            this.usemotionx = 0.0f;
                                                            break;
                                                        }
                                                    }
                                                    this.turnLeft = false;
                                                    this.dist_in_block = 0.7f;
                                                    curdir = nextdir;
                                                }
                                                if (this.turnRight && (nextdir = this.rightTurn(curdir, railmeta)) != 0) {
                                                    switch (nextdir) {
                                                        case 1: {
                                                            this.usemotionx = velocity;
                                                            this.usemotionz = 0.0f;
                                                            break;
                                                        }
                                                        case 2: {
                                                            this.usemotionx = -velocity;
                                                            this.usemotionz = 0.0f;
                                                            break;
                                                        }
                                                        case 4: {
                                                            this.usemotionz = velocity;
                                                            this.usemotionx = 0.0f;
                                                            break;
                                                        }
                                                        case 8: {
                                                            this.usemotionz = -velocity;
                                                            this.usemotionx = 0.0f;
                                                            break;
                                                        }
                                                    }
                                                    this.turnRight = false;
                                                    this.dist_in_block = 0.7f;
                                                    curdir = nextdir;
                                                }
                                                if ((railmeta & curdir) == 0) {
                                                    nextdir = this.rightTurn(curdir, railmeta);
                                                    if (nextdir == 0) {
                                                        nextdir = this.leftTurn(curdir, railmeta);
                                                    }
                                                    if (nextdir != 0) {
                                                        switch (nextdir) {
                                                            case 1: {
                                                                this.usemotionx = velocity;
                                                                this.usemotionz = 0.0f;
                                                                break;
                                                            }
                                                            case 2: {
                                                                this.usemotionx = -velocity;
                                                                this.usemotionz = 0.0f;
                                                                break;
                                                            }
                                                            case 4: {
                                                                this.usemotionz = velocity;
                                                                this.usemotionx = 0.0f;
                                                                break;
                                                            }
                                                            case 8: {
                                                                this.usemotionz = -velocity;
                                                                this.usemotionx = 0.0f;
                                                                break;
                                                            }
                                                        }
                                                        curdir = nextdir;
                                                    }
                                                }
                                                this.dist_in_block = 0.7f;
                                            }
                                        }
                                    }
                                    float mx = this.usemotionx * usev / velocity;
                                    float mz = this.usemotionz * usev / velocity;
                                    usex += (double)mx;
                                    usez += (double)mz;
                                    if (railtype == Blocks.waterstatic.blockID ? this.shouldBounce(usex, usey, usez, velocity) : (railmeta & 0x10) == 0 && this.shouldBounce(usex, usey, usez, velocity)) {
                                        return;
                                    }
                                    if (this.lastx != (int)usex || this.lastz != (int)usez || this.lasty != (int)usey) {
                                        this.lastx = (int)usex;
                                        this.lasty = (int)usey;
                                        this.lastz = (int)usez;
                                        this.dist_in_block = 0.0f;
                                        this.played = false;
                                    }
                                    this.dist_in_block += usev;
                                    if (!onrail) break block146;
                                    if (railtype != Blocks.railspeed.blockID) break block147;
                                    this.usemotionx *= 1.01f;
                                    this.usemotionz *= 1.01f;
                                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 5, this.dimension, usex, usey, usez);
                                    if (!this.played && velocity < 1.5f) {
                                        this.world.playSound("DangerZone:swish1", this.dimension, usex, usey, usez, 2.0f, 1.0f);
                                        this.played = true;
                                    }
                                    break block146;
                                }
                                if (railtype != Blocks.railslow.blockID) break block148;
                                this.usemotionx *= 0.98f;
                                this.usemotionz *= 0.98f;
                                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 5, this.dimension, usex, usey, usez);
                                if (!this.played && velocity < 1.5f) {
                                    this.world.playSound("DangerZone:swish1", this.dimension, usex, usey, usez, 2.0f, 1.0f);
                                    this.played = true;
                                }
                                break block146;
                            }
                            if (railtype != Blocks.railstop.blockID) break block149;
                            this.usemotionx *= 0.5f;
                            this.usemotionz *= 0.5f;
                            if (velocity > 0.5f) {
                                Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 50, this.dimension, usex, usey, usez);
                            }
                            if (!this.played && velocity > 0.5f) {
                                if (this.world.rand.nextBoolean()) {
                                    this.world.playSound("DangerZone:stopscreech1", this.dimension, usex, usey, usez, 1.0f, 1.0f);
                                } else {
                                    this.world.playSound("DangerZone:stopscreech2", this.dimension, usex, usey, usez, 1.0f, 1.0f);
                                }
                                this.played = true;
                            }
                            break block146;
                        }
                        if (railtype != Blocks.railfixedslow.blockID) break block150;
                        this.usemotionx *= 0.1f / velocity;
                        this.usemotionz *= 0.1f / velocity;
                        if (velocity < 0.09f) {
                            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 5, this.dimension, usex, usey, usez);
                            if (!this.played) {
                                this.world.playSound("DangerZone:swish1", this.dimension, usex, usey, usez, 2.0f, 1.0f);
                            }
                            this.played = true;
                        }
                        if (!(velocity > this.max_speed / 2.0f)) break block151;
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 25, this.dimension, usex, usey, usez);
                        if (!this.played) {
                            if (this.world.rand.nextBoolean()) {
                                this.world.playSound("DangerZone:stopscreech1", this.dimension, usex, usey, usez, 1.0f, 1.0f);
                            } else {
                                this.world.playSound("DangerZone:stopscreech2", this.dimension, usex, usey, usez, 1.0f, 1.0f);
                            }
                            this.played = true;
                        }
                        break block146;
                    }
                    if (!(velocity > 1.1f)) break block146;
                    Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 5, this.dimension, usex, usey, usez);
                    break block146;
                }
                if (railtype == Blocks.railfixedmedium.blockID) {
                    this.usemotionx *= this.max_speed / 2.0f / velocity;
                    this.usemotionz *= this.max_speed / 2.0f / velocity;
                    if (velocity < this.max_speed / 2.0f - 0.1f) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSparkle", 5, this.dimension, usex, usey, usez);
                        if (!this.played) {
                            this.world.playSound("DangerZone:swish1", this.dimension, usex, usey, usez, 2.0f, 1.0f);
                        }
                        this.played = true;
                    }
                    if (velocity > this.max_speed / 2.0f + 0.1f) {
                        Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 15, this.dimension, usex, usey, usez);
                    }
                } else if (railtype == Blocks.railload.blockID) {
                    this.doLoadSomething(usex, usey, usez);
                } else if (railtype == Blocks.railunload.blockID) {
                    this.doUnloadSomething(usex, usey, usez);
                } else {
                    if (railtype == Blocks.raildplus.blockID) {
                        usey = this.dodimensionplus(usex, usey, usez);
                        break;
                    }
                    if (railtype == Blocks.raildminus.blockID) {
                        usey = this.dodimensionminus(usex, usey, usez);
                        break;
                    }
                    if (railtype == Blocks.railup.blockID) {
                        if (this.dist_in_block > 0.4f && this.dist_in_block < 0.7f) {
                            this.levstate = 1;
                            break;
                        }
                    } else if (railtype == Blocks.raildown.blockID && this.dist_in_block > 0.4f && this.dist_in_block < 0.7f) {
                        this.levstate = 2;
                        break;
                    }
                }
            }
            if ((velocity = (float)Math.sqrt(this.usemotionx * this.usemotionx + this.usemotionz * this.usemotionz)) > this.max_speed) {
                this.usemotionx *= this.max_speed / velocity;
                this.usemotionz *= this.max_speed / velocity;
            }
            if (!(decvel > 0.0f)) continue;
            railtype = this.isRailBlock(this.dimension, usex, usey, usez, distcheck);
            onrail = railtype != 0;
            railmeta = this.world.getblockmeta(this.dimension, (int)usex, (int)(usey + (double)distcheck), (int)usez);
            raily = (int)(usey + (double)distcheck);
            if (onrail) continue;
            railtype = this.isRailBlock(this.dimension, usex, usey, usez, -distcheck);
            onrail = railtype != 0;
            railmeta = this.world.getblockmeta(this.dimension, (int)usex, (int)(usey - (double)distcheck), (int)usez);
            raily = (int)(usey - (double)distcheck);
        }
        this.motionz = 0.0f;
        this.motiony = 0.0f;
        this.motionx = 0.0f;
        this.posx = usex;
        this.posy = usey;
        this.posz = usez;
        if (!onrail) {
            int bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz);
            new_rotation_yaw = this.rotation_yaw + (float)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5));
            if (Blocks.isSolid(bid) || Blocks.isLiquid(bid)) {
                this.usemotionx /= 2.0f;
                this.usemotionz /= 2.0f;
                this.usemotiony += 0.01f;
            } else {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)(this.posy - 0.25), (int)this.posz);
                if (Blocks.isSolid(bid) || Blocks.isLiquid(bid)) {
                    this.usemotionx /= 2.0f;
                    this.usemotionz /= 2.0f;
                    if (this.usemotiony < 0.0f) {
                        this.usemotiony = 0.0f;
                    }
                    this.usemotiony += 0.01f;
                } else {
                    this.usemotiony -= 0.05f;
                }
            }
            if (this.usemotiony < -1.0f) {
                this.usemotiony = -1.0f;
            }
            this.ypush += 18.0f;
            this.ypush %= 360.0f;
            this.usemotiony = (float)((double)this.usemotiony + (double)0.01f * Math.cos(this.ypush));
            this.usemotiony *= 0.9f;
            this.posy += (double)this.usemotiony;
        }
        float rotspeed = 4.0f;
        if (velocity > 0.0f) {
            rotspeed = this.max_speed / velocity;
            if (rotspeed > 4.0f) {
                rotspeed = 4.0f;
            }
            if (rotspeed < 1.0f) {
                rotspeed = 1.0f;
            }
        }
        if (!((e = this.getRiderEntity()) == null || onrail && railtype != Blocks.waterstatic.blockID)) {
            new_rotation_yaw = e.rotation_yaw + 180.0f;
        }
        ddiff = new_rotation_yaw - this.rotation_yaw;
        while (ddiff > 180.0f) {
            ddiff -= 360.0f;
        }
        while (ddiff < -180.0f) {
            ddiff += 360.0f;
        }
        this.rotation_yaw_motion = ddiff / rotspeed;
        this.target_yaw = new_rotation_yaw;
        ddiff = new_rotation_pitch - this.rotation_pitch;
        while (ddiff > 180.0f) {
            ddiff -= 360.0f;
        }
        while (ddiff < -180.0f) {
            ddiff += 360.0f;
        }
        this.rotation_pitch_motion = ddiff / rotspeed;
        super.update(deltaT);
    }

    public boolean shouldBounce(double usex, double usey, double usez, float velocity) {
        float mx = this.usemotionx * 0.45f / velocity;
        float mz = this.usemotionz * 0.45f / velocity;
        int bid = this.world.getblock(this.dimension, (int)(usex + (double)mx), (int)(usey + 0.25), (int)(usez + (double)mz));
        if (Blocks.isSolid(bid)) {
            if (this.world.isServer) {
                this.world.playSound("DangerZone:woodbreak", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                Utils.doDropRand(this.world, 0, Items.raft.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
                this.doDeathDrops();
                Entity e = this.getRiderEntity();
                if (e != null) {
                    this.unMount(e);
                }
                this.deadflag = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public void doEntityAction(float deltaT) {
        boolean onrail;
        Entity rider = this.getRiderEntity();
        if (rider == null) {
            return;
        }
        if (!(rider instanceof Player)) {
            super.doEntityAction(deltaT);
            return;
        }
        float cdir = (float)Math.toRadians(rider.rotation_yaw_head);
        float distcheck = 0.25f;
        int railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, distcheck);
        boolean bl = onrail = railtype != 0;
        if (!onrail) {
            railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, -distcheck);
            boolean bl2 = onrail = railtype != 0;
        }
        if (!onrail || railtype == Blocks.waterstatic.blockID) {
            float tdir = (float)Math.toRadians(rider.rotation_yaw_head);
            float speedfactor = 0.05f;
            if (!onrail) {
                speedfactor = 0.01f;
            }
            if (rider.getForward()) {
                this.usemotionx = (float)((double)this.usemotionx + (double)(this.max_speed * speedfactor) * Math.sin(tdir));
                this.usemotionz = (float)((double)this.usemotionz + (double)(this.max_speed * speedfactor) * Math.cos(tdir));
            }
            if (rider.getBackward()) {
                this.usemotionx = (float)((double)this.usemotionx - (double)(this.max_speed * speedfactor) * Math.sin(tdir));
                this.usemotionz = (float)((double)this.usemotionz - (double)(this.max_speed * speedfactor) * Math.cos(tdir));
            }
            if (rider.getLeft()) {
                this.usemotionx = (float)((double)this.usemotionx + (double)(this.max_speed * speedfactor) * Math.sin((double)tdir + 1.5707963267948966));
                this.usemotionz = (float)((double)this.usemotionz + (double)(this.max_speed * speedfactor) * Math.cos((double)tdir + 1.5707963267948966));
            }
            if (rider.getRight()) {
                this.usemotionx = (float)((double)this.usemotionx - (double)(this.max_speed * speedfactor) * Math.sin((double)tdir + 1.5707963267948966));
                this.usemotionz = (float)((double)this.usemotionz - (double)(this.max_speed * speedfactor) * Math.cos((double)tdir + 1.5707963267948966));
            }
        } else {
            int fb = (int)rider.rotation_yaw_head;
            fb += 45;
            while (fb < 0) {
                fb += 360;
            }
            while (fb > 360) {
                fb -= 360;
            }
            fb = fb / 90 * 90;
            cdir = (float)Math.toRadians(fb);
            if (rider.getForward()) {
                this.usemotionx = (float)((double)this.usemotionx + (double)0.02f * Math.sin(cdir));
                this.usemotionz = (float)((double)this.usemotionz + (double)0.02f * Math.cos(cdir));
            }
            if (rider.getBackward()) {
                this.usemotionx = (float)((double)this.usemotionx - (double)0.02f * Math.sin(cdir));
                this.usemotionz = (float)((double)this.usemotionz - (double)0.02f * Math.cos(cdir));
            }
            this.turnLeft = rider.getLeft();
            this.turnRight = rider.getRight();
        }
        super.doEntityAction(deltaT);
    }

    public int isRailBlock(int d, double usex, double usey, double usez, double off) {
        if (this.world == null) {
            return 0;
        }
        int bid = this.world.getblock(d, (int)usex, (int)(usey + off), (int)usez);
        if (bid == 0) {
            return 0;
        }
        Block b = Blocks.getBlock(bid);
        if (b instanceof BlockRail) {
            return bid;
        }
        if (bid == Blocks.waterstatic.blockID) {
            return bid;
        }
        return 0;
    }

    float alignToRail(int railtype, int railmeta) {
        if (railtype == Blocks.waterstatic.blockID) {
            Entity rider = this.getRiderEntity();
            if (rider == null) {
                return this.rotation_yaw;
            }
            return rider.rotation_yaw;
        }
        if ((railmeta & 1) != 0) {
            return 270.0f;
        }
        if ((railmeta & 2) != 0) {
            return 90.0f;
        }
        if ((railmeta & 4) != 0) {
            return 180.0f;
        }
        if ((railmeta & 8) != 0) {
            return 0.0f;
        }
        return 0.0f;
    }

    int rightTurn(int indir, int inopts) {
        if (indir == 1 && (inopts & 4) != 0) {
            return 4;
        }
        if (indir == 2 && (inopts & 8) != 0) {
            return 8;
        }
        if (indir == 4 && (inopts & 2) != 0) {
            return 2;
        }
        if (indir == 8 && (inopts & 1) != 0) {
            return 1;
        }
        return 0;
    }

    int leftTurn(int indir, int inopts) {
        if (indir == 1 && (inopts & 8) != 0) {
            return 8;
        }
        if (indir == 2 && (inopts & 4) != 0) {
            return 4;
        }
        if (indir == 4 && (inopts & 1) != 0) {
            return 1;
        }
        if (indir == 8 && (inopts & 2) != 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null) {
                if (this.getInventory(0) == null) {
                    if (this.isMountedBy(p)) {
                        this.unMount(p);
                        this.motionx = 0.0f;
                        this.usemotionx = 0.0f;
                        this.motionz = 0.0f;
                        this.usemotionz = 0.0f;
                    } else {
                        this.MountAsPassenger(p);
                    }
                } else {
                    p.setHotbar(p.gethotbarindex(), this.getInventory(0));
                    this.setInventory(0, null);
                }
            } else if (this.getInventory(0) == null) {
                this.setInventory(0, ic);
                p.setHotbar(p.gethotbarindex(), null);
            }
        }
        return false;
    }

    @Override
    public float getRiderYoffset() {
        int railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, 0.25);
        if (railtype != 0 && railtype == Blocks.waterstatic.blockID) {
            return 1.15f;
        }
        return 0.55f;
    }

    @Override
    public float getRiderXZoffset() {
        return 0.0f;
    }

    @Override
    public boolean leftClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            Utils.doDropRand(this.world, 0, Items.raft.itemID, 1.0f, this.dimension, this.posx, this.posy, this.posz);
            this.world.playSound("DangerZone:woodbreak", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            this.doDeathDrops();
            if (this.isMountedBy(p)) {
                this.unMount(p);
                this.motionx = 0.0f;
                this.usemotionx = 0.0f;
                this.motionz = 0.0f;
                this.usemotionz = 0.0f;
            }
            this.deadflag = true;
        }
        return false;
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Rafttexture.png");
        }
        return this.texture;
    }

    @Override
    public float getSpinz() {
        this.spinz += 1.5f;
        this.spinz %= 360.0f;
        return this.spinz;
    }

    @Override
    public void doEntityCollisions(float deltaT) {
        if (!this.world.isServer) {
            return;
        }
        float wdth = this.getWidth();
        List<Entity> nearby_list = null;
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        int riddenid = 0;
        int riderid = 0;
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        if (rider != null) {
            riderid = rider.entityID;
        }
        if ((nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(wdth / 2.0f + 8.0f, this.dimension, this.posx, this.posy, this.posz)) != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e == this || e.ignoreCollisions || !(this.posy + (double)this.getHeight() > e.posy) || !(this.posy < e.posy + (double)e.getHeight())) continue;
                double dist = e.getHorizontalDistanceFromEntity(this);
                dist -= (double)(wdth / 2.0f);
                if (!((dist -= (double)(e.getWidth() / 2.0f)) < 0.0) || riddenid == e.entityID || riderid == e.entityID) continue;
                double dir = Math.atan2(e.posz - this.posz, e.posx - this.posx);
                if (this.isPushable(e)) {
                    dist = Math.sqrt(this.usemotionx * this.usemotionx + this.usemotionz * this.usemotionz);
                    if (dist < (double)0.05f) {
                        dist = 0.05f;
                    }
                    e.motionx = (float)((double)e.motionx + Math.cos(dir) * (dist /= 2.0) * (double)deltaT);
                    e.motionz = (float)((double)e.motionz + Math.sin(dir) * dist * (double)deltaT);
                    if (!(e instanceof EntityRaft)) continue;
                    EntityRaft emv = (EntityRaft)e;
                    emv.usemotionx = (float)((double)emv.usemotionx + Math.cos(dir) * dist * (double)deltaT);
                    emv.usemotionz = (float)((double)emv.usemotionz + Math.sin(dir) * dist * (double)deltaT);
                    this.usemotionx *= 0.9f;
                    this.usemotionz *= 0.9f;
                    continue;
                }
                dist = Math.sqrt(e.motionx * e.motionx + e.motionz * e.motionz);
                if (dist < (double)0.05f) {
                    dist = 0.05f;
                }
                dist = -dist / 2.0;
                this.usemotionx = (float)((double)this.usemotionx + Math.cos(dir) * dist * (double)deltaT);
                this.usemotionz = (float)((double)this.usemotionz + Math.sin(dir) * dist * (double)deltaT);
            }
        }
    }

    public void doEntityCollisions(float deltaT, double usex, double usey, double usez, float usev) {
        if (!this.world.isServer) {
            return;
        }
        float wdth = this.getWidth();
        List<Entity> nearby_list = null;
        Entity ridden = this.getRiddenEntity();
        Entity rider = this.getRiderEntity();
        int riddenid = 0;
        int riderid = 0;
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        if (rider != null) {
            riderid = rider.entityID;
        }
        if ((nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(wdth / 2.0f + 8.0f, this.dimension, usex, usey, usez)) != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e == this || e.ignoreCollisions || !(usey + (double)this.getHeight() > e.posy) || !(usey < e.posy + (double)e.getHeight())) continue;
                double dist = this.MYgetHorizontalDistanceFromEntity(e, usex, usez);
                dist -= (double)(wdth / 2.0f);
                if (!((dist -= (double)(e.getWidth() / 2.0f)) < 0.0) || riddenid == e.entityID || riderid == e.entityID) continue;
                double dir = Math.atan2(e.posz - usez, e.posx - usex);
                if (this.isPushable(e)) {
                    Entity emv;
                    dist = usev;
                    if (dist < (double)0.05f) {
                        dist = 0.05f;
                    }
                    e.motionx = (float)((double)e.motionx + Math.cos(dir) * (dist /= 2.0) * (double)deltaT);
                    e.motionz = (float)((double)e.motionz + Math.sin(dir) * dist * (double)deltaT);
                    e.posx += Math.cos(dir) * dist * (double)deltaT;
                    e.posz += Math.sin(dir) * dist * (double)deltaT;
                    if (e instanceof EntityRaft) {
                        emv = (EntityRaft)e;
                        emv.usemotionx = (float)((double)emv.usemotionx + Math.cos(dir) * dist * (double)deltaT);
                        emv.usemotionz = (float)((double)emv.usemotionz + Math.sin(dir) * dist * (double)deltaT);
                        this.usemotionx *= 0.95f;
                        this.usemotionz *= 0.95f;
                    }
                    if (!(e instanceof EntityMagLev)) continue;
                    emv = (EntityMagLev)e;
                    ((EntityMagLev)emv).usemotionx = (float)((double)((EntityMagLev)emv).usemotionx + Math.cos(dir) * dist * (double)deltaT);
                    ((EntityMagLev)emv).usemotionz = (float)((double)((EntityMagLev)emv).usemotionz + Math.sin(dir) * dist * (double)deltaT);
                    this.usemotionx *= 0.95f;
                    this.usemotionz *= 0.95f;
                    continue;
                }
                dist = usev;
                if (dist < (double)0.05f) {
                    dist = 0.05f;
                }
                dist = -dist / 2.0;
                this.usemotionx = (float)((double)this.usemotionx + Math.cos(dir) * dist * (double)deltaT);
                this.usemotionz = (float)((double)this.usemotionz + Math.sin(dir) * dist * (double)deltaT);
            }
        }
    }

    public double MYgetHorizontalDistanceFromEntity(Entity p, double usex, double usez) {
        if (p.dimension != this.dimension) {
            return 9999.0;
        }
        double d1 = p.posx - usex;
        double d3 = p.posz - usez;
        return Math.sqrt(d1 * d1 + d3 * d3);
    }

    public boolean isPushable(Entity e) {
        if (e instanceof EntityRaft) {
            return true;
        }
        if (e instanceof EntityMagLev) {
            return true;
        }
        if (e instanceof EntityBlockItem) {
            return true;
        }
        if (e instanceof EntityBlock) {
            return true;
        }
        if (e instanceof EntityExp) {
            return true;
        }
        if (e instanceof EntityArrow) {
            e.deadflag = true;
            return true;
        }
        return e instanceof EntityLiving && e.getHeight() * e.getWidth() < 1.0f;
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        super.writeSelf(prop, tag);
        prop.add(new KVPair(String.format("%s%s", tag, "USEMOTIONX"), String.format("%f", Float.valueOf(this.usemotionx))));
        prop.add(new KVPair(String.format("%s%s", tag, "USEMOTIONY"), String.format("%f", Float.valueOf(this.usemotiony))));
        prop.add(new KVPair(String.format("%s%s", tag, "USEMOTIONZ"), String.format("%f", Float.valueOf(this.usemotionz))));
        prop.add(new KVPair(String.format("%s%s", tag, "DISTINBLOCK"), String.format("%f", Float.valueOf(this.dist_in_block))));
        prop.add(new KVPair(String.format("%s%s", tag, "LEVSTATE"), String.format("%d", this.levstate)));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.usemotionx = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "USEMOTIONX"), -5.0f, 5.0f, 0.0f);
        this.usemotiony = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "USEMOTIONY"), -5.0f, 5.0f, 0.0f);
        this.usemotionz = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "USEMOTIONZ"), -5.0f, 5.0f, 0.0f);
        this.dist_in_block = Utils.getPropertyFloat(prop, String.format("%s%s", tag, "DISTINBLOCK"), 0.0f, 1.0f, 0.5f);
        this.levstate = Utils.getPropertyInt(prop, String.format("%s%s", tag, "LEVSTATE"), 0, 2, 0);
    }

    public void doLoadSomething(double usex, double usey, double usez) {
        if (this.getInventory(0) != null) {
            return;
        }
        if (this.getRiderEntity() != null) {
            return;
        }
        List<Entity> nearby_list = null;
        Entity e = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(1.75f, this.dimension, usex, usey, usez);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e != this && !(e instanceof EntityRaft) && e.has_inventory && (e instanceof EntityChest || e instanceof EntityDesk || e instanceof EntityBlockItem) && this.isNotEmpty(e)) break;
                e = null;
            }
        }
        if (e != null) {
            InventoryContainer ic = null;
            int i = 0;
            while (i < 50) {
                ic = e.getInventory(i);
                if (ic != null) {
                    this.setInventory(0, ic);
                    e.setInventory(i, null);
                    break;
                }
                ++i;
            }
        }
    }

    public boolean isNotEmpty(Entity ent) {
        int i = 0;
        while (i < 50) {
            if (ent.getInventory(i) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void doUnloadSomething(double usex, double usey, double usez) {
        if (this.getInventory(0) == null) {
            return;
        }
        List<Entity> nearby_list = null;
        Entity e = null;
        nearby_list = DangerZone.server.entityManager.findALLEntitiesInRange(1.75f, this.dimension, usex, usey, usez);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = li.next();
                if (e != this && !(e instanceof EntityRaft) && e.has_inventory && (e instanceof EntityChest || e instanceof EntityDesk) && this.fillEntity(e, this.getInventory(0))) break;
            }
        }
    }

    public boolean fillEntity(Entity ent, InventoryContainer ic) {
        while (ic.count > 0) {
            if (!this.putMeInASlot(ent, new InventoryContainer(ic.bid, ic.iid, 1, ic.currentuses, ic.count == 1 ? ic.attributes : null, ic.icmeta))) break;
            --ic.count;
        }
        if (ic.count <= 0) {
            this.setInventory(0, null);
            return true;
        }
        this.setInventoryChanged(0);
        return false;
    }

    public boolean putMeInASlot(Entity ent, InventoryContainer inic) {
        int bid = inic.bid;
        int iid = inic.iid;
        if (inic.count == 0 || inic.iid == 0 && inic.bid == 0) {
            return true;
        }
        int i = 0;
        while (i < 50) {
            InventoryContainer ic = ent.getInventory(i);
            if (ic != null && ic.bid == bid && ic.iid == iid) {
                if (ic.bid != 0 && ic.count < Blocks.getMaxStack(bid)) {
                    ++ic.count;
                    ent.setInventoryChanged(i);
                    return true;
                }
                if (ic.iid != 0 && ic.count < Items.getMaxStack(iid)) {
                    ++ic.count;
                    ent.setInventoryChanged(i);
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 50) {
            if (ent.getInventory(i) == null) {
                ent.setInventory(i, inic);
                return true;
            }
            ++i;
        }
        return false;
    }

    public double dodimensionplus(double usex, double usey, double usez) {
        int nextdim = 1;
        int i = 0;
        while (i < 256) {
            int id = (this.dimension + i + 1) % 256;
            if (Dimensions.DimensionArray[id] != null && !Dimensions.DimensionArray[id].special_hidden) {
                nextdim = id;
                break;
            }
            ++i;
        }
        double newy = this.findnewy(nextdim, usex, usey, usez);
        Entity rider = this.getRiderEntity();
        if (rider == null) {
            this.dimension = nextdim;
            this.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(this, true);
        } else if (!(rider instanceof Player)) {
            this.dimension = nextdim;
            this.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(this, true);
            rider.dimension = nextdim;
            rider.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(rider, true);
        } else {
            Player pl = (Player)rider;
            Utils.doTeleport(pl, nextdim, usex, newy, usez);
        }
        return newy;
    }

    public double dodimensionminus(double usex, double usey, double usez) {
        int nextdim = 1;
        int i = 0;
        while (i < 256) {
            int id = (this.dimension - i - 1) % 256;
            while (id < 0) {
                id += 256;
            }
            if (Dimensions.DimensionArray[id] != null && !Dimensions.DimensionArray[id].special_hidden) {
                nextdim = id;
                break;
            }
            ++i;
        }
        double newy = this.findnewy(nextdim, usex, usey, usez);
        Entity rider = this.getRiderEntity();
        if (rider == null) {
            this.dimension = nextdim;
            this.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(this, true);
        } else if (!(rider instanceof Player)) {
            this.dimension = nextdim;
            this.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(this, true);
            rider.dimension = nextdim;
            rider.posy = newy;
            DangerZone.server.sendEntityUpdateToAll(rider, true);
        } else {
            Player pl = (Player)rider;
            Utils.doTeleport(pl, nextdim, usex, newy, usez);
        }
        return newy;
    }

    public double findnewy(int d, double usex, double usey, double usez) {
        int bid = 0;
        int i = 1;
        while (i < 256) {
            bid = this.isRailBlock(d, usex, i, usez, 0.0);
            if (bid != 0) {
                return i;
            }
            ++i;
        }
        i = 255;
        while (i > 0) {
            bid = this.world.getblock(d, (int)usex, i, (int)usez);
            if (bid != 0) {
                return i + 1;
            }
            --i;
        }
        return usey;
    }

    public float getDisplayOffset() {
        int railtype = this.isRailBlock(this.dimension, this.posx, this.posy, this.posz, 0.25);
        if (railtype != 0 && railtype == Blocks.waterstatic.blockID) {
            return 10.0f;
        }
        return 0.0f;
    }
}

