/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.entities;

import dangerzone.DangerZone;
import dangerzone.KVPair;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.Fastmath;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import slick.Texture;

public class EntityArrow
extends Entity {
    public int deathtimer = 600;
    public Entity thrower = null;
    public Entity thrower2 = null;
    public boolean stuck = false;

    public EntityArrow(World w) {
        super(w);
        this.maxrenderdist = 75;
        this.height = 0.25f;
        this.width = 0.25f;
        this.uniquename = "DangerZone:EntityArrow";
        this.movement_friction = false;
        this.setAttackDamage(1.0f);
    }

    @Override
    public void writeSelf(List<KVPair> prop, String tag) {
        super.writeSelf(prop, tag);
        prop.add(new KVPair(String.format("%s%s", tag, "DEATHTIMER"), String.format("%d", this.deathtimer)));
        prop.add(new KVPair(String.format("%s%s", tag, "STUCK"), this.stuck ? "true" : "false"));
    }

    @Override
    public void readSelf(Properties prop, String tag) {
        super.readSelf(prop, tag);
        this.deathtimer = Utils.getPropertyInt(prop, String.format("%s%s", tag, "DEATHTIMER"), 0, 32768, 600);
        this.stuck = Utils.getPropertyBoolean(prop, String.format("%s%s", tag, "STUCK"), true);
    }

    public void setDirectionAndVelocity(float x, float y, float z, float velocity, float variability) {
        this.motionx = x * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motiony = y * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.motionz = z * (velocity + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * variability * velocity);
        this.rotateToDirection();
    }

    @Override
    public void doEntityAction(float deltaT) {
        --this.deathtimer;
        if (this.deathtimer <= 0) {
            this.deadflag = true;
            return;
        }
        if (this.stuck) {
            this.motionz = 0.0f;
            this.motiony = 0.0f;
            this.motionx = 0.0f;
            if (this.world.getblock(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz) == 0) {
                this.deadflag = true;
            }
            return;
        }
        float dist = (float)Math.sqrt(this.motionx * deltaT * this.motionx * deltaT + this.motiony * deltaT * this.motiony * deltaT + this.motionz * deltaT * this.motionz * deltaT);
        float blockdist = 0.0f;
        float edist = 0.0f;
        boolean hitblock = false;
        boolean hitentity = false;
        List<Entity> nearby_list = null;
        Entity enthit = null;
        Entity ridden = null;
        this.motiony -= 0.16f * deltaT;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(16.0f + dist, this.dimension, this.posx, this.posy, this.posz);
        int lz = 0;
        int ly = 0;
        int lx = 0;
        double fx = this.posx;
        double fy = this.posy;
        double fz = this.posz;
        if (this.thrower != null && (ridden = this.thrower.getRiddenEntity()) == null) {
            ridden = this.thrower.getRiderEntity();
        }
        float omotionx = this.motionx;
        float omotiony = this.motiony;
        float omotionz = this.motionz;
        while (Math.abs(omotionx) > 0.125f || Math.abs(omotiony) > 0.125f || Math.abs(omotionz) > 0.125f) {
            omotionx /= 2.0f;
            omotiony /= 2.0f;
            omotionz /= 2.0f;
        }
        float nextf = 1.0f;
        while (dist > 0.0f && blockdist < dist) {
            fx = this.posx + (double)(omotionx * nextf);
            fy = this.posy + (double)(omotiony * nextf);
            fz = this.posz + (double)(omotionz * nextf);
            int x = (int)fx;
            int y = (int)fy;
            int z = (int)fz;
            ListIterator<Entity> li = nearby_list.listIterator();
            while (li.hasNext()) {
                enthit = li.next();
                if (enthit == this || enthit.canthitme || enthit == this.thrower || enthit == ridden || enthit == this.thrower2 || !(fy > enthit.posy) || !(fy < enthit.posy + (double)enthit.getHeight())) continue;
                edist = (float)enthit.getDistanceFromEntityCenter(fx, fy, fz);
                edist -= this.getWidth() / 2.0f;
                if (!((edist -= enthit.getWidth() / 2.0f) < 0.0f)) continue;
                hitentity = true;
                break;
            }
            if (hitentity) break;
            if (x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = this.world.getblock(this.dimension, x, y, z);
                if (bid != 0) {
                    if (Blocks.isLiquid(bid)) {
                        this.motionx *= 0.9f;
                        this.motionz *= 0.9f;
                        this.motiony *= 0.9f;
                    } else if (Blocks.isSquishy(bid) || Blocks.isSolid(bid)) {
                        hitblock = true;
                        break;
                    }
                }
            }
            this.doSpecialEffects(fx, fy, fz);
            blockdist = (float)Math.sqrt(omotionx * nextf * omotionx * nextf + omotiony * nextf * omotiony * nextf + omotionz * nextf * omotionz * nextf);
            nextf += 1.0f;
        }
        if (hitentity || hitblock) {
            this.posx = fx;
            this.posy = fy;
            this.posz = fz;
            this.doHitSomething(hitblock, fx, fy, fz, hitentity, hitentity ? enthit : null);
            if (hitentity) {
                this.deadflag = true;
            }
            this.rotateToDirection();
            this.setVarFloat(5, this.rotation_pitch);
            this.setVarFloat(6, this.rotation_yaw);
            this.motionz = 0.0f;
            this.motiony = 0.0f;
            this.motionx = 0.0f;
            this.stuck = true;
            return;
        }
    }

    public void play_arrow_hit_sound() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            this.world.playSound("DangerZone:arrow_hit1", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.4f);
        }
        if (which == 1) {
            this.world.playSound("DangerZone:arrow_hit2", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.4f);
        }
        if (which == 2) {
            this.world.playSound("DangerZone:arrow_hit3", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.4f);
        }
        if (which == 3) {
            this.world.playSound("DangerZone:arrow_hit4", this.dimension, this.posx, this.posy, this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.4f);
        }
    }

    @Override
    public void update(float deltaT) {
        this.rotation_pitch_motion = 0.0f;
        this.rotation_yaw_motion = 0.0f;
        this.rotation_roll_motion = 0.0f;
        if (!this.world.isServer) {
            this.rotateToDirection();
            if (this.getOnFire() > 0 && Fastmath.nextInt(20) == 1) {
                DangerZone.addLightingRequest(this.dimension, (int)this.posx, (int)this.posy, (int)this.posz, 0.35f);
            }
        }
        super.update(deltaT);
    }

    @Override
    public void doAttackFrom(Entity e, int dt, float ouch) {
        EntityBlockItem ee = (EntityBlockItem)this.world.createEntityByName(DangerZone.blockitemname, this.dimension, this.posx, this.posy, this.posz);
        if (ee != null) {
            ee.fill(this.getBID(), this.getIID(), 1);
            this.world.spawnEntityInWorld(ee);
        }
        this.play_arrow_hit_sound();
        this.deadflag = true;
    }

    public void doSpecialEffects(double x, double y, double z) {
        if (this.world.rand.nextInt(50) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleSmoke", 1, this.dimension, x, y, z);
        }
        if (this.getOnFire() > 0 && this.world.rand.nextInt(50) == 0) {
            Utils.spawnParticlesFromServer(this.world, "DangerZone:ParticleFire", 1, this.dimension, x, y, z);
        }
    }

    public void rotateToDirection() {
        if (this.motionx == 0.0f && this.motiony == 0.0f && this.motionz == 0.0f) {
            this.rotation_pitch = this.getVarFloat(5);
            this.rotation_yaw = this.getVarFloat(6);
            return;
        }
        float tdir = (float)Math.atan2(this.motionx, this.motionz);
        float dx = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        float dz = (float)Math.atan2(-this.motiony, dx);
        this.rotation_pitch = (float)Math.toDegrees(dz);
        this.rotation_yaw = (float)Math.toDegrees(tdir);
        this.rotation_roll = 0.0f;
    }

    public void doHitSomething(boolean hb, double x, double y, double z, boolean he, Entity ent) {
        if (he && ent != null) {
            ent.doAttackFrom(this.thrower, 8, this.getAttackDamage());
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleHurt", 25, this.dimension, x, y, z, 0, 0.25f * (ent.getWidth() + ent.getHeight()) / 4.0f);
            int fire = this.getOnFire();
            if (fire > 0) {
                ent.setOnFire(fire);
            }
        } else {
            Utils.spawnParticlesFromServerScaled(this.world, "DangerZone:ParticleBreak", 25, this.dimension, x, y, z, 0, 0.5f);
        }
        this.play_arrow_hit_sound();
    }

    @Override
    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture("res/skins/Arrowtexture.png");
        }
        return this.texture;
    }
}

