/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.blocks.ModelLadder;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import dangerzone.rendering.WorldRenderer;
import dangerzone.threads.VBODataBuilderThread;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;
import slick.Texture;

public class Ladder
extends Block {
    private static ModelLadder mdl = null;
    private String fulltexturestring = null;
    private Texture fulltexture = null;

    public Ladder(String n, String flattxt, String txt) {
        super(n, flattxt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.hasOwnRenderer = true;
        this.alwaysRender = true;
        this.maxdamage = 3;
        this.burntime = 90;
        this.friction = 0.65f;
        this.fulltexturestring = txt;
        this.breaksound = "DangerZone:woodbreak";
        this.placesound = "DangerZone:woodplace";
        this.hitsound = "DangerZone:woodhit";
        if (mdl == null) {
            mdl = new ModelLadder();
        }
    }

    @Override
    public String getStepSound() {
        int i = DangerZone.rand.nextInt(4);
        if (i == 0) {
            return "DangerZone:wood1";
        }
        if (i == 1) {
            return "DangerZone:wood2";
        }
        if (i == 2) {
            return "DangerZone:wood3";
        }
        return "DangerZone:wood4";
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = 0;
        int meta = w.getblockmeta(d, x, y, z);
        int meta2 = 0;
        if (!w.isServer) {
            return;
        }
        if (w.getblock(d, x, y, z) != this.blockID) {
            return;
        }
        switch (meta >> 8) {
            case 1: {
                bid = w.getblock(d, x, y, z - 1);
                break;
            }
            case 2: {
                bid = w.getblock(d, x, y, z + 1);
                break;
            }
            case 3: {
                bid = w.getblock(d, x + 1, y, z);
                break;
            }
            case 4: {
                bid = w.getblock(d, x - 1, y, z);
                break;
            }
        }
        if (!(Blocks.isSolid(bid) || Blocks.isSolid(w.getblock(d, x, y + 1, z)) || Blocks.isSolid(w.getblock(d, x, y - 1, z)))) {
            bid = w.getblock(d, x, y + 1, z);
            meta2 = w.getblockmeta(d, x, y + 1, z);
            if (bid != this.blockID && meta != meta2) {
                bid = w.getblock(d, x, y - 1, z);
                meta2 = w.getblockmeta(d, x, y - 1, z);
                if (bid != this.blockID && meta != meta2) {
                    if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
                        return;
                    }
                    w.setblock(d, x, y, z, 0);
                    EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (e != null) {
                        e.fill(this, 1);
                        w.spawnEntityInWorld(e);
                    }
                }
            }
        }
    }

    @Override
    public boolean doPlaceBlock(int focusbid, Player p, World w, int dimension, int x, int y, int z, int side) {
        if (!Blocks.isSolid(focusbid)) {
            return false;
        }
        if (Blocks.isLeaves(focusbid)) {
            return false;
        }
        if (!BreakChecks.canChangeBlock(p, dimension, x, y, z, this.blockID, 0)) {
            return false;
        }
        switch (side) {
            case 1: {
                w.setblockandmeta(dimension, x, y, z + 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z + 1);
                break;
            }
            case 2: {
                w.setblockandmeta(dimension, x, y, z - 1, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x, y, z - 1);
                break;
            }
            case 3: {
                w.setblockandmeta(dimension, x - 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x - 1, y, z);
                break;
            }
            case 4: {
                w.setblockandmeta(dimension, x + 1, y, z, this.blockID, side << 8);
                this.onBlockPlaced(w, dimension, x + 1, y, z);
                break;
            }
            default: {
                return false;
            }
        }
        w.playSound(Blocks.getPlaceSound(this.blockID), dimension, x, y, z, 0.5f, 1.0f);
        return true;
    }

    @Override
    public Texture getTexture(int side) {
        if (this.texture == null || this.fulltexture == null) {
            this.texture = this.initBlockTexture(this.texturepath);
            this.fulltexture = this.initBlockTexture(this.fulltexturestring);
        }
        if (side == 5) {
            return this.fulltexture;
        }
        return this.texture;
    }

    @Override
    public String getStitchedTextureName(int side) {
        return this.fulltexturestring;
    }

    @Override
    public void renderMeToVBO(long[] chunkvbos, WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus, int xo, int yo, int zo, VBODataBuilderThread builder) {
        VBOBuffer v = null;
        StitchedTexture st = null;
        st = builder.findVBOtextureforblockside(5, bid);
        if (st == null) {
            return;
        }
        v = builder.findOrMakeVBOForTexture(chunkvbos, st, this.isTranslucent);
        if (v == null) {
            return;
        }
        switch (meta >> 8) {
            case 1: {
                Ladder.mdl.side1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.side2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.side3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.side4.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung3a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung4a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung1b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung2b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung3b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                Ladder.mdl.rung4b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 90);
                break;
            }
            case 3: {
                Ladder.mdl.side1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.side2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.side3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.side4.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung3a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung4a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung1b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung2b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung3b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                Ladder.mdl.rung4b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 180);
                break;
            }
            case 2: {
                Ladder.mdl.side1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.side2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.side3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.side4.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung3a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung4a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung1b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung2b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung3b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                Ladder.mdl.rung4b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, -90);
                break;
            }
            case 4: {
                Ladder.mdl.side1.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.side2.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.side3.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.side4.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung1a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung2a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung3a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung4a.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung1b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung2b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung3b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                Ladder.mdl.rung4b.renderToVBO(v, st, builder.cbr, builder.cbg, builder.cbb, xo, yo, zo, 0);
                break;
            }
        }
    }

    @Override
    public void renderMeHeld(WorldRenderer wr, Entity e, int bid, boolean isdisplay) {
        if (e == null) {
            return;
        }
        MatrixStack.pushMatrix();
        MatrixStack.translate(12.0f, -4.0f, -2.0f);
        MatrixStack.scale(2.0f, 2.0f, 2.0f);
        MatrixStack.sendCurrentStack();
        this.renderMe(wr, e.world, e.dimension, (int)e.posx, (int)e.posy, (int)e.posz, bid, 256, 0, false);
        MatrixStack.popMatrix();
    }

    @Override
    public void renderMe(WorldRenderer wr, World w, int d, int x, int y, int z, int bid, int meta, int sides, boolean focus) {
        wr.loadtextureforblockside(5, bid, false);
        MatrixStack.pushMatrix();
        switch (meta >> 8) {
            case 0: 
            case 1: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                Ladder.mdl.side1.render(1.0f);
                Ladder.mdl.side2.render(1.0f);
                Ladder.mdl.side3.render(1.0f);
                Ladder.mdl.side4.render(1.0f);
                Ladder.mdl.rung1a.render(1.0f);
                Ladder.mdl.rung2a.render(1.0f);
                Ladder.mdl.rung3a.render(1.0f);
                Ladder.mdl.rung4a.render(1.0f);
                Ladder.mdl.rung1b.render(1.0f);
                Ladder.mdl.rung2b.render(1.0f);
                Ladder.mdl.rung3b.render(1.0f);
                Ladder.mdl.rung4b.render(1.0f);
                break;
            }
            case 3: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                Ladder.mdl.side1.render(1.0f);
                Ladder.mdl.side2.render(1.0f);
                Ladder.mdl.side3.render(1.0f);
                Ladder.mdl.side4.render(1.0f);
                Ladder.mdl.rung1a.render(1.0f);
                Ladder.mdl.rung2a.render(1.0f);
                Ladder.mdl.rung3a.render(1.0f);
                Ladder.mdl.rung4a.render(1.0f);
                Ladder.mdl.rung1b.render(1.0f);
                Ladder.mdl.rung2b.render(1.0f);
                Ladder.mdl.rung3b.render(1.0f);
                Ladder.mdl.rung4b.render(1.0f);
                break;
            }
            case 2: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                Ladder.mdl.side1.render(1.0f);
                Ladder.mdl.side2.render(1.0f);
                Ladder.mdl.side3.render(1.0f);
                Ladder.mdl.side4.render(1.0f);
                Ladder.mdl.rung1a.render(1.0f);
                Ladder.mdl.rung2a.render(1.0f);
                Ladder.mdl.rung3a.render(1.0f);
                Ladder.mdl.rung4a.render(1.0f);
                Ladder.mdl.rung1b.render(1.0f);
                Ladder.mdl.rung2b.render(1.0f);
                Ladder.mdl.rung3b.render(1.0f);
                Ladder.mdl.rung4b.render(1.0f);
                break;
            }
            case 4: {
                MatrixStack.translate(0.0f, -8.0f, 0.0f);
                MatrixStack.sendCurrentStack();
                Ladder.mdl.side1.render(1.0f);
                Ladder.mdl.side2.render(1.0f);
                Ladder.mdl.side3.render(1.0f);
                Ladder.mdl.side4.render(1.0f);
                Ladder.mdl.rung1a.render(1.0f);
                Ladder.mdl.rung2a.render(1.0f);
                Ladder.mdl.rung3a.render(1.0f);
                Ladder.mdl.rung4a.render(1.0f);
                Ladder.mdl.rung1b.render(1.0f);
                Ladder.mdl.rung2b.render(1.0f);
                Ladder.mdl.rung3b.render(1.0f);
                Ladder.mdl.rung4b.render(1.0f);
                break;
            }
        }
        MatrixStack.popMatrix();
    }
}

