/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.blocks;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.BlockCorn;
import dangerzone.blocks.Blocks;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.MonarchCaterpillar;
import dangerzone.items.Items;
import dangerzone.world.BreakChecks;
import dangerzone.world.World;

public class BlockMilkweed
extends BlockCorn {
    public BlockMilkweed(String n, String txt) {
        super(n, txt);
        this.isSolidForRendering = false;
        this.isSolid = false;
        this.breaksound = "DangerZone:leavesbreak";
        this.placesound = "DangerZone:leavesplace";
        this.hitsound = "DangerZone:leaves_hit";
        this.isLeaves = true;
        this.randomtick = true;
        this.maxdamage = 5;
        this.showInInventory = false;
        this.hasOwnRenderer = true;
        this.burntime = 15;
    }

    @Override
    public void notifyNeighborChanged(World w, int d, int x, int y, int z) {
        int bid = w.getblock(d, x, y - 1, z);
        if (bid != Blocks.dirt.blockID && bid != Blocks.grassblock.blockID && bid != Blocks.milkweed_plant.blockID && bid != Blocks.milkweed_plant1.blockID && bid != Blocks.milkweed_plant2.blockID && bid != Blocks.milkweed_plant3.blockID) {
            w.setblock(d, x, y, z, 0);
            if (this.blockID == Blocks.milkweed_plant3.blockID) {
                int i = w.rand.nextInt(3) + 1;
                int j = 0;
                while (j < i) {
                    EntityBlockItem e = (EntityBlockItem)w.createEntityByName(DangerZone.blockitemname, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    if (e != null) {
                        e.fill(Items.milkweed_seed, 1);
                        w.spawnEntityInWorld(e);
                    }
                    Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                    ++j;
                }
            }
        }
    }

    @Override
    public int getBlockDrop(Player p, World w, int dimension, int x, int y, int z) {
        return 0;
    }

    @Override
    public int getItemDrop(Player p, World w, int d, int x, int y, int z) {
        if (this.blockID == Blocks.milkweed_plant3.blockID) {
            Utils.spawnExperience(1, w, d, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            return Items.milkweed_seed.itemID;
        }
        return 0;
    }

    @Override
    public int getDropCount(Player p, World w, int d, int x, int y, int z) {
        if (this.blockID == Blocks.milkweed_plant3.blockID) {
            int i = w.rand.nextInt(7) + 3;
            return i;
        }
        return 0;
    }

    @Override
    public void tickMe(World w, int d, int x, int y, int z) {
        int bid;
        if (this.blockID != Blocks.milkweed_plant.blockID && this.blockID != Blocks.milkweed_plant1.blockID) {
            return;
        }
        int Height = 1;
        boolean dontGrow = false;
        if (w.rand.nextInt(10) != 1) {
            return;
        }
        if (!BreakChecks.canChangeBlock(w, d, x, y, z, d, x, y, z, 0, 0)) {
            return;
        }
        int myMaxHeight = w.getblockmeta(d, x, y, z);
        if ((myMaxHeight &= 0xF) == 0) {
            myMaxHeight = 3 + w.rand.nextInt(4);
        }
        if ((bid = w.getblock(d, x, y + 1, z)) == 0) {
            int var6 = 1;
            while (var6 < 10) {
                bid = w.getblock(d, x, y - var6, z);
                if (bid != Blocks.milkweed_plant.blockID && bid != Blocks.milkweed_plant1.blockID && bid != Blocks.milkweed_plant2.blockID && bid != Blocks.milkweed_plant3.blockID) break;
                ++Height;
                if (bid == Blocks.milkweed_plant2.blockID || bid == Blocks.milkweed_plant3.blockID) {
                    dontGrow = true;
                }
                ++var6;
            }
            if (dontGrow) {
                myMaxHeight = Height;
            }
            if (Height < myMaxHeight) {
                w.setblockandmeta(d, x, y + 1, z, Blocks.milkweed_plant.blockID, myMaxHeight);
                w.setblockandmeta(d, x, y, z, Blocks.milkweed_plant1.blockID, myMaxHeight);
            } else {
                int i = 1;
                while (i < myMaxHeight - 1) {
                    bid = w.getblock(d, x, y - i, z);
                    if (bid == Blocks.milkweed_plant1.blockID && w.rand.nextInt(2) == 0) {
                        w.setblockandmeta(d, x, y - i, z, Blocks.milkweed_plant2.blockID, myMaxHeight);
                    } else if (bid == Blocks.milkweed_plant2.blockID && w.rand.nextInt(2) == 0) {
                        w.setblockandmeta(d, x, y - i, z, Blocks.milkweed_plant3.blockID, myMaxHeight);
                    }
                    ++i;
                }
            }
            var6 = 1;
            while (var6 < 10) {
                bid = w.getblock(d, x, y - var6, z);
                if ((bid == Blocks.milkweed_plant.blockID || bid == Blocks.milkweed_plant1.blockID || bid == Blocks.milkweed_plant2.blockID || bid == Blocks.milkweed_plant3.blockID) && w.rand.nextBoolean()) {
                    this.spawnCaterpillar(w, d, x, y - var6, z);
                }
                ++var6;
            }
        }
    }

    public void spawnCaterpillar(World world, int d, int x, int y, int z) {
        double px = x;
        double py = y;
        double pz = z;
        if (world.rand.nextInt(5) != 1) {
            return;
        }
        px += (double)(world.rand.nextInt(4) - world.rand.nextInt(4));
        pz += (double)(world.rand.nextInt(4) - world.rand.nextInt(4));
        int i = -5;
        while (i <= 5) {
            MonarchCaterpillar sc;
            int bid = world.getblock(d, (int)px, (int)py + i, (int)pz);
            if (bid == 0 && (bid = world.getblock(d, (int)px, (int)py + i - 1, (int)pz)) != 0 && (sc = (MonarchCaterpillar)world.createEntityByName("DangerZone:Monarch Caterpillar", d, px, py + (double)i, pz)) != null) {
                sc.init();
                world.spawnEntityInWorld(sc);
                break;
            }
            ++i;
        }
    }
}

