/*
 * Decompiled with CFR 0.152.
 */
package dangerzone;

import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.TargetInfo;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlockItem;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.rendering.Fastmath;
import dangerzone.world.World;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class VRHitHandler {
    public int focus_x;
    public int focus_y;
    public int focus_z;
    public int focus_side;
    public double poi_x;
    public double poi_y;
    public double poi_z;
    public int focus_bid;
    public int focus_meta;
    public float focus_damage = 0.0f;
    public float focus_maxdamage = 0.0f;
    public float focus_dist = 0.0f;
    public Entity focus_entity = null;
    private boolean new_contact = false;
    private double prev_fx;
    private double prev_fy;
    private double prev_fz;
    private double prev_dx;
    private double prev_dy;
    private double prev_dz;
    private int lfx;
    private int lfy;
    private int lfz;

    public boolean check_for_contact(World w, TargetInfo ti, float swing_speed, float angular_swing_speed, boolean first, int fps) {
        double fx = ti.real_posx;
        double fy = ti.real_posy;
        double fz = ti.real_posz;
        double dx = ti.dx;
        double dy = ti.dy;
        double dz = ti.dz;
        if (first) {
            this.focus_meta = 0;
            this.focus_bid = 0;
            this.focus_side = 0;
            this.focus_z = 0;
            this.focus_y = 0;
            this.focus_x = 0;
            this.poi_z = 0.0;
            this.poi_y = 0.0;
            this.poi_x = 0.0;
            this.focus_dist = 0.0f;
            this.focus_entity = null;
            this.new_contact = false;
            this.prev_fx = fx;
            this.prev_fy = fy;
            this.prev_fz = fz;
            this.prev_dx = dx;
            this.prev_dy = dy;
            this.prev_dz = dz;
            return this.check_for_contact_do(w, fx, fy, fz, dx, dy, dz);
        }
        if (this.new_contact) {
            return false;
        }
        int ispeed = (int)swing_speed;
        int iaspeed = (int)angular_swing_speed;
        if (ispeed < (iaspeed /= 10)) {
            ispeed = iaspeed;
        }
        if (ispeed < 1) {
            ispeed = 1;
        }
        if (fps < 60) {
            ispeed *= 2;
        }
        if (fps < 30) {
            ispeed *= 2;
        }
        if (fps < 15) {
            ispeed *= 2;
        }
        double dfx = (fx - this.prev_fx) / (double)ispeed;
        double dfy = (fy - this.prev_fy) / (double)ispeed;
        double dfz = (fz - this.prev_fz) / (double)ispeed;
        double ddx = (dx - this.prev_dx) / (double)ispeed;
        double ddy = (dy - this.prev_dy) / (double)ispeed;
        double ddz = (dz - this.prev_dz) / (double)ispeed;
        int i = 0;
        while (i < ispeed) {
            if (this.check_for_contact_do(w, this.prev_fx + dfx * (double)(i + 1), this.prev_fy + dfy * (double)(i + 1), this.prev_fz + dfz * (double)(i + 1), this.prev_dx + ddx * (double)(i + 1), this.prev_dy + ddy * (double)(i + 1), this.prev_dz + ddz * (double)(i + 1))) {
                return true;
            }
            ++i;
        }
        this.prev_fx = fx;
        this.prev_fy = fy;
        this.prev_fz = fz;
        this.prev_dx = dx;
        this.prev_dy = dy;
        this.prev_dz = dz;
        return false;
    }

    public boolean check_for_contact_do(World w, double startx, double starty, double startz, double dx, double dy, double dz) {
        double dist;
        ListIterator<Entity> li;
        double delta = 0.25;
        Entity tempe = null;
        List<Entity> nearby_list = null;
        ArrayList<Entity> check_list = new ArrayList<Entity>();
        int riddenid = 0;
        Entity ridden = DangerZone.player.getRiddenEntity();
        if (ridden != null) {
            riddenid = ridden.entityID;
        }
        double fx = startx;
        double fy = starty + (double)DangerZone.player.getEyeHeight();
        double fz = startz;
        int x = (int)fx;
        int y = (int)fy;
        int z = (int)fz;
        int eyebid = w.getblock(DangerZone.player.dimension, x, y, z);
        float reach = DangerZone.player.getHeight() / 8.0f;
        if (reach < 0.125f) {
            reach = 0.125f;
        }
        float itemwidth = 0.125f;
        InventoryContainer ic = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex());
        if (ic != null) {
            Item itm = ic.getItem();
            if (itm != null) {
                reach += itm.itemreach;
                itemwidth += itm.itemwidth;
            }
            reach += 0.75f * (float)ic.getAttribute(4);
            itemwidth += 0.25f * (float)ic.getAttribute(1);
        }
        if (reach < 0.5f) {
            reach = 0.5f;
        }
        if ((nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(20.0f + reach, DangerZone.player.dimension, DangerZone.player.posx, DangerZone.player.posy, DangerZone.player.posz)) != null && !nearby_list.isEmpty()) {
            li = nearby_list.listIterator();
            while (li.hasNext()) {
                tempe = li.next();
                if (!(tempe instanceof EntityLiving) && !(tempe instanceof EntityBlockItem)) continue;
                dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fy - tempe.posy) * (fy - tempe.posy) + (fz - tempe.posz) * (fz - tempe.posz));
                dist -= 0.125;
                dist -= (double)(tempe.getWidth() / 2.0f);
                if (tempe instanceof EntityBlockItem && dist < 14.0) {
                    check_list.add(tempe);
                    continue;
                }
                if (tempe == DangerZone.player || tempe.canthitme || !(dist < 14.0) || tempe.entityID == riddenid) continue;
                check_list.add(tempe);
            }
        }
        if (ridden != null && dy < -0.75) {
            check_list.add(ridden);
        }
        int lz = 0;
        int ly = 0;
        int lx = 0;
        while (delta < (double)reach) {
            fx = startx + dx * delta;
            fy = starty + dy * delta + (double)DangerZone.player.getEyeHeight();
            fz = startz + dz * delta;
            x = (int)fx;
            y = (int)fy;
            z = (int)fz;
            if (delta < (double)reach - 0.1) {
                if (delta < (double)(reach * 0.67f)) {
                    if (Fastmath.nextBoolean()) {
                        Utils.spawnParticlesScaled(w, "DangerZone:ParticleSmoke", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
                    }
                } else {
                    Utils.spawnParticlesScaled(w, "DangerZone:ParticleHurt", 1, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
                }
            } else {
                Utils.spawnParticlesScaled(w, "DangerZone:ParticleSparkle", 2, DangerZone.player.dimension, fx, fy, fz, 0, 0.125f, false);
            }
            if (delta < (double)reach && check_list != null && !check_list.isEmpty()) {
                li = check_list.listIterator();
                while (li.hasNext()) {
                    Item it;
                    InventoryContainer icc;
                    tempe = li.next();
                    if (!(fy > tempe.posy - (double)itemwidth) || !(fy < tempe.posy + (double)tempe.getHeight() + (double)itemwidth)) continue;
                    dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                    dist -= (double)itemwidth;
                    if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                    if (tempe instanceof EntityLiving) {
                        this.focus_meta = 0;
                        this.focus_bid = 0;
                        this.focus_z = 0;
                        this.focus_y = 0;
                        this.focus_x = 0;
                        this.focus_damage = 0.0f;
                        this.focus_dist = (float)dist;
                        this.focus_entity = tempe;
                        this.poi_x = fx;
                        this.poi_y = fy;
                        this.poi_z = fz;
                        this.lfz = 0;
                        this.lfy = 0;
                        this.lfx = 0;
                        this.new_contact = true;
                        return true;
                    }
                    if (!(tempe instanceof EntityBlockItem) || tempe.deadflag || (icc = DangerZone.player.getHotbar(DangerZone.player.gethotbarindex())) == null || (it = icc.getItem()) == null) continue;
                    it.vr_hit_EntityBlockItem(tempe);
                }
            }
            if (delta < (double)reach && x != lx || y != ly || z != lz) {
                lx = x;
                ly = y;
                lz = z;
                int bid = w.getblock(DangerZone.player.dimension, x, y, z);
                if (eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid)) {
                    bid = 0;
                }
                if (bid != 0) {
                    if (!Blocks.isSolid(bid) && check_list != null) {
                        int tlx = lx;
                        int tlz = lz;
                        int tly = ly;
                        double tdelta = delta;
                        while (tdelta < (double)reach) {
                            fx = startx + dx * delta;
                            fy = starty + dy * delta + (double)DangerZone.player.getEyeHeight();
                            fz = startz + dz * delta;
                            int tx = (int)fx;
                            int ty = (int)fy;
                            int tz = (int)fz;
                            if (tx != tlx || ty != tly || tz != tlz) {
                                int tbid = w.getblock(DangerZone.player.dimension, tx, ty, tz);
                                if (Blocks.isSolid(tbid)) break;
                                tlx = tx;
                                tly = ty;
                                tlz = tz;
                            }
                            if (!check_list.isEmpty()) {
                                li = check_list.listIterator();
                                while (li.hasNext()) {
                                    tempe = li.next();
                                    if (!(fy > tempe.posy - (double)itemwidth) || !(fy < tempe.posy + (double)tempe.getHeight() + (double)itemwidth)) continue;
                                    dist = Math.sqrt((fx - tempe.posx) * (fx - tempe.posx) + (fz - tempe.posz) * (fz - tempe.posz));
                                    dist -= (double)itemwidth;
                                    if (!((dist -= (double)(tempe.getWidth() / 2.0f)) < 0.0)) continue;
                                    this.focus_meta = 0;
                                    this.focus_bid = 0;
                                    this.focus_z = 0;
                                    this.focus_y = 0;
                                    this.focus_x = 0;
                                    this.focus_damage = 0.0f;
                                    this.focus_dist = (float)dist;
                                    this.focus_entity = tempe;
                                    this.poi_x = fx;
                                    this.poi_y = fy;
                                    this.poi_z = fz;
                                    this.lfz = 0;
                                    this.lfy = 0;
                                    this.lfx = 0;
                                    this.new_contact = true;
                                    return true;
                                }
                            }
                            tdelta += 0.1;
                        }
                    }
                    double delta2 = delta;
                    x = (int)(startx + dx * (delta -= (double)0.1f));
                    y = (int)(starty + dy * delta + (double)DangerZone.player.getEyeHeight());
                    z = (int)(startz + dz * delta);
                    lx = x;
                    ly = y;
                    lz = z;
                    while (delta < delta2 + (double)0.01f) {
                        fx = startx + dx * delta;
                        fy = starty + dy * delta + (double)DangerZone.player.getEyeHeight();
                        fz = startz + dz * delta;
                        x = (int)fx;
                        y = (int)fy;
                        z = (int)fz;
                        if (x != lx || y != ly || z != lz) {
                            lx = x;
                            ly = y;
                            lz = z;
                            bid = w.getblock(DangerZone.player.dimension, x, y, z);
                            if (eyebid != 0 && Blocks.isLiquid(eyebid) && Blocks.isLiquid(bid)) {
                                bid = 0;
                            }
                            if (bid != 0) {
                                dx = startx + dx * delta;
                                dy = starty + dy * delta + (double)DangerZone.player.getEyeHeight();
                                dz = startz + dz * delta;
                                dist = 2.0;
                                double lastdist = 2.0;
                                this.focus_side = 0;
                                this.poi_x = fx;
                                this.poi_y = fy;
                                this.poi_z = fz;
                                double sx = (double)x + 0.5;
                                double sy = (double)y + 1.0;
                                double sz = (double)z + 0.5;
                                dist = Math.sqrt((sx - dx) * (sx - dx) + (sy - dy) * (sy - dy) + (sz - dz) * (sz - dz));
                                if (dist < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 0;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.0) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 2;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 1.0) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 1;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.0) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 3;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 1.0) - dx) * (sx - dx) + ((sy = (double)y + 0.5) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 4;
                                }
                                if ((dist = Math.sqrt(((sx = (double)x + 0.5) - dx) * (sx - dx) + ((sy = (double)y + 0.0) - dy) * (sy - dy) + ((sz = (double)z + 0.5) - dz) * (sz - dz))) < lastdist) {
                                    lastdist = dist;
                                    this.focus_side = 5;
                                }
                                this.focus_x = lx;
                                this.focus_y = ly;
                                this.focus_z = lz;
                                this.focus_bid = bid;
                                this.focus_meta = w.getblockmeta(DangerZone.player.dimension, x, y, z);
                                this.focus_dist = (float)delta;
                                this.focus_entity = null;
                                if (this.lfx != this.focus_x || this.lfy != this.focus_y || this.lfz != this.focus_z) {
                                    this.focus_damage = 0.0f;
                                    this.focus_maxdamage = Blocks.getMaxDamage(bid);
                                    if (this.focus_maxdamage < 1.0f) {
                                        this.focus_maxdamage = 1.0f;
                                    }
                                    this.lfx = this.focus_x;
                                    this.lfy = this.focus_y;
                                    this.lfz = this.focus_z;
                                }
                                this.new_contact = true;
                                return true;
                            }
                        }
                        delta += (double)0.01f;
                    }
                }
            }
            delta += 0.1;
        }
        this.focus_meta = 0;
        this.focus_bid = 0;
        this.focus_z = 0;
        this.focus_y = 0;
        this.focus_x = 0;
        this.poi_z = 0.0;
        this.poi_y = 0.0;
        this.poi_x = 0.0;
        this.focus_dist = 0.0f;
        this.focus_entity = null;
        this.new_contact = false;
        return false;
    }
}

