/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackerPose")
public class OVRTrackerPose
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKERFLAGS;
    public static final int POSE;
    public static final int LEVELEDPOSE;

    public OVRTrackerPose(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackerPose.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int TrackerFlags() {
        return OVRTrackerPose.nTrackerFlags(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef Pose() {
        return OVRTrackerPose.nPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef LeveledPose() {
        return OVRTrackerPose.nLeveledPose(this.address());
    }

    public static OVRTrackerPose malloc() {
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRTrackerPose calloc() {
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRTrackerPose create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRTrackerPose create(long address) {
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)address);
    }

    @Nullable
    public static OVRTrackerPose createSafe(long address) {
        return address == 0L ? null : (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRTrackerPose.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRTrackerPose.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static OVRTrackerPose mallocStack() {
        return OVRTrackerPose.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerPose callocStack() {
        return OVRTrackerPose.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerPose mallocStack(MemoryStack stack) {
        return OVRTrackerPose.malloc(stack);
    }

    @Deprecated
    public static OVRTrackerPose callocStack(MemoryStack stack) {
        return OVRTrackerPose.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRTrackerPose.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRTrackerPose.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.calloc(capacity, stack);
    }

    public static OVRTrackerPose malloc(MemoryStack stack) {
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRTrackerPose calloc(MemoryStack stack) {
        return (OVRTrackerPose)OVRTrackerPose.wrap(OVRTrackerPose.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)OVRTrackerPose.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nTrackerFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRACKERFLAGS);
    }

    public static OVRPosef nPose(long struct) {
        return OVRPosef.create(struct + (long)POSE);
    }

    public static OVRPosef nLeveledPose(long struct) {
        return OVRPosef.create(struct + (long)LEVELEDPOSE);
    }

    static {
        Struct.Layout layout = OVRTrackerPose.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)8, (Struct.Member[])new Struct.Member[]{OVRTrackerPose.__member((int)4), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKERFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        LEVELEDPOSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackerPose, Buffer>
    implements NativeResource {
        private static final OVRTrackerPose ELEMENT_FACTORY = OVRTrackerPose.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRTrackerPose getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int TrackerFlags() {
            return OVRTrackerPose.nTrackerFlags(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef Pose() {
            return OVRTrackerPose.nPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef LeveledPose() {
            return OVRTrackerPose.nLeveledPose(this.address());
        }
    }
}

