/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.items;

import OreSpawn.entities.ThrownRock;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TargetInfo;
import dangerzone.entities.Entity;
import dangerzone.items.Item;

public class ItemRock
extends Item {
    public int rocktype = 0;

    public ItemRock(String n, String txt, int rt) {
        super(n, txt);
        this.burntime = 0;
        this.rocktype = rt;
    }

    public boolean onSwingStop(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (holder.world.isServer) {
            if (DangerZone.isVR && holder instanceof Player) {
                TargetInfo ti = DangerZone.weapon_controller;
                ThrownRock e = (ThrownRock)holder.world.createEntityByName("OreSpawn:ThrownRock", holder.dimension, ti.real_posx, ti.real_posy + (double)holder.getEyeHeight(), ti.real_posz);
                if (e != null) {
                    e.init();
                    e.setBID(ic.bid);
                    e.setIID(ic.iid);
                    e.thrower = holder;
                    e.setDirectionAndVelocity(ti.dx, ti.dy, ti.dz, 5.5f, 0.1f);
                    holder.world.spawnEntityInWorld((Entity)e);
                }
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }

    public boolean onRightClick(Entity holder, Entity clickedon, InventoryContainer ic) {
        if (clickedon != null) {
            return false;
        }
        if (holder == null) {
            return false;
        }
        if (DangerZone.isVR) {
            return false;
        }
        if (holder.world.isServer) {
            ThrownRock e = (ThrownRock)holder.world.createEntityByName("OreSpawn:ThrownRock", holder.dimension, holder.posx + (double)((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))), holder.posy + (double)(holder.getHeight() * 9.0f / 10.0f) - (double)((float)Math.sin(Math.toRadians(holder.rotation_pitch_head)) * (holder.getWidth() + 1.0f)), holder.posz + (double)((float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (holder.getWidth() + 1.0f) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(ic.bid);
                e.setIID(ic.iid);
                e.thrower = holder;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(holder.rotation_pitch_head))), (float)Math.cos(Math.toRadians(holder.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(holder.rotation_pitch_head)), 4.5f, 0.2f);
                holder.world.spawnEntityInWorld((Entity)e);
            }
            holder.world.playSound("DangerZone:bow", holder.dimension, holder.posx, holder.posy + (double)holder.getHeight(), holder.posz, 0.5f, 1.0f + (holder.world.rand.nextFloat() - holder.world.rand.nextFloat()) * 0.3f);
            return true;
        }
        return false;
    }

    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int side) {
        if (p != null && p.world.isServer) {
            Entity eb = p.world.createEntityByName("OreSpawn:Rock", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                eb.setBID(this.rocktype);
                eb.setIID(100);
                p.world.spawnEntityInWorld(eb);
            }
            p.world.playSound("DangerZone:pop", dimension, (double)x + 0.5, (double)y + (double)1.05f, (double)z + 0.5, 0.25f, 1.0f + (p.world.rand.nextFloat() - p.world.rand.nextFloat()) * 0.3f);
        }
        return true;
    }
}

