/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Weasel
extends EntityLiving {
    public Texture texture2 = null;
    public Texture texture3 = null;

    public Weasel(World w) {
        super(w);
        this.maxrenderdist = 130;
        this.height = 1.9f;
        this.width = 0.8f;
        this.uniquename = "OreSpawn:Weasel";
        this.moveSpeed = 0.32f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 30;
        this.setExperience(5);
        this.canSwim = true;
        this.enable_avoid = true;
        this.avoiddistance = 25;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
        this.enableBreeding(10);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 8;
        if (w != null && w.isServer) {
            this.setBID(-1);
            this.setBID(DangerZone.rand.nextInt(3));
        }
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.isBaby();
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Weasel;
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.apple.itemID;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        return iid == Items.peach.itemID;
    }

    public boolean shouldAvoidEntity(Entity e) {
        return e instanceof Player;
    }

    public String getLivingSound() {
        return "DangerZone:ratlive";
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyweasel.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        int which;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WeaseltextureWeasel.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/WeaseltextureFerret.png");
            this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/WeaseltextureOtter.png");
        }
        if ((which = this.getBID()) == 1) {
            return this.texture2;
        }
        if (which == 2) {
            return this.texture3;
        }
        return this.texture;
    }
}

