/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.PowerOrb;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import OreSpawn.entities.ThePrincessTeen;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class ThePrincessYoungAdult
extends EntityLivingDragon {
    private int soundcount = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 9.5f;
    int searchcounter = 0;
    float myspeed = 0.33f;
    private int fireballticker = 0;
    private int head1ext = 0;
    private int head2ext = 0;
    private int head3ext = 0;
    private int head1dir = 1;
    private int head2dir = 1;
    private int head3dir = 1;
    Texture texture2 = null;
    int speechcount = 0;

    public ThePrincessYoungAdult(World w) {
        super(w);
        this.maxrenderdist = 250;
        this.height = 11.75f;
        this.width = 10.75f;
        this.uniquename = "OreSpawn:ThePrincessYoungAdult";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(3000.0f);
        this.setHealth(3000.0f);
        this.setDefense(4.0f);
        this.setAttackDamage(105.0f);
        this.movefrequency = 85;
        this.setExperience(4990);
        this.sit_when_riding = false;
        this.takesFallDamage = false;
        this.isImmuneToFire = true;
        this.searchDistance = 128.0f;
        this.enable_taming = true;
        this.maxdisttoowner = 64.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.canFly = true;
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
        this.setSitting(false);
        this.setStaying(false);
        this.setFlying(true);
        this.setGroundFactor(1.5f);
        this.setAirFactor(2.25f);
    }

    public int getHead1Ext() {
        return this.head1ext;
    }

    public int getHead2Ext() {
        return this.head2ext;
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    public void onKill(Entity e) {
        if (e.getWidth() * e.getHeight() > 1.0f) {
            this.setVarInt(22, this.getVarInt(22) + 1);
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/ThePrincessAdulttexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/ThePrincessAdulttexture2.png");
        }
        if (this.getAttacking() || this.getHealth() < this.getMaxHealth() || this.getBID() != 0) {
            return this.texture2;
        }
        return this.texture;
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null && this.getOwnerName() != null && p.getPetName().equals(this.getOwnerName())) {
                if (this.isMountedBy((Entity)p)) {
                    this.unMount((Entity)p);
                } else {
                    this.sit_when_riding = false;
                    this.Mount((Entity)p);
                    this.setSitting(false);
                    this.setStaying(false);
                }
                return false;
            }
            if (ic != null && ic.iid == Items.diamond.itemID && this.getOwnerName() != null && p.myname.equals(this.getOwnerName())) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                ThePrincessTeen sc = (ThePrincessTeen)this.world.createEntityByName("OreSpawn:ThePrincessTeen", this.dimension, this.posx, this.posy, this.posz);
                if (sc != null) {
                    sc.init();
                    sc.setOwnerName(this.getOwnerName());
                    sc.setCanDespawn(false);
                    this.world.spawnEntityInWorld((Entity)sc);
                    this.deadflag = true;
                }
                this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
                return true;
            }
        }
        return super.rightClickedByPlayer(p, ic);
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    public float getRiderYoffset() {
        return 10.25f;
    }

    public float getRiderXZoffset() {
        return 5.25f;
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(6) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            } else if (this.getRiderEntity() == null) {
                this.do_a_distance_attack(this.targetentity);
            }
        }
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(6) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e instanceof SquidGuard) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof KrakenKing) {
            return false;
        }
        if (this.getOwnerName() != null && this.getDistanceFromEntity(e) > (double)(this.maxdisttoowner * 2.0f)) {
            return false;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public String getLivingSound() {
        return null;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        if (e != null && this.isSuitableTarget(e)) {
            this.hurtMe = e;
        }
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
        if (this.hurtMe != null && this.hurtMe instanceof EntityLivingDragon) {
            this.hurtMe = null;
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.world.rand.nextInt(20) == 1) {
            this.heal(10.0f);
        }
        this.speechcount = this.getIID();
        if (this.speechcount > 0 && this.speechcount < 110) {
            this.setIID(this.speechcount + 1);
            if (this.speechcount < 100) {
                if (this.speechcount == 5) {
                    DangerZone.server.sendChatToAll("The Young Adult Princess: No!!! Stop!!! Don't hurt him!!!");
                }
                if (this.speechcount == 40) {
                    DangerZone.server.sendChatToAll("The Young Adult Princess: I love him!!!");
                }
                if (this.speechcount == 80) {
                    DangerZone.server.sendChatToAll("The Young Adult Princess: We are a family now.");
                }
                this.targetentity = null;
                this.target = null;
                this.setAttacking(false);
                this.myspeed = 0.0f;
                Player looktarget = DangerZone.server.findNearestPlayer((Entity)this);
                if (looktarget != null) {
                    if (this.target == null) {
                        this.target = new TargetHelper(this.posx, this.posy, this.posz);
                    }
                    this.target.setTarget(looktarget.posx, looktarget.posy, looktarget.posz);
                }
            }
        } else if (this.myspeed < 1.0f) {
            this.myspeed = 1.25f + this.world.rand.nextFloat() * 0.3f;
        }
        if (this.isFlying()) {
            this.ignoreCollisions = rider == null;
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, this.getLivingSoundVolume(), 1.0f);
                }
            }
        } else {
            this.ignoreCollisions = false;
        }
        if (this.getAttacking()) {
            this.setVarFloat(23, this.getVarFloat(23) + 5.0f);
        } else if (this.getVarFloat(23) > 0.0f && this.world.rand.nextInt(10) == 1) {
            this.setVarFloat(23, this.getVarFloat(23) - 1.0f);
        }
        if (this.getAttacking()) {
            double startz;
            double starty;
            if (this.getPower() > 250.0f) {
                double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() / 2.0f));
                starty = this.posy + (double)(this.getHeight() / 2.0f);
                startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() / 2.0f));
                int howmany = 2 + this.world.rand.nextInt(5);
                int i = 0;
                while (i < howmany) {
                    PowerOrb e = (PowerOrb)this.world.createEntityByName("OreSpawn:PowerOrb", this.dimension, startx, starty, startz);
                    if (e != null) {
                        e.init();
                        e.setBID(1 + this.world.rand.nextInt(4));
                        e.rider = this.getRiderEntity();
                        e.setIID(1);
                        this.world.spawnEntityInWorld((Entity)e);
                    }
                    ++i;
                }
                this.setVarFloat(23, 0.0f);
            }
            if (this.getPower() > 200.0f) {
                double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() / 2.0f));
                starty = this.posy + (double)(this.getHeight() / 2.0f);
                startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() / 2.0f));
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleSparkle", (int)5, (int)this.dimension, (double)startx, (double)starty, (double)startz);
            }
        }
        if (rider == null) {
            if (!this.isFlying()) {
                if (!this.getStaying()) {
                    this.doNormalAttack();
                    if (this.getOwnerName() != null) {
                        double dist = 0.0;
                        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e != null) {
                            dist = this.getDistanceFromEntity(e);
                        }
                        if (dist > (double)(this.maxdisttoowner + 8.0f)) {
                            this.setFlying(true);
                        }
                    }
                    if (this.world.rand.nextInt(250) == 1) {
                        this.setFlying(true);
                    }
                }
                super.doEntityAction(deltaT);
                return;
            }
            this.doFlyingAttack();
            this.doSoloFlying(deltaT);
            this.doLookAction();
            if (this.getOwnerName() != null && this.world.rand.nextInt(250) == 1) {
                this.setFlying(false);
            }
            if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.getOnGround()) {
            this.setFlying(false);
        } else {
            this.setFlying(true);
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        this.doFlyingAttack();
        ++this.fireballticker;
        if (this.fireballticker > 5) {
            this.fireballticker = 6;
        }
        if (rider.getLeft() && this.fireballticker > 2) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
        if (rider.getRight() && this.fireballticker > 2) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
    }

    public float getPower() {
        return this.getVarFloat(23);
    }

    public void doSoloFlying(float deltaT) {
        int bid;
        Entity e;
        int keep_trying = 25;
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        double dist = 0.0;
        int dxz = 45;
        float speedadjust = 1.0f;
        if (this.targetentity != null && !this.targetentity.deadflag) {
            px = this.targetentity.posx;
            py = this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f);
            pz = this.targetentity.posz;
        }
        if (this.getOwnerName() != null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null) {
            px = e.posx;
            py = e.posy + (double)(e.getHeight() / 2.0f);
            pz = e.posz;
            dxz = 32;
            dist = this.getDistanceFromEntity(e);
            if (dist > (double)this.maxdisttoowner) {
                speedadjust = 1.75f;
            }
            if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                speedadjust = 2.75f;
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(100) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            int ground_dist = 0;
            while (ground_dist < 21) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - ground_dist, (int)this.posz);
                if (bid != 0) break;
                ++ground_dist;
            }
            ground_dist = 10 - ground_dist;
            if (this.speechcount == 0 || this.speechcount >= 110) {
                if (this.getOwnerName() == null) {
                    List nearby_list = null;
                    nearby_list = DangerZone.server.entityManager.findEntitiesInRange(256.0f, this.dimension, this.posx, this.posy, this.posz);
                    if (nearby_list != null && !nearby_list.isEmpty()) {
                        Entity e2 = null;
                        ListIterator li = nearby_list.listIterator();
                        while (li.hasNext()) {
                            e2 = (Entity)li.next();
                            if (e2 == this || !(e2 instanceof KrakenKing)) continue;
                            px = e2.posx;
                            py = e2.posy + 8.0;
                            pz = e2.posz;
                            dxz = 32;
                            break;
                        }
                    }
                }
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)ground_dist + (double)(this.world.rand.nextInt(7) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                }
                this.myspeed = 0.75f + this.world.rand.nextFloat() * 0.75f;
            }
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.06f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        if (this.speechcount != 0 && this.speechcount < 100) {
            this.motiony = 0.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 8.0);
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophytheprincessyoungadult.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggtheprincess.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    private void doriderfireball() {
        Entity rider = this.getRiderEntity();
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        double starty = this.posy + (double)this.getJustMyHeight();
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 3.0f / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        float tdirxz = (float)Math.toRadians(rider.rotation_yaw_head);
        float tdiry = (float)Math.toRadians(rider.rotation_pitch_head);
        ThrownFireball e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz);
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(Items.fireball.itemID);
            e.thrower = this;
            e.explosive_power = 10.0f;
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.2f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.6f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            int i;
            int mag = 1;
            if (this.getAttacking()) {
                mag = 3;
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head1dir = mag;
                }
                if (i == 1) {
                    this.head1dir = -mag;
                }
                if (i == 2) {
                    this.head1dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head2dir = mag;
                }
                if (i == 1) {
                    this.head2dir = -mag;
                }
                if (i == 2) {
                    this.head2dir = 0;
                }
            }
            if (this.world.rand.nextInt(10) == 1) {
                i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = mag;
                }
                if (i == 1) {
                    this.head3dir = -mag;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head1ext += this.head1dir;
            if (this.head1ext < 0) {
                this.head1ext = 0;
            }
            if (this.head1ext > 60) {
                this.head1ext = 60;
            }
            this.head2ext += this.head2dir;
            if (this.head2ext < 0) {
                this.head2ext = 0;
            }
            if (this.head2ext > 60) {
                this.head2ext = 60;
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    private void do_a_distance_attack(Entity victim) {
        int which = 2 + this.world.rand.nextInt(3);
        PowerOrb e = (PowerOrb)this.world.createEntityByName("OreSpawn:PowerOrb", this.dimension, this.posx, this.posy, this.posz);
        if (e != null) {
            e.init();
            e.setBID(which);
            e.setIID(1);
            e.rider = this.getRiderEntity();
            if (e.rider == null) {
                e.rider = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
            }
            e.ownername = this.getOwnerName();
            this.world.spawnEntityInWorld((Entity)e);
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public void setBaby(boolean tf) {
    }

    public boolean isBoss() {
        return this.getOwnerName() != null && this.getOwnerName().equals(DangerZone.player.myname);
    }

    public String getBossName() {
        return "The Young Adult Princess";
    }
}

