/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class TRex
extends EntityLiving {
    public TRex(World w) {
        super(w);
        this.maxrenderdist = 160;
        this.height = 3.6f;
        this.width = 1.75f;
        this.uniquename = "OreSpawn:T. Rex";
        this.moveSpeed = 0.33f;
        this.setMaxHealth(250.0f);
        this.setHealth(250.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(35.0f);
        this.searchDistance = 18.0f;
        this.attackRange = 4.25f;
        this.movefrequency = 65;
        this.setExperience(249);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:trex_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:trex_death";
    }

    public void doDeathDrops() {
        int howmany = 6 + this.world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextBoolean()) {
            howmany = 2 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggettitanium.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        } else {
            howmany = 2 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggeturanium.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        }
        if (this.world.rand.nextInt(8) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophytrex.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trextooth.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TRex) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/TRextexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }
}

