/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.Boyfriend;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.LavaLizard;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.Lizard;
import OreSpawn.entities.Squid;
import OreSpawn.entities.ThePrincessYoungAdult;
import dangerzone.DangerZone;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class SquidGuard
extends EntityLiving {
    float myspeed = 0.0f;

    public SquidGuard(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.uniquename = "OreSpawn:SquidGuard";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.setExperience(650);
        this.height = 1.75f;
        this.width = 1.55f;
        this.setMaxHealth(500.0f);
        this.setHealth(500.0f);
        this.setDefense(1.75f);
        this.setAttackDamage(35.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 6.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
        this.isImmuneToFire = true;
        this.canBreateUnderWater = true;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 12) {
            return;
        }
        if (dt == 10) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.05f, 200);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public void doEntityAction(float deltaT) {
        int bid;
        this.do_swarm_despawn();
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(9) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 15;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0) {
            int i = 0;
            while (i < 4) {
                if (this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)i, this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                    bid = 1;
                }
                ++i;
            }
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            int updown = 5;
            int k = 1;
            while (k < 6) {
                bid = this.world.getblock(this.dimension, (int)this.posx, (int)this.posy - k, (int)this.posz);
                if (bid != 0) {
                    updown = -1;
                    break;
                }
                ++k;
            }
            int scount = 0;
            double mposx = this.posx;
            double mposy = this.posy;
            double mposz = this.posz;
            double mdposz = 0.0;
            double mdposx = 0.0;
            List nearby_list = null;
            nearby_list = DangerZone.server.entityManager.findEntitiesInRange(128.0f, this.dimension, this.posx, this.posy, this.posz);
            if (nearby_list != null && !this.getAttacking() && !nearby_list.isEmpty()) {
                Entity e = null;
                Entity ek = null;
                ListIterator li = nearby_list.listIterator();
                while (li.hasNext()) {
                    e = (Entity)li.next();
                    if (e == this) continue;
                    if (e instanceof KrakenKing) {
                        mposx = e.posx;
                        mposz = e.posz;
                        scount = -1;
                        break;
                    }
                    if (e instanceof Kraken && (ek == null || this.getDistanceFromEntity(e) < this.getDistanceFromEntity(ek))) {
                        ek = e;
                    }
                    if (!(e instanceof SquidGuard)) continue;
                    ++scount;
                    mdposx += e.posx;
                    mdposz += e.posz;
                }
                if (scount >= 0) {
                    if (ek != null) {
                        mposx = ek.posx;
                        mposz = ek.posz;
                    } else if (scount != 0) {
                        mposx = mdposx / (double)scount;
                        mposz = mdposz / (double)scount;
                    }
                }
            }
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                if (this.isSwarming()) {
                    this.target.setTarget(mposx + (double)this.world.rand.nextInt(25), mposy + (double)(this.world.rand.nextInt(7) - updown), mposz + (double)this.world.rand.nextInt(25));
                } else {
                    this.target.setTarget(mposx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), mposy + (double)(this.world.rand.nextInt(7) - updown), mposz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                }
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 || bid == Blocks.waterstatic.blockID) {
                    bid = 0;
                    if (!this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((mposx - this.target.targetx) * (mposx - this.target.targetx) + (mposz - this.target.targetz) * (mposz - this.target.targetz) + (mposy - this.target.targety) * (mposy - this.target.targety)))) {
                        bid = 1;
                    }
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.1f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof SquidGuard) {
            return false;
        }
        if (e instanceof Squid) {
            return false;
        }
        if (e instanceof Kraken) {
            return false;
        }
        if (e instanceof KrakenKing) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (e instanceof ThePrincessYoungAdult) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Boyfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Lizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof LavaLizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof LightningLizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof LazerLizard && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)Blocks.stickyblock.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophysquidguard.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/SquidGuardtexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(2) != 1) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "DangerZone:big_splash";
        }
        return "DangerZone:little_splash";
    }
}

