/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Boyfriend;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.LavaLizard;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.Lizard;
import OreSpawn.entities.ThrownWaterball;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Squid
extends EntityLiving {
    public Squid(World w) {
        super(w);
        this.maxrenderdist = 80;
        this.height = 0.75f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:Squid";
        this.moveSpeed = 0.27f;
        this.setMaxHealth(15.0f);
        this.setHealth(15.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(5.0f);
        this.movefrequency = 25;
        this.setExperience(15);
        this.canSwim = true;
        this.swimoffset = 0.25f;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.enable_buddy = true;
        this.findbuddydistance = 20;
        this.findbuddyfrequency = 20;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = false;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Squid;
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.isServer) {
            ThrownWaterball e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 5.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.width / 2.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(OreSpawnMain.waterball.itemID);
                e.thrower = this;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        Entity k;
        super.doAttackFrom(e, dt, pain);
        if (this.deadflag && e != null && e instanceof Player && this.world.rand.nextInt(25) == 2 && (k = this.world.createEntityByName("OreSpawn:Kraken", this.dimension, this.posx + (double)this.world.rand.nextInt(8) - (double)this.world.rand.nextInt(8), 190.0, this.posz + (double)this.world.rand.nextInt(8) - (double)this.world.rand.nextInt(8))) != null) {
            k.init();
            this.world.spawnEntityInWorld(k);
        }
    }

    public String getLivingSound() {
        if (this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return null;
    }

    public String getHurtSound() {
        int i = this.world.rand.nextInt(4);
        if (i == 0) {
            return "OreSpawn:squid_hurt1";
        }
        if (i == 1) {
            return "OreSpawn:squid_hurt2";
        }
        if (i == 2) {
            return "OreSpawn:squid_hurt3";
        }
        return "OreSpawn:squid_hurt1";
    }

    public String getDeathSound() {
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:squid_death1";
        }
        return "OreSpawn:squid_death2";
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Lizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof LavaLizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof LightningLizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof LazerLizard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Girlfriend && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Boyfriend && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophysquid.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)Blocks.stickyblock.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }

    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.enable_findfoodblock = !this.getInLiquid();
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Squidtexture.png");
        }
        return this.texture;
    }
}

