/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Skate
extends EntityLiving {
    public Skate(World w) {
        super(w);
        this.maxrenderdist = 32;
        this.height = 0.35f;
        this.width = 0.75f;
        this.uniquename = "OreSpawn:Skate";
        this.moveSpeed = 0.27f;
        this.setMaxHealth(5.0f);
        this.setHealth(5.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(2.0f);
        this.movefrequency = 25;
        this.setExperience(5);
        this.canSwim = true;
        this.swimoffset = -0.25f;
        this.takesFallDamage = true;
        this.canBreateUnderWater = true;
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
        this.targetLiquidOnly = true;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:little_splat";
    }

    public String getDeathSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ratdead1";
        }
        if (i == 1) {
            return "DangerZone:ratdead2";
        }
        return "DangerZone:ratdead3";
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyskate.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)Blocks.stickyblock.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }

    public void doEntityAction(float deltaT) {
        super.doEntityAction(deltaT);
        this.enable_findfoodblock = !this.getInLiquid();
        if (this.getInLiquid()) {
            Utils.SpawnBubblesAlongPath((EntityLiving)this);
        }
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Skatetexture.png");
        }
        return this.texture;
    }
}

