/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class SeaViper
extends EntityLiving {
    public SeaViper(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.uniquename = "OreSpawn:SeaViper";
        this.moveSpeed = 0.31f;
        this.movefrequency = 65;
        this.setExperience(160);
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.swimoffset = -2.25f;
        this.height = 3.75f;
        this.width = 1.75f;
        this.setMaxHealth(200.0f);
        this.setHealth(200.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 24.0f;
        this.attackRange = 6.5f;
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.05f, 100);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public void doEntityAction(float deltaT) {
        if (this.getInLiquid()) {
            this.moveSpeed = 0.76f;
            this.enable_findfoodblock = false;
        } else {
            this.moveSpeed = 0.32f;
            this.enable_findfoodblock = true;
        }
        super.doEntityAction(deltaT);
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean() && this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return "OreSpawn:seaviper_living";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:seaviper_hit1";
        }
        if (which == 1) {
            return "OreSpawn:seaviper_hit2";
        }
        return "OreSpawn:seaviper_hit3";
    }

    public String getDeathSound() {
        return "OreSpawn:seaviper_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.seavipertongue.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyseaviper.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof SeaViper) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/SeaVipertexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Sea Viper";
    }
}

