/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnUtils;
import OreSpawn.entities.EmperorScorpion;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Scorpion
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public Scorpion(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.95f;
        this.width = 1.25f;
        this.uniquename = "OreSpawn:Scorpion";
        this.moveSpeed = 0.26f;
        this.setMaxHealth(20.0f);
        this.setHealth(20.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(3.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 25;
        this.setExperience(19);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:scorpion_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:cryo_death";
    }

    public void doDeathDrops() {
        int howmany = 2 + this.world.rand.nextInt(3);
        int i = 0;
        while (i < howmany) {
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggettitanium.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            } else {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggeturanium.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyscorpion.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (OreSpawnUtils.isBat(e).booleanValue()) {
            return false;
        }
        if (e instanceof Scorpion) {
            return false;
        }
        if (e instanceof EmperorScorpion) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Scorpiontexture.png");
        }
        return this.texture;
    }
}

