/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RubberDucky
extends EntityLiving {
    public float attackRange = 0.5f;
    public int searchcounter = 0;
    public Entity hurtMe = null;
    public Entity targetentity = null;
    private Texture texture2 = null;
    public RenderInfo renderdata = new RenderInfo();

    public RubberDucky(World w) {
        super(w);
        this.maxrenderdist = 64;
        this.height = 0.33f;
        this.width = 0.25f;
        this.uniquename = "OreSpawn:RubberDucky";
        this.moveSpeed = 0.2f;
        this.setMaxHealth(10.0f);
        this.setHealth(10.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.searchDistance = 12.0f;
        this.attackRange = 0.5f;
        this.movefrequency = 25;
        this.setExperience(19);
        this.canSwim = true;
        this.setBID(0);
    }

    public void doEntityAction(float deltaT) {
        if (this.getBID() != 0) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(30) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom((Entity)this, dt, dmg);
                this.world.playSound("OreSpawn:duck_hurt", this.dimension, this.posx, this.posy, this.posz, 0.75f, 1.0f);
            }
            if (this.world.rand.nextInt(1000) == 1) {
                this.setBID(0);
            }
        }
        if (this.getInLiquid() && this.world.rand.nextInt(3) == 1) {
            this.target = null;
        }
        super.doEntityAction(deltaT);
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    public void doDeathDrops() {
        int ducktries = 10;
        int dist = 6;
        if (this.getIID() < 4) {
            block0: while (ducktries > 0) {
                --ducktries;
                float py = (int)this.posy;
                float px = (int)(this.posx + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
                float pz = (int)(this.posz + (double)(this.world.rand.nextInt(dist) - this.world.rand.nextInt(dist)));
                int i = -3;
                while (i <= 4) {
                    int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
                    if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0) {
                        ducktries = 0;
                        RubberDucky sc = (RubberDucky)this.world.createEntityByName("OreSpawn:RubberDucky", this.dimension, (double)(px += 0.5f), (double)(py += (float)i), (double)(pz += 0.5f));
                        if (sc == null) continue block0;
                        sc.init();
                        sc.setBID(1);
                        sc.setIID(this.getIID() + 1);
                        this.world.spawnEntityInWorld((Entity)sc);
                        continue block0;
                    }
                    ++i;
                }
            }
        } else {
            if (this.world.rand.nextInt(10) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrubberducky.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            Utils.doDropRand((World)this.world, (int)0, (int)Items.feather.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof RubberDucky) {
            return false;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RubberDuckytexture.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/EvilRubberDuckytexture.png");
        }
        if (this.getBID() != 0) {
            return this.texture2;
        }
        return this.texture;
    }
}

