/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RedCow
extends EntityLiving {
    public RedCow(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 1.45f;
        this.width = 0.9f;
        this.uniquename = "OreSpawn:RedCow";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(30.0f);
        this.setHealth(30.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.movefrequency = 55;
        this.setExperience(45);
        this.canSwim = true;
        this.setCanDespawn(false);
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 5;
        this.enableBreeding(10);
        this.isMilkable = true;
        this.enable_buddy = true;
        this.findbuddydistance = 25;
        this.findbuddyfrequency = 25;
    }

    public void doEntityAction(float deltaT) {
        this.findbuddyfrequency = this.isBaby() ? 10 : 35;
        super.doEntityAction(deltaT);
    }

    public boolean isBuddy(Entity e) {
        return e instanceof RedCow;
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID || bid == Blocks.grassblock.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        int bid;
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        if ((bid = this.world.getblock(d, x, y, z)) == Blocks.grass.blockID) {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, 0, 0);
        } else {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, Blocks.dirt.blockID, 0);
        }
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(9);
        if (which == 0) {
            return "OreSpawn:cowmoo1";
        }
        if (which == 1) {
            return "OreSpawn:cowmoo2";
        }
        if (which == 2) {
            return "OreSpawn:cowmoo3";
        }
        if (which == 3) {
            return "OreSpawn:cowmoo4";
        }
        if (which == 4) {
            return "OreSpawn:cowmoo5";
        }
        if (which == 5) {
            return "OreSpawn:cowmoo6";
        }
        if (which == 6) {
            return "OreSpawn:cowmoo7";
        }
        if (which == 7) {
            return "OreSpawn:cowmoo8";
        }
        which = this.world.rand.nextInt(5);
        if (which == 1) {
            return "OreSpawn:cowmoo99";
        }
        return "OreSpawn:cowmoo9";
    }

    public String getHurtSound() {
        return "OreSpawn:duck_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:duck_hurt";
    }

    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.apple.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyredcow.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/red_cow.png");
        }
        return this.texture;
    }
}

