/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Rattlesnake
extends EntityLiving {
    public Rattlesnake(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 0.33f;
        this.width = 0.58f;
        this.uniquename = "OreSpawn:Rattlesnake";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(15.0f);
        this.setHealth(15.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(3.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 35;
        this.setExperience(49);
        this.canSwim = false;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(6, 0.15f, 100);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:Rattlesnake1";
        }
        return "OreSpawn:Rattlesnake2";
    }

    public String getHurtSound() {
        return "OreSpawn:Rattlesnake_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:Rattlesnake_death";
    }

    public void doDeathDrops() {
        int howmany = 1 + this.world.rand.nextInt(4);
        howmany = 1 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.string.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrattlesnake.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Rattlesnake) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RattleSnaketexture.png");
        }
        return this.texture;
    }
}

