/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.Rat;
import dangerzone.entities.TargetHelper;
import dangerzone.world.World;

public class Ratt
extends Rat {
    public Ratt(World w) {
        super(w);
        this.uniquename = "OreSpawn:Ratt";
        this.setCanDespawn(false);
        this.tower_defense_enable = false;
    }

    public void doEntityAction(float deltaT) {
        Entity e;
        if (this.hurtMe != null && this.hurtMe instanceof Player && this.getOwnerName().equals(this.hurtMe.getPetName())) {
            this.hurtMe = null;
        }
        super.doEntityAction(deltaT);
        if (this.target == null && (e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName())) != null && this.getDistanceFromEntity(e) > 6.0) {
            this.findNewTargetNearOwner(e);
        }
    }

    public float getLivingSoundVolume() {
        return 0.25f;
    }

    public void findNewTargetNearOwner(Entity e) {
        if (this.target == null) {
            this.target = new TargetHelper(e.posx, e.posy, e.posz);
        }
        int tries = 8;
        block0: while (tries > 0) {
            --tries;
            double newdir = this.world.rand.nextFloat() - this.world.rand.nextFloat();
            newdir *= 180.0;
            double newdist = 2.0f + this.world.rand.nextFloat() * this.getWidth() * this.getHeight() * 2.0f;
            int intdist = (int)(newdist + (double)0.995f);
            double newx = (float)(e.posx + Math.cos(newdir += (double)this.rotation_yaw) * newdist);
            double newz = (float)(e.posz + Math.sin(newdir) * newdist);
            double newy = e.posy;
            int i = intdist;
            while (i > -intdist) {
                newy = this.posy + (double)i;
                if (!this.isSolidAtLevel(this.dimension, newx, newy + 1.0, newz) && this.isSolidAtLevel(this.dimension, newx, newy, newz) && this.CanProbablySee(this.dimension, newx, newy + 1.0, newz, (int)newdist)) {
                    if (!this.canSwim && Blocks.isLiquid((int)this.world.getblock(this.dimension, (int)newx, (int)newy + 1, (int)newz))) continue block0;
                    newy += 1.0;
                    newy = (int)newy;
                    this.target.setTarget(newx, newy, newz);
                    this.newtargetnow = false;
                    return;
                }
                --i;
            }
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Player && this.getOwnerName().equals(e.getPetName())) {
            return false;
        }
        if (e instanceof Ratt) {
            return false;
        }
        if (e instanceof Cockroach && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }
}

