/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RagingBull
extends EntityLiving {
    public RagingBull(World w) {
        super(w);
        this.maxrenderdist = 190;
        this.height = 3.33f;
        this.width = 1.33f;
        this.uniquename = "OreSpawn:RagingBull";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(150.0f);
        this.setHealth(150.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(12.0f);
        this.searchDistance = 20.0f;
        this.attackRange = 3.5f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.daytimespawn = true;
        this.nighttimespawn = true;
        this.setCanDespawn(false);
        this.temperament = 1;
        this.enable_hostile = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 5;
        this.isMilkable = false;
        this.tower_defense_enable = true;
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:moose_hit";
    }

    public String getDeathSound() {
        return "DangerZone:moose_death";
    }

    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 5 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.monstercheese.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyragingbull.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof RagingBull) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RagingBulltexture.png");
        }
        return this.texture;
    }
}

