/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabyNope;
import OreSpawn.entities.ThrownAcid;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Nope
extends EntityLiving {
    public Nope(World w) {
        super(w);
        this.maxrenderdist = 270;
        this.height = 7.0f;
        this.width = 8.75f;
        this.uniquename = "OreSpawn:Nope";
        this.moveSpeed = 0.38f;
        this.setMaxHealth(1200.0f);
        this.setHealth(1200.0f);
        this.setDefense(5.5f);
        this.setAttackDamage(85.0f);
        this.searchDistance = 64.0f;
        this.attackRange = 8.0f;
        this.movefrequency = 55;
        this.setExperience(1600);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.isServer) {
            ThrownAcid e = (ThrownAcid)this.world.createEntityByName("OreSpawn:ThrownAcid", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 5.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.width / 2.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(OreSpawnMain.acid.itemID);
                e.setAttackDamage(24.0f);
                e.thrower = this;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            if (this.world.rand.nextInt(3) != 1) {
                return;
            }
            double px = (this.posx + victim.posx) / 2.0;
            double py = (this.posy + victim.posy) / 2.0;
            double pz = (this.posz + victim.posz) / 2.0;
            px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
            pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
            int i = -5;
            while (i <= 5) {
                EntityLiving sc;
                int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && (sc = (EntityLiving)this.world.createEntityByName("OreSpawn:BabyNope", this.dimension, px, py + (double)i, pz)) != null) {
                    sc.init();
                    sc.hurtMe = victim;
                    this.world.spawnEntityInWorld((Entity)sc);
                    break;
                }
                ++i;
            }
            if (this.world.rand.nextInt(8) == 0 && this.getNearGround()) {
                this.jumpAtEntity(victim);
            }
        }
    }

    public String getAttackSound() {
        return "OreSpawn:scorpion_attack";
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:nope_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:nope_death";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.molenoidnose.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emperorscorpionscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.mothscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.basiliskscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.raygun.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.greengoo.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.bighammer.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.mantisclaw.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.waterdragonscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophynope.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int howmany = 100 + this.world.rand.nextInt(50);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crabmeat.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 75 + this.world.rand.nextInt(50);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 15 + this.world.rand.nextInt(25);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggnope.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Nope) {
            return false;
        }
        if (e instanceof BabyNope) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Nopetexture.png");
        }
        return this.texture;
    }

    private boolean getNearGround() {
        int solidcount = 0;
        int k = 0;
        while (k < 5 && solidcount < 5) {
            int j = 0;
            while (j >= -5 && solidcount < 5) {
                int bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz + (double)k));
                if (bid != 0 && Blocks.isSolid((int)bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz + (double)k))) != 0 && Blocks.isSolid((int)bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx + (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid((int)bid)) {
                    ++solidcount;
                }
                if ((bid = this.world.getblock(this.dimension, (int)(this.posx - (double)k), (int)this.posy + j, (int)(this.posz - (double)k))) != 0 && Blocks.isSolid((int)bid)) {
                    ++solidcount;
                }
                --j;
            }
            ++k;
        }
        return solidcount >= 5;
    }

    private void jumpAtEntity(Entity victim) {
        this.target = null;
        this.motiony += 1.15f + Math.abs(this.world.rand.nextFloat() * 0.65f);
        double f = this.getHorizontalDistanceFromEntity(victim) / 22.0;
        float tdir = (float)Math.atan2(victim.posx - this.posx, victim.posz - this.posz);
        this.motionx = (float)((double)this.motionx + f * Math.sin(tdir));
        this.motionz = (float)((double)this.motionz + f * Math.cos(tdir));
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "NOPE!!!";
    }
}

