/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Llama
extends EntityLiving {
    private int toggledup = 0;
    Texture texture1 = null;
    Texture texture2 = null;

    public Llama(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 2.25f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Llama";
        this.moveSpeed = 0.4f;
        this.setMaxHealth(35.0f);
        this.setHealth(35.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 55;
        this.setExperience(34);
        this.swimoffset = -1.25f;
        this.setCanDespawn(false);
        this.takesFallDamage = true;
        this.enable_followfood = true;
        this.foodsearchDistance = 16;
        this.canSwim = true;
        this.enable_taming = true;
        this.maxdisttoowner = 24.0f;
        this.enable_droppedfood = true;
        this.enableBreeding(10);
        this.findbuddydistance = 26;
        this.findbuddyfrequency = 26;
        this.enable_buddy = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 60;
        this.foodblockdistxz = 13;
        this.foodblockdisty = 3;
        this.foodblockdisteat = 12;
        this.foodblockheal = 2;
        this.isMilkable = true;
        if (w != null && w.isServer) {
            this.setBID(-1);
            this.setBID(DangerZone.rand.nextInt(3));
        }
        this.setGroundFactor(1.1f);
        this.setAirFactor(1.1f);
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.grass.blockID || bid == Blocks.grassblock.blockID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        int bid;
        if (this.world.rand.nextInt(4) == 1) {
            this.playburp();
        }
        if ((bid = this.world.getblock(d, x, y, z)) == Blocks.grass.blockID) {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, 0, 0);
        } else {
            this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, Blocks.dirt.blockID, 0);
        }
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Llama;
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer && ic == null && (this.getOwnerName() == null || this.getOwnerName() != null && p.myname.equals(this.getOwnerName()))) {
            if (this.isMountedBy((Entity)p)) {
                this.unMount((Entity)p);
            } else {
                this.Mount((Entity)p);
                this.setSitting(false);
                this.setStaying(false);
            }
            return false;
        }
        return super.rightClickedByPlayer(p, ic);
    }

    public float getRiderYoffset() {
        if (this.isBaby()) {
            return 0.3625f;
        }
        return 1.45f;
    }

    public float getRiderXZoffset() {
        if (this.isBaby()) {
            return -0.0625f;
        }
        return -0.25f;
    }

    public void doEntityAction(float deltaT) {
        this.findbuddyfrequency = this.isBaby() ? 6 : 26;
        Entity rider = this.getRiderEntity();
        if (rider == null) {
            super.doEntityAction(deltaT);
            return;
        }
        if (!(rider instanceof Player)) {
            super.doEntityAction(deltaT);
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (!rider.getUp()) {
            this.toggledup = 0;
        }
        if (this.getOnGround() && rider.getUp() && this.toggledup == 0) {
            this.toggledup = 1;
            rider.jump(2.0f);
        }
    }

    public boolean isFoodItem(int foodid) {
        return foodid == Items.corn.itemID;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "DangerZone:goose_hit";
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyllama.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)Items.ostrichmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int i = 2 + this.world.rand.nextInt(8);
        int j = 0;
        while (j < i) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)1.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++j;
        }
        if (this.world.rand.nextInt(1000) == 42) {
            j = 0;
            while (j < 500) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.furball.itemID, (float)3.5f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++j;
            }
        }
    }

    public Texture getTexture() {
        int which;
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Llamatexture.png");
            this.texture1 = TextureMapper.getTexture((String)"orespawnres/skins/Llamatexture2.png");
            this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/Llamatexture3.png");
        }
        if ((which = this.getBID()) == 1) {
            return this.texture1;
        }
        if (which == 2) {
            return this.texture2;
        }
        return this.texture;
    }
}

