/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Kraken;
import OreSpawn.entities.KrakenKing;
import OreSpawn.entities.LavaLizard;
import OreSpawn.entities.LazerLizard;
import OreSpawn.entities.LightningLizard;
import OreSpawn.entities.NastysaurusPrime;
import OreSpawn.entities.Needlenose;
import OreSpawn.entities.Squid;
import OreSpawn.entities.SquidGuard;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Lizard
extends EntityLiving {
    Entity targetentity = null;
    float attackRange = 0.0f;
    int searchcounter = 0;

    public Lizard(World w) {
        super(w);
        this.maxrenderdist = 110;
        this.height = 1.1f;
        this.width = 1.5f;
        this.uniquename = "OreSpawn:Lizard";
        this.moveSpeed = 0.3f;
        this.setMaxHealth(50.0f);
        this.setHealth(50.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.movefrequency = 50;
        this.setExperience(33);
        this.canSwim = true;
        this.attackRange = 3.5f;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = false;
        this.nighttimedespawn = true;
        this.enable_buddy = true;
        this.findbuddydistance = 20;
        this.searchDistance = 24.0f;
        this.enable_droppedfood = true;
        this.foodsearchDistance = 12;
        this.enableBreeding(10);
        this.enableTaming(20);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 100;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof Lizard;
    }

    public void init() {
        super.init();
        this.setSinging(false);
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == OreSpawnMain.crystalapple.itemID) {
            return true;
        }
        return this.isFoodForMe(bid, iid);
    }

    public boolean isFoodItem(int foodid) {
        if (foodid == Items.deadbug.itemID) {
            return true;
        }
        return foodid == Items.fishmeat.itemID;
    }

    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10 && this.world.rand.nextInt(3) == 0) {
            this.searchcounter = this.world.rand.nextInt(4);
            this.targetentity = this.findSomethingToAttack();
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity.posx, this.targetentity.posy, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(10) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            this.targetentity.doAttackFrom((Entity)this, 4, this.getAttackDamage());
        }
        super.doEntityAction(deltaT);
    }

    public void onKill(Entity e) {
        this.heal(1.0f);
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        Entity princess;
        if (this.world.isServer && p != null && ic == null && (princess = this.world.createEntityByName("OreSpawn:Girlfriend", this.dimension, this.posx, this.posy, this.posz)) != null) {
            princess.init();
            princess.setVarInt(21, 1 + this.world.rand.nextInt(2));
            princess.setMaxHealth(100.0f);
            princess.setOwnerName(p.myname);
            Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)20, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
            princess.setHealth(princess.getMaxHealth());
            this.world.spawnEntityInWorld(princess);
            this.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
            this.deadflag = true;
        }
        return false;
    }

    public boolean isSuitableTarget(Entity e) {
        if (DangerZone.playnicely) {
            return false;
        }
        if (e.deadflag) {
            return false;
        }
        if (e instanceof LightningLizard) {
            return false;
        }
        if (e instanceof LavaLizard) {
            return false;
        }
        if (e instanceof LazerLizard) {
            return false;
        }
        if (e instanceof Lizard) {
            return false;
        }
        if (e instanceof Needlenose) {
            return false;
        }
        if (e instanceof NastysaurusPrime) {
            return false;
        }
        if (e.getWidth() * e.getHeight() < 0.53f && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Squid && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Kraken && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof SquidGuard && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof KrakenKing && this.CanProbablySeeEntity(e);
    }

    public void update(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(10000) == 1 && this.getCanDespawn()) {
            this.deadflag = true;
        }
        super.update(deltaT);
    }

    public String getLivingSound() {
        return null;
    }

    public String getDeathSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)Blocks.flower_red.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophylizard.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Lizardtexture.png");
        }
        return this.texture;
    }
}

