/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.SpitBug;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class JumpyBug
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public JumpyBug(World w) {
        super(w);
        this.maxrenderdist = 220;
        this.height = 3.95f;
        this.width = 4.25f;
        this.uniquename = "OreSpawn:JumpyBug";
        this.moveSpeed = 0.35f;
        this.setMaxHealth(400.0f);
        this.setHealth(400.0f);
        this.setDefense(4.0f);
        this.setAttackDamage(55.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 5.5f;
        this.movefrequency = 65;
        this.setExperience(599);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        super.doAttack(victim);
        if (this.world.rand.nextInt(3) == 1) {
            this.jumpAtEntity(victim);
        }
    }

    private void jumpAtEntity(Entity victim) {
        this.target = null;
        this.motiony += 1.5f + Math.abs(this.world.rand.nextFloat() * 1.5f);
        double f = this.getHorizontalDistanceFromEntity(victim) / 10.0;
        float tdir = (float)Math.atan2(victim.posx - this.posx, victim.posz - this.posz);
        this.motionx = (float)((double)this.motionx + f * Math.sin(tdir));
        this.motionz = (float)((double)this.motionz + f * Math.cos(tdir));
    }

    public void doDistanceAttack(Entity victim) {
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        if (this.world.rand.nextBoolean()) {
            if (this.getOnGround()) {
                this.jumpAtEntity(victim);
            }
        } else if (this.world.rand.nextBoolean()) {
            px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 6.0f);
            pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 6.0f);
            int i = -5;
            while (i <= 5) {
                SpitBug sc;
                int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && (sc = (SpitBug)this.world.createEntityByName("OreSpawn:SpitBug", this.dimension, px, py + (double)i, pz)) != null) {
                    sc.init();
                    sc.hurtMe = victim;
                    this.world.spawnEntityInWorld((Entity)sc);
                }
                ++i;
            }
        }
    }

    public String getLivingSound() {
        return "OreSpawn:clatter";
    }

    public String getHurtSound() {
        return "OreSpawn:crunch";
    }

    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    public void doDeathDrops() {
        int howmany = 10 + this.world.rand.nextInt(20);
        int i = 0;
        while (i < howmany) {
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggettitanium.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            } else {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggeturanium.itemID, (float)6.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethyst.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.blockamethyst.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethysthelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethystsword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethysthoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.jumpybugscale.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyjumpybug.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof JumpyBug) {
            return false;
        }
        if (e instanceof SpitBug) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/JumpyBugtexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Jumpy Bug";
    }
}

