/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Flattop
extends EntityLiving {
    public Flattop(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.height = 0.95f;
        this.width = 2.28f;
        this.uniquename = "OreSpawn:Flattop";
        this.moveSpeed = 0.37f;
        this.setMaxHealth(125.0f);
        this.setHealth(125.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(13.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 2.25f;
        this.movefrequency = 40;
        this.setExperience(409);
        this.canSwim = false;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:creaky1";
        }
        return "OreSpawn:creaky2";
    }

    public String getHurtSound() {
        return "OreSpawn:creaky_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:creaky_death";
    }

    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 2 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.table.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 2 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.stand.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(2) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyflattop.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Flattop) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Flattoptexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }
}

