/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Firefly
extends EntityLiving {
    float myspeed = 0.0f;
    int my_blink = 0;
    int blinker = 0;

    public Firefly(World w) {
        super(w);
        this.maxrenderdist = 256;
        this.height = 0.55f;
        this.width = 0.45f;
        this.uniquename = "OreSpawn:Firefly";
        this.setMaxHealth(2.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        if (w != null) {
            this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.05f;
        }
        this.takesFallDamage = false;
        this.setExperience(1);
        this.daytimespawn = false;
        this.nighttimespawn = true;
        this.daytimedespawn = true;
        this.nighttimedespawn = false;
        this.my_blink = 40 + DangerZone.rand.nextInt(40);
        this.canFly = true;
        this.setFlying(true);
    }

    public void doEntityAction(float deltaT) {
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 25;
            if (this.world.isDaytime() && this.world.rand.nextInt(100) == 1 && this.getCanDespawn()) {
                this.deadflag = true;
            }
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(40) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(8) - this.world.rand.nextInt(8)), this.posy + (double)(this.world.rand.nextInt(7) - 2), this.posz + (double)(this.world.rand.nextInt(8) - this.world.rand.nextInt(8)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    --keep_trying;
                    this.myspeed = 0.05f + this.world.rand.nextFloat() * 0.05f;
                }
            }
            if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        ++this.blinker;
        if (this.blinker > this.my_blink) {
            this.blinker = 0;
        }
        super.update(deltaT);
    }

    public String getDeathSound() {
        return "DangerZone:big_splat";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(20) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyfirefly.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)Items.deadbug.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)OreSpawnMain.extremetorch.blockID, (int)0, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Fireflytexture.png");
        }
        return this.texture;
    }

    public boolean getBlink() {
        return this.blinker < this.my_blink / 2;
    }
}

