/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnUtils;
import OreSpawn.entities.Bee;
import OreSpawn.entities.Brutalfly;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.Scorpion;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class EmperorScorpion
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public EmperorScorpion(World w) {
        super(w);
        this.maxrenderdist = 220;
        this.height = 2.95f;
        this.width = 5.25f;
        this.uniquename = "OreSpawn:EmperorScorpion";
        this.moveSpeed = 0.26f;
        this.setMaxHealth(600.0f);
        this.setHealth(600.0f);
        this.setDefense(5.0f);
        this.setAttackDamage(55.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 6.5f;
        this.movefrequency = 65;
        this.setExperience(699);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        super.doAttack(victim);
        victim.addKnockback((Entity)this, 1.75f + this.world.rand.nextFloat() * 3.5f, 0.5f + this.world.rand.nextFloat() * 0.75f);
        if (this.world.rand.nextBoolean()) {
            this.world.playSound("OreSpawn:scorpion_living", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        } else {
            this.world.playSound("OreSpawn:scorpion_attack", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
        }
        if (this.world.rand.nextBoolean()) {
            this.doDistanceAttack(victim);
        }
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.rand.nextInt(3) != 1) {
            return;
        }
        double px = (this.posx + victim.posx) / 2.0;
        double py = (this.posy + victim.posy) / 2.0;
        double pz = (this.posz + victim.posz) / 2.0;
        px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
        pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
        int i = -5;
        while (i <= 5) {
            Scorpion sc;
            int bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
            if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && (sc = (Scorpion)this.world.createEntityByName("OreSpawn:Scorpion", this.dimension, px, py + (double)i, pz)) != null) {
                sc.init();
                sc.hurtMe = victim;
                this.world.spawnEntityInWorld((Entity)sc);
            }
            ++i;
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    public void doDeathDrops() {
        int howmany = 20 + this.world.rand.nextInt(30);
        int i = 0;
        while (i < howmany) {
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggettitanium.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            } else {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggeturanium.itemID, (float)6.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpplatinum.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.blockplatinum.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumsword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.platinumhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyemperorscorpion.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emperorscorpionscale.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (OreSpawnUtils.isBat(e).booleanValue()) {
            return false;
        }
        if (e instanceof Scorpion) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Brutalfly && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Vortex && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/EmperorScorpiontexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Emperor Scorpion";
    }
}

