/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Drant;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.ThrownBlock;
import OreSpawn.entities.ThrownThunder;
import OreSpawn.entities.ThrownWind;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityBlock;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class ElementDragon
extends EntityLivingDragon {
    float myspeed = 0.0f;
    private int soundcount = 0;
    int backoffmode = 0;
    int backoffcounter = 0;
    Texture texture1 = null;
    Texture texture2 = null;
    Texture texture3 = null;
    Texture texture4 = null;
    Texture texture5 = null;
    Texture texture6 = null;

    public ElementDragon(World w) {
        super(w);
        this.maxrenderdist = 330;
        this.uniquename = "OreSpawn:Element Dragon";
        if (w != null) {
            this.myspeed = 1.25f + this.world.rand.nextFloat() * 0.3f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = true;
        this.setExperience(2000);
        this.height = 4.25f;
        this.width = 3.25f;
        this.setMaxHealth(800.0f);
        this.setHealth(800.0f);
        this.setDefense(3.5f);
        this.setAttackDamage(60.0f);
        this.searchDistance = 100.0f;
        this.attackRange = 7.0f;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        if (w != null) {
            this.backoffcounter = 50 + w.rand.nextInt(100);
        }
        if (w != null && w.isServer) {
            this.setIID(-1);
            this.setIID(DangerZone.rand.nextInt(6));
        }
        this.tower_defense_enable = true;
        this.setFlying(true);
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
        if (e instanceof ElementDragon) {
            this.hurtMe = null;
        }
        this.searchcounter = 10;
    }

    public void setGuardMode() {
        this.setVarInt(21, (int)this.posx);
        this.setVarInt(22, (int)this.posz);
        this.setVarInt(23, (int)this.posy + 10);
        this.setBID(1);
        this.setFlying(true);
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (!this.world.isServer) {
            super.doEntityAction(deltaT);
            return;
        }
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(1.0f);
        }
        if (this.getBID() == 0) {
            this.setGuardMode();
        }
        --this.backoffcounter;
        if (this.backoffcounter <= 0) {
            if (this.backoffmode == 0) {
                this.targetentity = null;
                this.target = null;
                this.setAttacking(false);
                this.backoffmode = 1;
                this.backoffcounter = 20 + this.world.rand.nextInt(100);
            } else {
                this.backoffmode = 0;
                this.backoffcounter = 50 + this.world.rand.nextInt(120);
            }
        }
        if (this.backoffmode == 0) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.hurtMe != null && this.hurtMe.posy > 300.0) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = this.targetentity.isFlying() ? new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz) : new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(8) == 1) {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        this.targetentity.doAttackFrom((Entity)this, 4, this.getAttackDamage());
                    } else {
                        this.do_a_distance_attack(this.targetentity);
                    }
                }
            }
        }
        ++this.soundcount;
        if (this.soundcount > 18) {
            this.soundcount = 0;
            int which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 1) {
                this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 2) {
                this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        double px = this.posx;
        double pz = this.posz;
        double py = this.posy;
        if (this.getBID() != 0) {
            px = this.getVarInt(21);
            pz = this.getVarInt(22);
            py = this.getVarInt(23);
        }
        if (this.world.rand.nextInt(200) == 0 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            int down = 0;
            int i = -5;
            while (i <= 5) {
                int j = -5;
                while (j <= 5) {
                    int k = -20;
                    while (k <= 20) {
                        int bid = this.world.getblock(this.dimension, (int)this.posx + j, (int)(this.posy + (double)k) - 15, (int)this.posz + i);
                        down = bid != 0 ? ++down : --down;
                        k += 2;
                    }
                    j += 5;
                }
                i += 5;
            }
            if (down > 15) {
                down = 15;
            }
            if (down < -15) {
                down = -15;
            }
            int xdir = 1;
            int zdir = 1;
            if (this.world.rand.nextBoolean()) {
                xdir = -1;
            }
            if (this.world.rand.nextBoolean()) {
                zdir = -1;
            }
            int newz = this.world.rand.nextInt(120);
            int newx = this.world.rand.nextInt(120);
            this.target.setTarget(px + (double)(newx *= xdir), py + (double)(this.world.rand.nextInt(7) - 3) + (double)(down / 2), pz + (double)(newz *= zdir));
            this.myspeed = 1.25f + this.world.rand.nextFloat() * 0.3f;
        }
        if (this.target.targety > 250.0) {
            this.target.targety = 200.0;
        }
        if (this.target.targety < 0.0) {
            this.target.targety = 50.0;
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 10.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        double cdir = Math.toRadians(this.rotation_yaw);
        double tdir = Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        double ddiff = tdir - cdir;
        while (ddiff > Math.PI) {
            ddiff -= Math.PI * 2;
        }
        while (ddiff < -Math.PI) {
            ddiff += Math.PI * 2;
        }
        this.rotation_yaw_motion = (float)(ddiff * 180.0 / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        Utils.SpawnDustAlongPath((EntityLiving)this);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        this.doLookAction();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof Drant) {
            return false;
        }
        if (e instanceof EntityBlock) {
            return false;
        }
        return this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int which = this.getIID();
        if (which == 2) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.firestaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.waterstaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 0) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.earthstaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.windstaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 4) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.lightningstaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 5) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.plantstaff.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyelementdragon.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        int howmany = 4 + this.world.rand.nextInt(6);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 4 + this.world.rand.nextInt(6);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 8 + this.world.rand.nextInt(8);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.feather.itemID, (float)6.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        int which = this.getIID();
        if (which == 0) {
            if (this.texture1 == null) {
                this.texture1 = TextureMapper.getTexture((String)"orespawnres/skins/EarthElementDragontexture.png");
            }
            return this.texture1;
        }
        if (which == 1) {
            if (this.texture2 == null) {
                this.texture2 = TextureMapper.getTexture((String)"orespawnres/skins/WindElementDragonTexture.png");
            }
            return this.texture2;
        }
        if (which == 2) {
            if (this.texture3 == null) {
                this.texture3 = TextureMapper.getTexture((String)"orespawnres/skins/FireElementDragontexture.png");
            }
            return this.texture3;
        }
        if (which == 3) {
            if (this.texture4 == null) {
                this.texture4 = TextureMapper.getTexture((String)"orespawnres/skins/WaterElementDragontexture.png");
            }
            return this.texture4;
        }
        if (which == 4) {
            if (this.texture5 == null) {
                this.texture5 = TextureMapper.getTexture((String)"orespawnres/skins/LightningElementDragontexture.png");
            }
            return this.texture5;
        }
        if (this.texture6 == null) {
            this.texture6 = TextureMapper.getTexture((String)"orespawnres/skins/PlantElementDragontexture.png");
        }
        return this.texture6;
    }

    public String getHurtSound() {
        return "OreSpawn:ElementDragon_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:ElementDragon_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        return "OreSpawn:ElementDragon_living";
    }

    private void do_a_distance_attack(Entity victim) {
        Object e;
        int i;
        int howmany;
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        double starty = this.posy + (double)(this.getHeight() * 3.0f / 4.0f);
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int which = this.getIID();
        if (which == 2) {
            howmany = 1 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(Items.fireball.itemID);
                    e.thrower = this;
                    e.explosive_power = 1.0f;
                    e.setAttackDamage(30.0f);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 7.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 3) {
            howmany = 1 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                e = (ThrownBlock)this.world.createEntityByName("OreSpawn:ThrownBlock", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(Blocks.water.blockID);
                    e.setIID(this.world.rand.nextInt(15) + 1);
                    e.thrower = this;
                    e.setAttackDamage(30.0f);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 7.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 0) {
            howmany = 1 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                e = (ThrownBlock)this.world.createEntityByName("OreSpawn:ThrownBlock", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(OreSpawnMain.toxicdirt.blockID);
                    e.setIID(0);
                    e.thrower = this;
                    e.setAttackDamage(30.0f);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 7.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 1) {
            howmany = 2 + this.world.rand.nextInt(5);
            i = 0;
            while (i < howmany) {
                e = (ThrownWind)this.world.createEntityByName("OreSpawn:ThrownWind", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    this.setAttackDamage(30.0f);
                    e.thrower = this;
                    e.thrower2 = null;
                    tdiry = (float)Math.atan2(starty - victim.posy, hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.1f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 4) {
            howmany = 1 + this.world.rand.nextInt(3);
            i = 0;
            while (i < howmany) {
                e = (ThrownThunder)this.world.createEntityByName("OreSpawn:ThrownThunder", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(0);
                    e.setIID(0);
                    e.thrower = this;
                    e.thrower2 = null;
                    e.setAttackDamage(10.0f);
                    tdiry = (float)Math.atan2(starty - victim.posy, hdist);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 8.5f, 0.1f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        if (which == 5) {
            howmany = 1 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                e = (ThrownBlock)this.world.createEntityByName("OreSpawn:ThrownBlock", this.dimension, startx, starty, startz);
                if (e != null) {
                    e.init();
                    e.setBID(OreSpawnMain.toxicleaves.blockID);
                    e.setIID(0);
                    e.thrower = this;
                    e.setAttackDamage(30.0f);
                    e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 7.5f, 0.2f);
                    this.world.spawnEntityInWorld((Entity)e);
                }
                ++i;
            }
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public boolean isBoss() {
        return true;
    }
}

