/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.BabySitter;
import OreSpawn.entities.ChaosDemon;
import OreSpawn.entities.DargonHead;
import OreSpawn.entities.EntityLivingDragon;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.PurpleFireball;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Block;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class Dargon
extends EntityLivingDragon {
    float myspeed = 0.0f;
    private int soundcount = 0;
    private int head3ext = 0;
    private int head3dir = 1;
    public DargonHead myhead = null;
    int backoffmode = 0;
    int backoffcounter = 0;
    private int fireballticker = 0;

    public Dargon(World w) {
        super(w);
        this.maxrenderdist = 380;
        this.uniquename = "OreSpawn:Dargon";
        if (w != null) {
            this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 85;
        this.canSwim = true;
        this.setExperience(20000);
        this.height = 20.75f;
        this.width = 22.75f;
        this.setMaxHealth(7000.0f);
        this.setHealth(7000.0f);
        this.setDefense(7.25f);
        this.setAttackDamage(250.0f);
        this.searchDistance = 120.0f;
        this.attackRange = 20.0f;
        this.isImmuneToFire = true;
        this.setCanDespawn(false);
        this.ignoreCollisions = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.canFly = true;
        if (w != null) {
            this.backoffcounter = 40 + w.rand.nextInt(80);
        }
        this.moveSpeed = 0.55f;
        this.sit_when_riding = false;
        this.maxdisttoowner = 34.0f;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.enable_droppedfood = true;
        this.always_draw = true;
        this.tower_defense_enable = true;
        this.setGroundFactor(1.55f);
        this.setAirFactor(2.75f);
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.moosemeat.itemID;
    }

    public float getRiderYoffset() {
        return 21.55f;
    }

    public float getRiderXZoffset() {
        return 10.75f;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        this.setFlying(true);
        this.setStaying(false);
        this.setSitting(false);
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        if (dt == 12) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
        if (this.hurtMe != null && this.hurtMe instanceof EntityLivingDragon) {
            this.hurtMe = null;
        }
        this.searchcounter = 10;
    }

    public void setGuardMode() {
        this.setVarInt(21, (int)this.posx);
        this.setVarInt(22, (int)this.posz);
        this.setBID(1);
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(6) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = this.targetentity.isFlying() ? new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz) : new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(6) == 1) {
            if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                float dmg = this.getAttackDamage();
                int dt = 4;
                this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            } else if (this.getRiderEntity() == null) {
                this.do_a_distance_attack(this.targetentity);
            }
        }
    }

    public void doSoloFlying(float deltaT) {
        int bid;
        int keep_trying = 35;
        double px = this.posx;
        double py = this.posy;
        double pz = this.posz;
        double dist = 0.0;
        int dxz = 45;
        float speedadjust = 1.0f;
        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
        if (e != null) {
            px = e.posx;
            py = e.posy + (double)(e.getHeight() / 2.0f);
            pz = e.posz;
            dxz = 32;
            dist = this.getDistanceFromEntity(e);
            if (dist > (double)this.maxdisttoowner) {
                speedadjust = 1.75f;
            }
            if (dist > (double)(this.maxdisttoowner * 1.5f)) {
                speedadjust = 2.75f;
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 2.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(px + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)), py + (double)(this.world.rand.nextInt(7) - 2), pz + (double)(this.world.rand.nextInt(dxz) - this.world.rand.nextInt(dxz)));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                --keep_trying;
            }
            this.myspeed = 0.85f + this.world.rand.nextFloat() * 0.85f;
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 8.0);
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
    }

    @Override
    public void doEntityAction(float deltaT) {
        if (this.getOwnerName() != null) {
            this.enable_taming = true;
            this.doEntityActionTame(deltaT);
        } else {
            this.doEntityActionWild(deltaT);
        }
    }

    public void doEntityActionTame(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(5.0f);
        }
        if (this.isFlying()) {
            this.ignoreCollisions = rider == null;
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
            }
        } else {
            this.ignoreCollisions = false;
        }
        if (rider == null) {
            if (!this.isFlying()) {
                if (!this.getStaying()) {
                    this.doNormalAttack();
                    if (this.getOwnerName() != null) {
                        double dist = 0.0;
                        Entity e = DangerZone.server.entityManager.findPlayerByName(this.getOwnerName());
                        if (e != null) {
                            dist = this.getDistanceFromEntity(e);
                        }
                        if (dist > (double)(this.maxdisttoowner + 8.0f)) {
                            this.setFlying(true);
                        }
                    }
                    if (this.world.rand.nextInt(750) == 1) {
                        this.setFlying(true);
                    }
                }
                super.doEntityAction(deltaT);
                return;
            }
            if (this.getStaying()) {
                this.setFlying(false);
            }
            this.doFlyingAttack();
            this.doSoloFlying(deltaT);
            this.doLookAction();
            if (this.world.rand.nextInt(250) == 1) {
                this.setFlying(false);
            }
            if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
                this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
            }
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.getOnGround()) {
            this.setFlying(false);
        } else {
            this.setFlying(true);
        }
        this.doFlyingAttack();
        ++this.fireballticker;
        if (this.fireballticker > 5) {
            this.fireballticker = 6;
        }
        if (rider.getLeft() && this.fireballticker > 2) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
        if (rider.getRight() && this.fireballticker > 2) {
            this.fireballticker = 0;
            this.doriderfireball();
        }
    }

    private void doriderfireball() {
        Entity rider = this.getRiderEntity();
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 5.0f / 3.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        double starty = this.posy + (double)(this.getHeight() * 0.9f);
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.getWidth() * 5.0f / 3.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        float tdirxz = (float)Math.toRadians(rider.rotation_yaw_head);
        float tdiry = (float)Math.toRadians(rider.rotation_pitch_head);
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            PurpleFireball e = (PurpleFireball)this.world.createEntityByName("OreSpawn:PurpleFireball", this.dimension, startx, starty, startz);
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(0);
                e.thrower = this;
                e.thrower2 = rider;
                e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 8.5f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()), 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            ++i;
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.6f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (this.getOwnerName() == null) {
                if (ic == null && this.getHealth() / this.getMaxHealth() < 0.25f) {
                    this.temperament = 3;
                    this.setOwnerName(p.myname);
                    this.Mount((Entity)p);
                    this.setSitting(false);
                    this.setStaying(false);
                    this.setBID(0);
                    this.setIID(0);
                    if (this.myhead != null) {
                        this.myhead.deadflag = true;
                        this.myhead = null;
                    }
                    this.searchDistance = 60.0f;
                    this.enable_taming = true;
                }
                return false;
            }
            this.enable_taming = true;
            if (ic == null && p.getPetName().equals(this.getOwnerName())) {
                if (this.isMountedBy((Entity)p)) {
                    this.unMount((Entity)p);
                } else {
                    this.Mount((Entity)p);
                    this.setSitting(false);
                    this.setStaying(false);
                }
                return false;
            }
        }
        return super.rightClickedByPlayer(p, ic);
    }

    public void doEntityActionWild(float deltaT) {
        Entity e;
        if (this.world.rand.nextInt(10) == 1) {
            this.heal(10.0f);
        }
        if (this.getBID() == 0) {
            this.setGuardMode();
        }
        boolean found = false;
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(50.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            e = null;
            Collections.sort(nearby_list, this.TargetSorter);
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!(e instanceof DargonHead)) continue;
                found = true;
                this.myhead = (DargonHead)e;
                break;
            }
        }
        if (!found && (e = this.world.createEntityByName("OreSpawn:DargonHead", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)), this.posy + 15.0, this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 3.0f / 2.0f)))) != null) {
            e.init();
            this.world.spawnEntityInWorld(e);
            this.myhead = (DargonHead)e;
        }
        --this.backoffcounter;
        if (this.backoffcounter <= 0) {
            if (this.backoffmode == 0) {
                this.targetentity = null;
                this.target = null;
                this.setAttacking(false);
                this.backoffmode = 1;
                this.backoffcounter = 40 + this.world.rand.nextInt(60);
                this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
            } else {
                this.backoffmode = 0;
                this.backoffcounter = 50 + this.world.rand.nextInt(100);
                this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
            }
        }
        if (this.backoffmode == 0) {
            ++this.searchcounter;
            if (this.searchcounter >= 10) {
                this.searchcounter = this.world.rand.nextInt(4);
                if (this.hurtMe != null && this.hurtMe.deadflag) {
                    this.hurtMe = null;
                }
                if (this.hurtMe != null && this.hurtMe.posy > 300.0) {
                    this.hurtMe = null;
                }
                if (this.world.rand.nextInt(20) == 1) {
                    this.hurtMe = null;
                }
                this.targetentity = this.hurtMe;
                if (this.targetentity == null) {
                    this.targetentity = this.findSomethingToAttack();
                }
                if (this.targetentity != null) {
                    this.target = this.targetentity.isFlying() ? new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy, this.targetentity.posz) : new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                    this.setAttacking(true);
                } else {
                    this.setAttacking(false);
                }
            }
            if (this.targetentity != null && this.world.rand.nextInt(5) == 1) {
                double cdir = Math.toRadians(this.rotation_yaw);
                double tdir = Math.atan2(this.targetentity.posx - this.posx, this.targetentity.posz - this.posz);
                double ddiff = tdir - cdir;
                while (ddiff > Math.PI) {
                    ddiff -= Math.PI * 2;
                }
                while (ddiff < -Math.PI) {
                    ddiff += Math.PI * 2;
                }
                if (Math.abs(ddiff) < 1.0471975511965976) {
                    if (this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
                        float dmg = this.getAttackDamage();
                        int dt = 4;
                        this.targetentity.doAttackFrom((Entity)this, dt, dmg);
                    } else {
                        this.do_a_distance_attack(this.targetentity);
                    }
                }
            }
        }
        ++this.soundcount;
        if (this.soundcount > 12) {
            this.soundcount = 0;
            int which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 1) {
                this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 2) {
                this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
        }
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy, this.posz);
        }
        double px = this.posx;
        double pz = this.posz;
        if (this.getBID() != 0) {
            px = this.getVarInt(21);
            pz = this.getVarInt(22);
        }
        if (this.world.rand.nextInt(300) == 0 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 8.0) {
            int down = 0;
            int i = -5;
            while (i <= 5) {
                int j = -5;
                while (j <= 5) {
                    int k = -20;
                    while (k <= 20) {
                        int bid = this.world.getblock(this.dimension, (int)this.posx + j, (int)(this.posy + (double)k) - 15, (int)this.posz + i);
                        down = bid != 0 ? ++down : --down;
                        k += 2;
                    }
                    j += 5;
                }
                i += 5;
            }
            if (down > 15) {
                down = 15;
            }
            if (down < -15) {
                down = -15;
            }
            int xdir = 1;
            int zdir = 1;
            if (this.world.rand.nextBoolean()) {
                xdir = -1;
            }
            if (this.world.rand.nextBoolean()) {
                zdir = -1;
            }
            int newz = this.world.rand.nextInt(160);
            int newx = this.world.rand.nextInt(160);
            this.target.setTarget(px + (double)(newx *= xdir), (double)((int)this.posy + this.world.rand.nextInt(7) - 3 + down / 2), pz + (double)(newz *= zdir));
            this.myspeed = 1.75f + this.world.rand.nextFloat() * 0.3f;
        }
        if (this.target.targety > 250.0) {
            this.target.targety = 200.0;
        }
        if (this.target.targety < 0.0) {
            this.target.targety = 50.0;
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 10.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        double cdir = Math.toRadians(this.rotation_yaw);
        double tdir = Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        double ddiff = tdir - cdir;
        while (ddiff > Math.PI) {
            ddiff -= Math.PI * 2;
        }
        while (ddiff < -Math.PI) {
            ddiff += Math.PI * 2;
        }
        this.rotation_yaw_motion = (float)(ddiff * 180.0 / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        float spd = (float)Math.sqrt(this.motionx * this.motionx + this.motionz * this.motionz);
        if (spd > this.myspeed) {
            this.motionx *= this.myspeed / spd;
            this.motionz *= this.myspeed / spd;
        }
        if (!(this.isHurt() || this.deadflag || this.getStaying() || this.world.rand.nextInt(100) != 1)) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof EntityLivingDragon) {
            return false;
        }
        if (e instanceof ChaosDemon) {
            return false;
        }
        if (e instanceof BabySitter) {
            return false;
        }
        if (this.getBID() != 0 && e.getHorizontalDistanceFromEntity((double)this.getVarInt(21), (double)this.getVarInt(22)) > 256.0) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Girlfriend && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        int howmany = 50;
        int i = 0;
        while (i < howmany) {
            int iid = this.world.rand.nextInt(2048);
            Item it = Items.getItem((int)iid);
            if (it == null || !it.showInInventory) continue;
            iid = it.itemID;
            ++i;
            Utils.doDropRand((World)this.world, (int)0, (int)iid, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        i = 0;
        while (i < howmany) {
            int bid = this.world.rand.nextInt(2048);
            Block bl = Blocks.getBlock((int)bid);
            if (bl == null || !bl.showInInventory) continue;
            bid = bl.blockID;
            ++i;
            Utils.doDropRand((World)this.world, (int)bid, (int)0, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        i = 0;
        while (i < 55) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.queenscale.itemID, (float)20.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophydargon.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Dargontexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:king_hit";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:large_explosion1";
        }
        if (which == 1) {
            return "DangerZone:large_explosion2";
        }
        return "DangerZone:large_explosion3";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 1) {
            return null;
        }
        return "OreSpawn:king_living";
    }

    public int getHead3Ext() {
        return this.head3ext;
    }

    @Override
    public void update(float deltaT) {
        if (!this.world.isServer) {
            int howoften = 10;
            int howfar = 2;
            if (this.getAttacking()) {
                howoften = 5;
                howfar = 3;
            }
            if (this.world.rand.nextInt(howoften) == 1) {
                int i = this.world.rand.nextInt(3);
                if (i == 0) {
                    this.head3dir = howfar;
                }
                if (i == 1) {
                    this.head3dir = -howfar;
                }
                if (i == 2) {
                    this.head3dir = 0;
                }
            }
            this.head3ext += this.head3dir;
            if (this.head3ext < 0) {
                this.head3ext = 0;
            }
            if (this.head3ext > 60) {
                this.head3ext = 60;
            }
        }
        super.update(deltaT);
    }

    private void do_a_distance_attack(Entity victim) {
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 5.0f / 3.0f));
        double starty = this.posy + (double)(this.getHeight() * 0.9f);
        double startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw)) * (this.getWidth() * 5.0f / 3.0f));
        float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
        float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
        float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
        int howmany = 6 + this.world.rand.nextInt(10);
        int i = 0;
        while (i < howmany) {
            PurpleFireball e = (PurpleFireball)this.world.createEntityByName("OreSpawn:PurpleFireball", this.dimension, startx, starty, startz);
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(0);
                e.thrower = this;
                e.thrower2 = this.myhead;
                e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 8.5f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()), 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            ++i;
        }
        this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
    }

    public void setBaby(boolean tf) {
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Dargon!";
    }
}

