/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Utils;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Coin
extends EntityLiving {
    public Coin(World w) {
        super(w);
        this.maxrenderdist = 100;
        this.height = 2.0f;
        this.width = 2.0f;
        this.uniquename = "OreSpawn:Coin";
        this.moveSpeed = 0.0f;
        this.setMaxHealth(1.0f);
        this.setHealth(1.0f);
        this.setDefense(0.5f);
        this.setAttackDamage(0.0f);
        this.movefrequency = 4000;
        this.setExperience(1);
        this.canSwim = true;
        this.daytimespawn = true;
        this.nighttimespawn = false;
        this.daytimedespawn = true;
        this.nighttimedespawn = true;
    }

    public void init() {
        super.init();
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            this.rotation_yaw_motion = 1.0f;
        }
        super.update(deltaT);
    }

    public void doEntityAction(float deltaT) {
        if (this.world.rand.nextInt(1200) == 1) {
            this.doDropEggs();
        }
        super.doEntityAction(deltaT);
    }

    private void doDropEggs() {
        int howmany = 1 + this.world.rand.nextInt(5);
        int which = this.world.rand.nextInt(3);
        int iid = Items.coinsilver.itemID;
        if (which == 0) {
            iid = Items.coinsilver.itemID;
        } else if (which == 1) {
            iid = Items.coingold.itemID;
        } else if (which == 2) {
            iid = Items.coinplatinum.itemID;
        }
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)iid, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        DangerZone.world.playSound("DangerZone:pop", this.dimension, this.posx, this.posy, this.posz, 0.15f, 1.0f);
    }

    public String getDeathSound() {
        return "DangerZone:little_splat";
    }

    public void doDeathDrops() {
        int which = this.world.rand.nextInt(10);
        if (which == 0) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggcoin.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.ruby.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 2) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.amethyst.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 3) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.emerald.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 4) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggeturanium.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 5) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nuggettitanium.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 6) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coingold.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 7) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coinsilver.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 8) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coinplatinum.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (which == 9) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophycoin.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Cointexture.png");
        }
        return this.texture;
    }
}

