/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Kraken;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Cephadrome
extends EntityLiving {
    private int soundcount = 0;
    Entity targetentity = null;
    Entity hurtMe = null;
    float attackRange = 5.5f;

    public Cephadrome(World w) {
        super(w);
        this.maxrenderdist = 220;
        this.height = 4.25f;
        this.width = 4.75f;
        this.uniquename = "OreSpawn:Cephadrome";
        this.moveSpeed = 0.25f;
        this.setMaxHealth(800.0f);
        this.setHealth(800.0f);
        this.setDefense(4.0f);
        this.setAttackDamage(70.0f);
        this.movefrequency = 55;
        this.setExperience(799);
        this.canSwim = true;
        this.sit_when_riding = true;
        this.takesFallDamage = false;
        this.canFly = true;
        this.setGroundFactor(1.25f);
        this.setAirFactor(2.5f);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Cephadrometexture.png");
        }
        return this.texture;
    }

    public boolean rightClickedByPlayer(Player p, InventoryContainer ic) {
        if (this.world.isServer) {
            if (ic == null) {
                if (this.isMountedBy((Entity)p)) {
                    this.unMount((Entity)p);
                } else if (this.getBID() == 0) {
                    this.hurtMe = p;
                } else {
                    this.Mount((Entity)p);
                    this.setBID(0);
                }
                return false;
            }
            if (ic != null && this.isFoodForMe(ic.bid, ic.iid)) {
                Utils.spawnParticlesFromServer((World)this.world, (String)"DangerZone:ParticleHappy", (int)10, (int)this.dimension, (double)this.posx, (double)(this.posy + (double)this.getHeight()), (double)this.posz);
                this.playburp();
                this.heal(20.0f);
                this.setBID(1);
                this.hurtMe = null;
                return true;
            }
        }
        return false;
    }

    public boolean isFoodItem(int iid) {
        if (iid == Items.moosemeat.itemID) {
            return true;
        }
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        if (iid == Items.goosemeat.itemID) {
            return true;
        }
        return iid == Items.ostrichmeat.itemID;
    }

    public float getRiderYoffset() {
        if (this.isBaby()) {
            return 0.6375f;
        }
        return 2.55f;
    }

    public float getRiderXZoffset() {
        if (this.isBaby()) {
            return 0.1625f;
        }
        return 0.65f;
    }

    private void doFlyingAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 6) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(4) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange * 2.0f + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            if (this.targetentity instanceof Kraken) {
                dmg *= 3.0f;
            }
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
            if (this.targetentity instanceof Kraken && this.targetentity.motiony > 0.1f) {
                this.targetentity.motiony = 0.1f;
            }
        }
    }

    private void doNormalAttack() {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(10) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() * 3.0f / 4.0f), this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(8) == 1 && this.getDistanceFromEntity(this.targetentity) < (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            float dmg = this.getAttackDamage();
            int dt = 4;
            this.targetentity.doAttackFrom((Entity)this, dt, dmg);
        }
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e.getOwnerName() != null) {
            return false;
        }
        if (e instanceof Cephadrome) {
            return false;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(5) != 1) {
            return null;
        }
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:MothraWings1";
        }
        if (which == 1) {
            return "OreSpawn:MothraWings2";
        }
        return "OreSpawn:MothraWings3";
    }

    public void doEntityAction(float deltaT) {
        Entity rider = this.getRiderEntity();
        if (this.isFlying()) {
            ++this.soundcount;
            if (this.soundcount > 12) {
                this.soundcount = 0;
                int which = this.world.rand.nextInt(3);
                if (which == 0) {
                    this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 1) {
                    this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
                if (which == 2) {
                    this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
            }
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        if (rider == null) {
            this.doNormalAttack();
            super.doEntityAction(deltaT);
            return;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.toRadians(rider.rotation_yaw);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        if (ddiff > 0.2f) {
            ddiff = 0.2f;
        }
        if (ddiff < -0.2f) {
            ddiff = -0.2f;
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 6.0);
        cdir = (float)Math.toRadians(this.rotation_yaw_head);
        tdir = (float)Math.toRadians(rider.rotation_yaw_head);
        ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_head = (float)((double)this.rotation_yaw_head + (double)(ddiff * 180.0f) / Math.PI / 5.0);
        if (this.isFlying()) {
            this.doFlyingAttack();
        }
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)5.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.ruby.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)OreSpawnMain.blockruby.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubychestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubypickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubysword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.rubyhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(3) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophycephadrome.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isBoss() {
        return true;
    }
}

