/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Bee;
import OreSpawn.entities.CloudShark;
import OreSpawn.entities.EmperorScorpion;
import OreSpawn.entities.LurkingTerror;
import OreSpawn.entities.Mantis;
import OreSpawn.entities.Mothra;
import OreSpawn.entities.Rotator;
import OreSpawn.entities.TerribleTerror;
import OreSpawn.entities.Vortex;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Butterfly;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.entities.ThrownFireball;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Brutalfly
extends EntityLiving {
    float myspeed = 0.0f;
    private int soundcount = 0;
    private int stuck_count = 0;
    int lx;
    int ly;
    int lz;

    public Brutalfly(World w) {
        super(w);
        this.maxrenderdist = 200;
        this.uniquename = "OreSpawn:Brutalfly";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 2.75f;
        this.width = 3.75f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(2.0f);
        this.setAttackDamage(30.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 5.0f;
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = true;
    }

    public void doAttackFrom(Entity e, int dt, float pain) {
        if (dt == 9) {
            return;
        }
        if (dt == 10) {
            return;
        }
        super.doAttackFrom(e, dt, pain);
    }

    public void doEntityAction(float deltaT) {
        ++this.searchcounter;
        if (this.searchcounter >= 10) {
            this.searchcounter = this.world.rand.nextInt(4);
            if (this.hurtMe != null && this.hurtMe.deadflag) {
                this.hurtMe = null;
            }
            if (this.world.rand.nextInt(20) == 1) {
                this.hurtMe = null;
            }
            this.targetentity = this.hurtMe;
            if (this.targetentity == null) {
                this.targetentity = this.findSomethingToAttack();
            }
            if (this.targetentity != null) {
                this.target = new TargetHelper(this.targetentity, this.targetentity.posx, this.targetentity.posy + (double)(this.targetentity.getHeight() / 2.0f) + 8.0, this.targetentity.posz);
                this.setAttacking(true);
            } else {
                this.setAttacking(false);
            }
        }
        if (this.targetentity != null && this.world.rand.nextInt(12) == 1 && this.getDistanceFromEntity(this.targetentity) > (double)(this.attackRange + this.targetentity.getWidth() / 2.0f + this.getWidth() / 2.0f)) {
            double startz;
            double starty;
            double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
            ThrownFireball e = (ThrownFireball)this.world.createEntityByName("DangerZone:ThrownFireball", this.dimension, startx, starty = this.posy - 0.5, startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(Items.fireball.itemID);
                e.thrower = this;
                e.explosive_power = 2 + this.world.rand.nextInt(5);
                float hdist = (float)Math.sqrt((this.targetentity.posx - startx) * (this.targetentity.posx - startx) + (this.targetentity.posz - startz) * (this.targetentity.posz - startz));
                float tdirxz = (float)Math.atan2(this.targetentity.posx - startx, this.targetentity.posz - startz);
                float tdiry = (float)Math.atan2(starty - (this.targetentity.posy + (double)(this.targetentity.getHeight() / 2.0f)), hdist);
                e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 6.5f, 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
        ++this.soundcount;
        if (this.soundcount > 18) {
            this.soundcount = 0;
            int which = this.world.rand.nextInt(3);
            if (which == 0) {
                this.world.playSound("OreSpawn:MothraWings1", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 1) {
                this.world.playSound("OreSpawn:MothraWings2", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
            if (which == 2) {
                this.world.playSound("OreSpawn:MothraWings3", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
            }
        }
    }

    private boolean canSeeTarget(double px, double py, double pz) {
        return this.CanProbablySee(this.dimension, px, py, pz, (int)Math.sqrt((this.posx - px) * (this.posx - px) + (this.posy - py) * (this.posy - py) + (this.posz - pz) * (this.posz - pz)));
    }

    public void update(float deltaT) {
        if (this.world.isServer) {
            int bid;
            int keep_trying = 35;
            if (this.target == null) {
                this.target = new TargetHelper(this.posx, this.posy, this.posz);
            }
            ++this.stuck_count;
            if (this.lx != (int)this.posx || this.ly != (int)this.posy || this.lz != (int)this.posz) {
                this.stuck_count = 0;
                this.lx = (int)this.posx;
                this.ly = (int)this.posy;
                this.lz = (int)this.posz;
            }
            if (this.stuck_count > 30 || this.world.rand.nextInt(200) == 0 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 5.0) {
                int down = 0;
                int dist = 20;
                int i = -5;
                while (i <= 5) {
                    int j = -5;
                    while (j <= 5) {
                        int k = 1;
                        while (k < 20) {
                            bid = this.world.getblock(this.dimension, (int)this.posx + j, (int)this.posy - k, (int)this.posz + i);
                            if (bid != 0) {
                                if (k >= dist) break;
                                dist = k;
                                break;
                            }
                            ++k;
                        }
                        j += 5;
                    }
                    i += 5;
                }
                if (dist > 10) {
                    down = dist - 10 + 1;
                }
                bid = 1;
                while (bid != 0 && keep_trying != 0) {
                    int xdir = 1;
                    int zdir = 1;
                    if (this.world.rand.nextBoolean()) {
                        xdir = -1;
                    }
                    if (this.world.rand.nextBoolean()) {
                        zdir = -1;
                    }
                    int newz = this.world.rand.nextInt(20) + 8;
                    int newx = this.world.rand.nextInt(20) + 8;
                    this.target.setTarget((double)((int)this.posx + (newx *= xdir)), (double)((int)this.posy + this.world.rand.nextInt(7) - 1 - down), (double)((int)this.posz + (newz *= zdir)));
                    bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                    if (bid == 0 && !this.canSeeTarget((int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) {
                        bid = 1;
                    }
                    --keep_trying;
                }
                this.stuck_count = 0;
            }
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
            if (bid != 0) {
                this.target.setTarget(this.posx + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)), this.posy + (double)(this.world.rand.nextInt(5) + 3), this.posz + (double)(this.world.rand.nextInt(5) - this.world.rand.nextInt(5)));
            }
            double dy = this.target.targety - this.posy;
            this.motiony += 0.12f * deltaT;
            if ((dy /= 20.0) > (double)0.2f) {
                dy = 0.2f;
            }
            if (dy < (double)-0.2f) {
                dy = -0.2f;
            }
            this.motiony = (float)((double)this.motiony + dy);
            if (this.motiony > 1.0f) {
                this.motiony = 1.0f;
            }
            if (this.motiony < -1.0f) {
                this.motiony = -1.0f;
            }
            float cdir = (float)Math.toRadians(this.rotation_yaw);
            float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
            float ddiff = tdir - cdir;
            while ((double)ddiff > Math.PI) {
                ddiff = (float)((double)ddiff - Math.PI * 2);
            }
            while ((double)ddiff < -Math.PI) {
                ddiff = (float)((double)ddiff + Math.PI * 2);
            }
            this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
            float speedadjust = 1.0f;
            float effectspeed = this.getTotalEffect(1);
            if (effectspeed > 1.0f) {
                speedadjust *= effectspeed;
            }
            if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
                speedadjust /= effectspeed;
            }
            this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
            this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
            Utils.SpawnDustAlongPath((EntityLiving)this);
        }
        super.update(deltaT);
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof TerribleTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof EmperorScorpion && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof CloudShark && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof LurkingTerror && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Rotator && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Bee && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mantis && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e instanceof Mothra) {
            return false;
        }
        if (e instanceof Brutalfly) {
            return false;
        }
        if (e instanceof Vortex && this.dimension == OreSpawnMain.dangerdimension.dimensionID) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public void doDeathDrops() {
        Entity e;
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.goosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.feather.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 35;
        i = 0;
        while (i < howmany) {
            e = this.world.createEntityByName("DangerZone:Butterfly", this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 8.0f), this.posy + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 3.0f), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 8.0f));
            if (e != null) {
                e.init();
                Butterfly b = (Butterfly)e;
                b.despawn_fast = true;
                this.world.spawnEntityInWorld(e);
            }
            ++i;
        }
        howmany = 10;
        i = 0;
        while (i < howmany) {
            e = this.world.createEntityByName("OreSpawn:VampireButterfly", this.dimension, this.posx + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f), this.posy + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 2.0f), this.posz + (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f));
            if (e != null) {
                e.init();
                this.world.spawnEntityInWorld(e);
            }
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybrutalfly.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Brutalflytexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return null;
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "DangerZone:small_explosion1";
        }
        if (which == 1) {
            return "DangerZone:small_explosion2";
        }
        if (which == 2) {
            return "DangerZone:small_explosion3";
        }
        return "DangerZone:small_explosion4";
    }

    public String getLivingSound() {
        return null;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Brutalfly!";
    }
}

