/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Effects;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Basilisk
extends EntityLiving {
    public Basilisk(World w) {
        super(w);
        this.maxrenderdist = 190;
        this.height = 3.5f;
        this.width = 1.5f;
        this.uniquename = "OreSpawn:Basilisk";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(150.0f);
        this.setHealth(150.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 5.5f;
        this.movefrequency = 65;
        this.setExperience(169);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        Effects ef = new Effects(2, 2.0f, 100);
        victim.addEffectFromServer(ef);
        super.doAttack(victim);
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "OreSpawn:basilisk_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alo_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    public void doEntityAction(float deltaT) {
        if (this.world.isServer && this.world.rand.nextInt(200) == 0) {
            this.heal(1.0f);
        }
        super.doEntityAction(deltaT);
    }

    public void doDeathDrops() {
        int howmany = 8 + this.world.rand.nextInt(8);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.goosemeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            Utils.doDropRand((World)this.world, (int)0, (int)Items.emerald.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        howmany = 1 + this.world.rand.nextInt(3);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)Blocks.blockemerald.blockID, (int)0, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldboots.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldleggings.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldchestplate.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldhelmet.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldpickaxe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldshovel.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldsword.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.emeraldhoe.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophybasilisk.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.basiliskscale.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Basilisk) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Basilisktexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }
}

