/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Ant;
import OreSpawn.entities.AntRobot;
import OreSpawn.entities.BloodlustAnt;
import OreSpawn.entities.DoomAnt;
import OreSpawn.entities.Drant;
import OreSpawn.entities.MisfitAnt;
import OreSpawn.entities.RainbowAnt;
import OreSpawn.entities.RedAnt;
import OreSpawn.entities.Termite;
import OreSpawn.entities.UnstableAnt;
import OreSpawn.entities.ZooAnt;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Item;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class AntQueen
extends EntityLiving {
    public AntQueen(World w) {
        super(w);
        this.maxrenderdist = 270;
        this.height = 8.0f;
        this.width = 8.75f;
        this.uniquename = "OreSpawn:Ant Queen";
        this.moveSpeed = 0.44f;
        this.setMaxHealth(2200.0f);
        this.setHealth(2200.0f);
        this.setDefense(5.7f);
        this.setAttackDamage(65.0f);
        this.searchDistance = 64.0f;
        this.attackRange = 8.0f;
        this.movefrequency = 50;
        this.setExperience(3200);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doAttack(Entity victim) {
        float dmg = this.getAttackDamage();
        int dt = 4;
        if (victim != null) {
            this.doDistanceAttack(victim);
        }
        if (this.getAttackSound() != null) {
            this.world.playSound(this.getAttackSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        victim.doAttackFrom((Entity)this, dt, dmg);
    }

    public void doDistanceAttack(Entity victim) {
        int bid;
        int i;
        double px = (this.posx + victim.posx) / 2.0;
        double py = (this.posy + victim.posy) / 2.0;
        double pz = (this.posz + victim.posz) / 2.0;
        if (this.world.rand.nextInt(3) == 1) {
            px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
            pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 5.0f);
            i = -5;
            while (i <= 5) {
                BloodlustAnt sc;
                bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
                if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && Blocks.isSolid((int)bid) && (sc = (BloodlustAnt)this.world.createEntityByName("OreSpawn:Bloodlust Ant", this.dimension, px, py + (double)i, pz)) != null) {
                    sc.init();
                    sc.hurtMe = victim;
                    this.world.spawnEntityInWorld((Entity)sc);
                    break;
                }
                ++i;
            }
        }
        px = this.posx;
        py = this.posy;
        pz = this.posz;
        px += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 3.0f);
        pz += (double)((this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 3.0f);
        i = -3;
        while (i <= 3) {
            bid = this.world.getblock(this.dimension, (int)px, (int)py + i, (int)pz);
            if (bid == 0 && (bid = this.world.getblock(this.dimension, (int)px, (int)py + i - 1, (int)pz)) != 0 && Blocks.isSolid((int)bid)) {
                int which = this.world.rand.nextInt(9);
                switch (which) {
                    case 0: {
                        EntityLiving sc = (Ant)this.world.createEntityByName("OreSpawn:Ant", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 1: {
                        EntityLiving sc = (Drant)this.world.createEntityByName("OreSpawn:Drant", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 2: {
                        EntityLiving sc = (RedAnt)this.world.createEntityByName("OreSpawn:RedAnt", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 3: {
                        EntityLiving sc = (RainbowAnt)this.world.createEntityByName("OreSpawn:RainbowAnt", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 4: {
                        EntityLiving sc = (UnstableAnt)this.world.createEntityByName("OreSpawn:UnstableAnt", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 5: {
                        EntityLiving sc = (Termite)this.world.createEntityByName("OreSpawn:Termite", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 6: {
                        EntityLiving sc = (ZooAnt)this.world.createEntityByName("OreSpawn:ZooAnt", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 7: {
                        EntityLiving sc = (MisfitAnt)this.world.createEntityByName("OreSpawn:MisfitAnt", this.dimension, px, py + (double)i, pz);
                        if (sc != null) {
                            sc.init();
                            this.world.spawnEntityInWorld((Entity)sc);
                            break;
                        }
                    }
                    case 8: {
                        EntityLiving sc = (DoomAnt)this.world.createEntityByName("OreSpawn:DoomAnt", this.dimension, px, py + (double)i, pz);
                        if (sc == null) break;
                        sc.init();
                        sc.hurtMe = victim;
                        this.world.spawnEntityInWorld((Entity)sc);
                        break;
                    }
                }
                if (this.world.rand.nextInt(10) != 1) break;
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggredant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggrainbowant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggunstableant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggrobotant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggtermite.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggzooant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggmisfitant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdoomant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextBoolean()) {
                    Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdrant.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                }
                if (this.world.rand.nextInt(10) != 1) break;
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggantqueen.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                break;
            }
            ++i;
        }
    }

    public String getAttackSound() {
        return "OreSpawn:scorpion_attack";
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "OreSpawn:nope_hit";
    }

    public String getDeathSound() {
        return "OreSpawn:nope_death";
    }

    public void doDeathDrops() {
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyantqueen.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.antqueenscent.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.antqueenscent.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.antqueenscent.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        int howmany = 50 + this.world.rand.nextInt(50);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.crabmeat.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 25 + this.world.rand.nextInt(50);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 15 + this.world.rand.nextInt(25);
        i = 0;
        while (i < howmany) {
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggbloodlustant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggredant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggrainbowant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggunstableant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggrobotant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggtermite.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggzooant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggmisfitant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdoomant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextBoolean()) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.eggdrant.itemID, (float)this.getWidth(), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.wormtooth.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.krakentooth.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.vortexeye.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.ultimatesword.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trextooth.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.caterkillerjaw.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.seavipertongue.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.seamonsterscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.nightmarescale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.jumpybugscale.itemID, (float)(this.getWidth() * 2.0f), (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof AntQueen) {
            return false;
        }
        if (e instanceof BloodlustAnt) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof RedAnt) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            Player p = (Player)e;
            InventoryContainer ic = p.getHotbar(p.gethotbarindex());
            if (ic != null) {
                Item it = ic.getItem();
                if (it.itemID == OreSpawnMain.antqueenscent.itemID) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/AntQueentexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Ant Queen!";
    }
}

