/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.RenderInfo;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Alien
extends EntityLiving {
    public RenderInfo renderdata = new RenderInfo();

    public Alien(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 2.33f;
        this.width = 1.35f;
        this.uniquename = "OreSpawn:Alien";
        this.moveSpeed = 0.96f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(20.0f);
        this.searchDistance = 22.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 35;
        this.setExperience(199);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 5;
        this.foodblockdistxz = 11;
        this.foodblockdisty = 4;
        this.foodblockdisteat = 27;
        this.foodblockheal = 2;
        this.fooddaytimeonly = false;
        this.tower_defense_enable = true;
    }

    public void update(float deltaT) {
        super.update(deltaT);
        if (!this.world.isServer && this.world.rand.nextInt(3) == 1) {
            float f = 0.75f + Math.abs(this.world.rand.nextFloat() * 1.15f);
            Utils.spawnParticles((World)this.world, (String)"DangerZone:ParticleRain", (int)1, (int)this.dimension, (double)(this.posx + (double)(f * (float)Math.sin(Math.toRadians(this.rotation_yaw)))), (double)(this.posy + 1.5), (double)(this.posz + (double)(f * (float)Math.cos(Math.toRadians(this.rotation_yaw)))), (boolean)false);
        }
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
        this.world.setblockandmetaWithPerm((Entity)this, d, x, y, z, 0, 0);
    }

    public boolean isFoodBlock(int bid) {
        if (bid == Blocks.lightstick.blockID) {
            return true;
        }
        return bid == OreSpawnMain.extremetorch.blockID;
    }

    public String getLivingSound() {
        if (this.world.rand.nextInt(3) != 1) {
            return null;
        }
        return "OreSpawn:alien_living";
    }

    public String getHurtSound() {
        return "OreSpawn:alien_hurt";
    }

    public String getDeathSound() {
        return "OreSpawn:alien_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.sunstone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            Utils.doDropRand((World)this.world, (int)0, (int)Items.bloodstone.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyalien.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Alien) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Alientexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Alien!";
    }
}

