/*
 * Decompiled with CFR 0.152.
 */
package slick;

import dangerzone.rendering.MatrixStack;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import slick.BufferedImageUtil;
import slick.ColorSlick;
import slick.Font;
import slick.Renderer;
import slick.SGL;
import slick.Texture;

public class TrueTypeFont
implements Font {
    private static final SGL GL = Renderer.get();
    private IntObject[] charArray = new IntObject[256];
    private Map customChars = new HashMap();
    private boolean antiAlias;
    private int fontSize = 0;
    private int fontHeight = 0;
    private Texture fontTexture;
    private int textureWidth = 512;
    private int textureHeight = 512;
    private java.awt.Font font;
    private FontMetrics fontMetrics;
    private ByteBuffer vbodata = null;
    private int vcount = 0;
    private int vmax = 0;
    private int stride = 0;
    private int textureoff = 0;
    private int coloroff = 0;
    private volatile int glvboID = 0;
    private volatile int glvaoID = 0;

    public TrueTypeFont(java.awt.Font font, boolean antiAlias, char[] additionalChars) {
        this.font = font;
        this.fontSize = font.getSize();
        this.antiAlias = antiAlias;
        this.createSet(additionalChars);
        this.textureoff = this.stride = 12;
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.vmax = 128;
        this.vcount = 0;
        this.glvboID = 0;
        this.glvaoID = 0;
        this.vbodata = BufferUtils.createByteBuffer(this.vmax * this.stride);
        this.vbodata.position(0);
        this.vbodata.limit(this.vbodata.capacity());
    }

    public TrueTypeFont(java.awt.Font font, boolean antiAlias) {
        this(font, antiAlias, null);
    }

    private BufferedImage getFontImage(char ch) {
        int charheight;
        BufferedImage tempfontImage = new BufferedImage(1, 1, 2);
        Graphics2D g = (Graphics2D)tempfontImage.getGraphics();
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setFont(this.font);
        this.fontMetrics = g.getFontMetrics();
        int charwidth = this.fontMetrics.charWidth(ch);
        if (charwidth <= 0) {
            charwidth = 1;
        }
        if ((charheight = this.fontMetrics.getHeight()) <= 0) {
            charheight = this.fontSize;
        }
        BufferedImage fontImage = new BufferedImage(charwidth, charheight, 2);
        Graphics2D gt = (Graphics2D)fontImage.getGraphics();
        if (this.antiAlias) {
            gt.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        gt.setFont(this.font);
        gt.setColor(Color.WHITE);
        int charx = 0;
        int chary = 0;
        gt.drawString(String.valueOf(ch), charx, chary + this.fontMetrics.getAscent());
        return fontImage;
    }

    private void createSet(char[] customCharsArray) {
        if (customCharsArray != null && customCharsArray.length > 0) {
            this.textureWidth *= 2;
        }
        try {
            BufferedImage imgTemp = new BufferedImage(this.textureWidth, this.textureHeight, 2);
            Graphics2D g = (Graphics2D)imgTemp.getGraphics();
            g.setColor(new Color(255, 255, 255, 1));
            g.fillRect(0, 0, this.textureWidth, this.textureHeight);
            int rowHeight = 0;
            int positionX = 0;
            int positionY = 0;
            int customCharsLength = customCharsArray != null ? customCharsArray.length : 0;
            int i = 0;
            while (i < 256 + customCharsLength) {
                char ch = i < 256 ? (char)i : customCharsArray[i - 256];
                BufferedImage fontImage = this.getFontImage(ch);
                IntObject newIntObject = new IntObject();
                newIntObject.width = fontImage.getWidth();
                newIntObject.height = fontImage.getHeight();
                if (positionX + newIntObject.width >= this.textureWidth) {
                    positionX = 0;
                    positionY += rowHeight;
                    rowHeight = 0;
                }
                newIntObject.storedX = positionX;
                newIntObject.storedY = positionY;
                if (newIntObject.height > this.fontHeight) {
                    this.fontHeight = newIntObject.height;
                }
                if (newIntObject.height > rowHeight) {
                    rowHeight = newIntObject.height;
                }
                g.drawImage((Image)fontImage, positionX, positionY, null);
                positionX += newIntObject.width;
                if (i < 256) {
                    this.charArray[i] = newIntObject;
                } else {
                    this.customChars.put(new Character(ch), newIntObject);
                }
                fontImage = null;
                ++i;
            }
            this.fontTexture = BufferedImageUtil.getTexture(this.font.toString(), imgTemp);
        }
        catch (IOException e) {
            System.err.println("Failed to create font.");
            e.printStackTrace();
        }
    }

    private void drawQuad(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2) {
        float DrawWidth = drawX2 - drawX;
        float DrawHeight = drawY2 - drawY;
        float TextureSrcX = srcX / (float)this.textureWidth;
        float TextureSrcY = srcY / (float)this.textureHeight;
        float SrcWidth = srcX2 - srcX;
        float SrcHeight = srcY2 - srcY;
        float RenderWidth = SrcWidth / (float)this.textureWidth;
        float RenderHeight = SrcHeight / (float)this.textureHeight;
        GL11.glTexCoord2f((float)TextureSrcX, (float)TextureSrcY);
        GL11.glVertex2f((float)drawX, (float)drawY);
        GL11.glTexCoord2f((float)TextureSrcX, (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)drawX, (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)(TextureSrcY + RenderHeight));
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)(drawY + DrawHeight));
        GL11.glTexCoord2f((float)(TextureSrcX + RenderWidth), (float)TextureSrcY);
        GL11.glVertex2f((float)(drawX + DrawWidth), (float)drawY);
    }

    @Override
    public int getWidth(String whatchars) {
        int totalwidth = 0;
        IntObject intObject = null;
        char currentChar = '\u0000';
        int i = 0;
        while (i < whatchars.length()) {
            currentChar = whatchars.charAt(i);
            intObject = currentChar < '\u0100' ? this.charArray[currentChar] : (IntObject)this.customChars.get(new Character(currentChar));
            if (intObject != null) {
                totalwidth += intObject.width;
            }
            ++i;
        }
        return totalwidth;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    @Override
    public int getHeight(String HeightString) {
        return this.fontHeight;
    }

    @Override
    public int getLineHeight() {
        return this.fontHeight;
    }

    @Override
    public void drawString(float x, float y, String whatchars, ColorSlick color) {
        this.drawString(x, y, whatchars, color, 0, whatchars.length() - 1);
    }

    public void drawString3D(float x, float y, String whatchars, ColorSlick color) {
        this.drawString3D(x, y, whatchars, color, 0, whatchars.length() - 1);
    }

    @Override
    public void drawString(float x, float y, String whatchars, ColorSlick color, int startIndex, int endIndex) {
        color.bind();
        this.fontTexture.bind();
        IntObject intObject = null;
        GL11.glBegin((int)7);
        int totalwidth = 0;
        int i = 0;
        while (i < whatchars.length()) {
            char charCurrent = whatchars.charAt(i);
            intObject = charCurrent < '\u0100' ? this.charArray[charCurrent] : (IntObject)this.customChars.get(new Character(charCurrent));
            if (intObject != null) {
                if (i >= startIndex || i <= endIndex) {
                    this.drawQuad(x + (float)totalwidth, y, x + (float)totalwidth + (float)intObject.width, y + (float)intObject.height, intObject.storedX, intObject.storedY, intObject.storedX + intObject.width, intObject.storedY + intObject.height);
                }
                totalwidth += intObject.width;
            }
            ++i;
        }
        GL11.glEnd();
    }

    public void drawString3D(float x, float y, String whatchars, ColorSlick color, int startIndex, int endIndex) {
        if (whatchars.length() <= 0) {
            return;
        }
        this.fontTexture.bind();
        IntObject intObject = null;
        if (this.glvaoID == 0 || this.glvboID == 0) {
            this.glvaoID = GL30.glGenVertexArrays();
            this.glvboID = GL15.glGenBuffers();
            GL30.glBindVertexArray((int)this.glvaoID);
            GL20.glEnableVertexAttribArray((int)0);
            GL20.glEnableVertexAttribArray((int)1);
            GL20.glEnableVertexAttribArray((int)2);
            GL15.glBindBuffer((int)34962, (int)this.glvboID);
            GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35044);
            GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)0L);
            GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)this.stride, (long)this.textureoff);
            GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)this.coloroff);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            GL20.glDisableVertexAttribArray((int)2);
            GL20.glDisableVertexAttribArray((int)1);
            GL20.glDisableVertexAttribArray((int)0);
        }
        int totalwidth = 0;
        int maxchars = whatchars.length();
        if (maxchars > this.vmax) {
            maxchars = this.vmax;
        }
        this.vbodata.position(0);
        this.vcount = 0;
        int i = 0;
        while (i < maxchars) {
            char charCurrent = whatchars.charAt(i);
            intObject = charCurrent < '\u0100' ? this.charArray[charCurrent] : (IntObject)this.customChars.get(new Character(charCurrent));
            if (intObject != null) {
                if (i >= startIndex || i <= endIndex) {
                    this.drawQuad3D(x + (float)totalwidth, y, x + (float)totalwidth + (float)intObject.width, y + (float)intObject.height, intObject.storedX, intObject.storedY, intObject.storedX + intObject.width, intObject.storedY + intObject.height, color.r, color.g, color.b);
                }
                totalwidth += intObject.width;
            }
            ++i;
        }
        GL15.glBindBuffer((int)34962, (int)this.glvboID);
        this.vbodata.position(0);
        this.vbodata.limit(this.vcount * this.stride);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35048);
        GL15.glBindBuffer((int)34962, (int)0);
        this.vbodata.limit(this.vbodata.capacity());
        MatrixStack.sendFinalStack();
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        GL30.glBindVertexArray((int)this.glvaoID);
        GL11.glDrawArrays((int)7, (int)0, (int)this.vcount);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    @Override
    public void drawString(float x, float y, String whatchars) {
        this.drawString(x, y, whatchars, ColorSlick.white);
    }

    public void drawString3D(float x, float y, String whatchars) {
        this.drawString3D(x, y, whatchars, ColorSlick.white);
    }

    private void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        if (this.vcount >= this.vmax) {
            return;
        }
        this.vbodata.putFloat(vx);
        this.vbodata.putFloat(vy);
        this.vbodata.putFloat(vz);
        this.vbodata.putFloat(tx);
        this.vbodata.putFloat(ty);
        this.vbodata.putFloat(br);
        this.vbodata.putFloat(bg);
        this.vbodata.putFloat(bb);
        ++this.vcount;
    }

    private void drawQuad3D(float drawX, float drawY, float drawX2, float drawY2, float srcX, float srcY, float srcX2, float srcY2, float r, float g, float b) {
        float DrawWidth = drawX2 - drawX;
        float DrawHeight = drawY2 - drawY;
        float TextureSrcX = srcX / (float)this.textureWidth;
        float TextureSrcY = srcY / (float)this.textureHeight;
        float SrcWidth = srcX2 - srcX;
        float SrcHeight = srcY2 - srcY;
        float RenderWidth = SrcWidth / (float)this.textureWidth;
        float RenderHeight = SrcHeight / (float)this.textureHeight;
        this.addVertexInfoToVBO(drawX, drawY, 0.0f, TextureSrcX, TextureSrcY, r, g, b);
        this.addVertexInfoToVBO(drawX, drawY + DrawHeight, 0.0f, TextureSrcX, TextureSrcY + RenderHeight, r, g, b);
        this.addVertexInfoToVBO(drawX + DrawWidth, drawY + DrawHeight, 0.0f, TextureSrcX + RenderWidth, TextureSrcY + RenderHeight, r, g, b);
        this.addVertexInfoToVBO(drawX + DrawWidth, drawY, 0.0f, TextureSrcX + RenderWidth, TextureSrcY, r, g, b);
    }

    private class IntObject {
        public int width;
        public int height;
        public int storedX;
        public int storedY;

        private IntObject() {
        }
    }
}

