/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="java.io.RandomAccessFile")
final class RandomAccessFileInstrumentor {
    private String path;

    private RandomAccessFileInstrumentor() {
    }

    @JIInstrumentationMethod
    public int read() throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read();
        }
        int n = 0;
        try {
            fileReadEvent.begin();
            n = this.read();
            if (n < 0) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = 1L;
            }
        }
        finally {
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] byArray) throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read(byArray);
        }
        int n = 0;
        try {
            fileReadEvent.begin();
            n = this.read(byArray);
        }
        finally {
            if (n < 0) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = n;
            }
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(byte[] byArray, int n, int n2) throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read(byArray, n, n2);
        }
        int n3 = 0;
        try {
            fileReadEvent.begin();
            n3 = this.read(byArray, n, n2);
        }
        finally {
            if (n3 < 0) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = n3;
            }
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return n3;
    }

    @JIInstrumentationMethod
    public void write(int n) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(n);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(n);
            fileWriteEvent.bytesWritten = 1L;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }

    @JIInstrumentationMethod
    public void write(byte[] byArray) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(byArray);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(byArray);
            fileWriteEvent.bytesWritten = byArray.length;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] byArray, int n, int n2) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(byArray, n, n2);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(byArray, n, n2);
            fileWriteEvent.bytesWritten = n2;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }
}

