/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.io.IOException;
import java.io.InputStream;
import slick.Audio;
import slick.AudioImpl;
import slick.DeferredResource;
import slick.LoadingList;
import slick.SoundStore;

public class DeferredSound
extends AudioImpl
implements DeferredResource {
    public static final int OGG = 1;
    public static final int WAV = 2;
    public static final int MOD = 3;
    public static final int AIF = 4;
    private int type;
    private String ref;
    private Audio target;
    private InputStream in;

    public DeferredSound(String ref, InputStream in, int type) {
        this.ref = ref;
        this.type = type;
        if (ref.equals(in.toString())) {
            this.in = in;
        }
        LoadingList.get().add(this);
    }

    private void checkTarget() {
        if (this.target == null) {
            throw new RuntimeException("Attempt to use deferred sound before loading");
        }
    }

    @Override
    public void load() throws IOException {
        boolean before = SoundStore.get().isDeferredLoading();
        SoundStore.get().setDeferredLoading(false);
        if (this.in != null) {
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    this.target = SoundStore.get().getWAV(this.in);
                    break;
                }
                case 3: {
                    this.target = SoundStore.get().getMOD(this.in);
                    break;
                }
                case 4: {
                    break;
                }
            }
        } else {
            switch (this.type) {
                case 1: {
                    break;
                }
                case 2: {
                    this.target = SoundStore.get().getWAV(this.ref);
                    break;
                }
                case 3: {
                    this.target = SoundStore.get().getMOD(this.ref);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        SoundStore.get().setDeferredLoading(before);
    }

    @Override
    public boolean isPlaying() {
        this.checkTarget();
        return this.target.isPlaying();
    }

    @Override
    public int playAsMusic(float pitch, float gain, boolean loop) {
        this.checkTarget();
        return this.target.playAsMusic(pitch, gain, loop);
    }

    @Override
    public int playAsSoundEffect(float pitch, float gain, boolean loop) {
        this.checkTarget();
        return this.target.playAsSoundEffect(pitch, gain, loop);
    }

    @Override
    public int playAsSoundEffect(float pitch, float gain, boolean loop, float x, float y, float z) {
        this.checkTarget();
        return this.target.playAsSoundEffect(pitch, gain, loop, x, y, z);
    }

    @Override
    public void stop() {
        this.checkTarget();
        this.target.stop();
    }

    @Override
    public String getDescription() {
        return this.ref;
    }
}

