/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.Utils;
import dangerzone.rendering.StitchedTexture;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import slick.Texture;

public class StitchedTextureFile {
    public int textureID = -1;
    public int nextx = 0;
    public int nexty = 0;
    public Texture blankfile = null;
    public ByteBuffer texturedata = BufferUtils.createByteBuffer(this.total_size);
    public int total_size = 0x100000;
    public int total_sizemip1 = 262144;
    public ByteBuffer texturedatamip1 = BufferUtils.createByteBuffer(this.total_sizemip1);
    public int total_sizemip2 = 65536;
    public ByteBuffer texturedatamip2 = BufferUtils.createByteBuffer(this.total_sizemip2);
    public int total_sizemip3 = 16384;
    public ByteBuffer texturedatamip3 = BufferUtils.createByteBuffer(this.total_sizemip3);
    public int total_sizemip4 = 4096;
    public ByteBuffer texturedatamip4 = BufferUtils.createByteBuffer(this.total_sizemip4);

    public StitchedTexture doAddTexture(String texturename) {
        StitchedTexture st = this.doAddTextureToBuffer(texturename);
        if (st != null) {
            this.doMakeMipMaps();
        }
        return st;
    }

    public StitchedTexture doAddTextureToBuffer(String texturename) {
        Texture temp = null;
        if (this.nexty > 31) {
            return null;
        }
        if (texturename == null) {
            return null;
        }
        if (texturename.equals("")) {
            return null;
        }
        temp = Utils.initTexture(texturename);
        if (temp == null) {
            System.out.printf("Stitching texture not found: %s\n", texturename);
            return null;
        }
        byte[] b = temp.getTextureData();
        if (b.length < 768) {
            return null;
        }
        this.texturedata.position(0);
        if (b.length > 768) {
            int k = 0;
            int j = 0;
            while (j < 16) {
                int i = 0;
                while (i < 64) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i, b[k]);
                    ++k;
                    ++i;
                }
                ++j;
            }
        } else {
            int k = 0;
            int j = 0;
            while (j < 16) {
                int i = 0;
                while (i < 16) {
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4, b[k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 1, b[++k]);
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 2, b[++k]);
                    ++k;
                    this.texturedata.put(this.nexty * 32768 + this.nextx * 64 + j * 2048 + i * 4 + 3, (byte)-1);
                    ++i;
                }
                ++j;
            }
        }
        temp.release();
        StitchedTexture st = new StitchedTexture();
        st.yoffsetmin = (float)this.nexty / 32.0f;
        st.yoffsetmax = ((float)this.nexty + 1.0f) / 32.0f;
        st.xoffsetmin = (float)this.nextx / 32.0f;
        st.xoffsetmax = ((float)this.nextx + 1.0f) / 32.0f;
        ++this.nextx;
        if (this.nextx >= 32) {
            ++this.nexty;
            this.nextx = 0;
        }
        return st;
    }

    byte fetch_a_value(int rowsize, int row, int col, int off, ByteBuffer fromb) {
        byte retval = fromb.get(row * rowsize + col * 4 + off);
        return retval;
    }

    void smooth_a_pixel(int rowsize, int nrow, int row, int col, ByteBuffer fromb, ByteBuffer tob) {
        byte[] red = new byte[4];
        byte[] green = new byte[4];
        byte[] blue = new byte[4];
        byte[] alpha = new byte[4];
        int nval = 5;
        red[0] = this.fetch_a_value(rowsize * 2, row * 2, col * 2, 0, fromb);
        red[1] = this.fetch_a_value(rowsize * 2, row * 2, col * 2 + 1, 0, fromb);
        red[2] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2, 0, fromb);
        red[3] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2 + 1, 0, fromb);
        green[0] = this.fetch_a_value(rowsize * 2, row * 2, col * 2, 1, fromb);
        green[1] = this.fetch_a_value(rowsize * 2, row * 2, col * 2 + 1, 1, fromb);
        green[2] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2, 1, fromb);
        green[3] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2 + 1, 1, fromb);
        blue[0] = this.fetch_a_value(rowsize * 2, row * 2, col * 2, 2, fromb);
        blue[1] = this.fetch_a_value(rowsize * 2, row * 2, col * 2 + 1, 2, fromb);
        blue[2] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2, 2, fromb);
        blue[3] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2 + 1, 2, fromb);
        alpha[0] = this.fetch_a_value(rowsize * 2, row * 2, col * 2, 3, fromb);
        alpha[1] = this.fetch_a_value(rowsize * 2, row * 2, col * 2 + 1, 3, fromb);
        alpha[2] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2, 3, fromb);
        alpha[3] = this.fetch_a_value(rowsize * 2, row * 2 + 1, col * 2 + 1, 3, fromb);
        int vred = red[0] & 0xFF;
        int vgreen = green[0] & 0xFF;
        int vblue = blue[0] & 0xFF;
        int valpha = alpha[0] & 0xFF;
        int i = 0;
        while (i < 4) {
            if (alpha[i] == 0) {
                --nval;
            } else {
                vred += red[i] & 0xFF;
                vgreen += green[i] & 0xFF;
                vblue += blue[i] & 0xFF;
                valpha += alpha[i] & 0xFF;
            }
            ++i;
        }
        if (nval > 1) {
            vred /= nval;
            vgreen /= nval;
            vblue /= nval;
            valpha /= 5;
        }
        tob.put((byte)vred);
        tob.put((byte)vgreen);
        tob.put((byte)vblue);
        tob.put((byte)valpha);
    }

    byte fetch_smoothed_value(int rowsize, int nrow, int row, int col, int off, ByteBuffer fromb) {
        int iy = row * 2;
        int ix = col * 2;
        int accum = fromb.get(iy * (rowsize * 2) + ix * 4 + off) & 0xFF;
        accum *= 2;
        accum += fromb.get(iy * (rowsize * 2) + ix * 4 + off + 4) & 0xFF;
        accum += fromb.get(iy * (rowsize * 2) + ix * 4 + off + rowsize * 2) & 0xFF;
        accum += fromb.get(iy * (rowsize * 2) + ix * 4 + off + rowsize * 2 + 4) & 0xFF;
        return (byte)((accum /= 5) & 0xFF);
    }

    public void doMakeMipMaps() {
        int j;
        this.texturedata.position(0);
        this.texturedatamip1.position(0);
        int i = 0;
        while (i < 256) {
            j = 0;
            while (j < 256) {
                this.smooth_a_pixel(1024, 256, i, j, this.texturedata, this.texturedatamip1);
                ++j;
            }
            ++i;
        }
        this.texturedatamip1.position(0);
        this.texturedatamip2.position(0);
        i = 0;
        while (i < 128) {
            j = 0;
            while (j < 128) {
                this.smooth_a_pixel(512, 128, i, j, this.texturedatamip1, this.texturedatamip2);
                ++j;
            }
            ++i;
        }
        this.texturedatamip2.position(0);
        this.texturedatamip3.position(0);
        i = 0;
        while (i < 64) {
            j = 0;
            while (j < 64) {
                this.smooth_a_pixel(256, 64, i, j, this.texturedatamip2, this.texturedatamip3);
                ++j;
            }
            ++i;
        }
        this.texturedatamip3.position(0);
        this.texturedatamip4.position(0);
        i = 0;
        while (i < 32) {
            j = 0;
            while (j < 32) {
                this.smooth_a_pixel(128, 32, i, j, this.texturedatamip3, this.texturedatamip4);
                ++j;
            }
            ++i;
        }
        this.texturedata.position(0);
        this.texturedata.limit(this.total_size);
        this.texturedatamip1.position(0);
        this.texturedatamip1.limit(this.total_sizemip1);
        this.texturedatamip2.position(0);
        this.texturedatamip2.limit(this.total_sizemip2);
        this.texturedatamip3.position(0);
        this.texturedatamip3.limit(this.total_sizemip3);
        this.texturedatamip4.position(0);
        this.texturedatamip4.limit(this.total_sizemip4);
        if (this.textureID >= 0) {
            IntBuffer texBuf = BufferUtils.createIntBuffer(1);
            texBuf.put(this.textureID);
            texBuf.flip();
            GL11.glDeleteTextures((IntBuffer)texBuf);
        }
        this.textureID = this.createTextureID();
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)StitchedTextureFile.getPow2(512), (int)StitchedTextureFile.getPow2(512), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedata);
        GL11.glTexImage2D((int)3553, (int)1, (int)6408, (int)StitchedTextureFile.getPow2(256), (int)StitchedTextureFile.getPow2(256), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip1);
        GL11.glTexImage2D((int)3553, (int)2, (int)6408, (int)StitchedTextureFile.getPow2(128), (int)StitchedTextureFile.getPow2(128), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip2);
        GL11.glTexImage2D((int)3553, (int)3, (int)6408, (int)StitchedTextureFile.getPow2(64), (int)StitchedTextureFile.getPow2(64), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip3);
        GL11.glTexImage2D((int)3553, (int)4, (int)6408, (int)StitchedTextureFile.getPow2(32), (int)StitchedTextureFile.getPow2(32), (int)0, (int)6408, (int)5121, (ByteBuffer)this.texturedatamip4);
        GL11.glTexParameteri((int)3553, (int)33085, (int)4);
    }

    public void bind() {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.textureID);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public int createTextureID() {
        IntBuffer tmp = BufferUtils.createIntBuffer(1);
        GL11.glGenTextures((IntBuffer)tmp);
        return tmp.get(0);
    }

    public static int getPow2(int i) {
        int ret = 2;
        while (ret < i) {
            ret *= 2;
        }
        return ret;
    }
}

