/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.DangerZone;
import dangerzone.rendering.MatrixStack;
import dangerzone.rendering.ModelBase;
import dangerzone.rendering.StitchedTexture;
import dangerzone.rendering.VBOBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ModelRenderer {
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float sizeX;
    public float sizeY;
    public float sizeZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public boolean mirror = true;
    private float textureWidth;
    private float textureHeight;
    private float textureOffsetX;
    private float textureOffsetY;
    private boolean compiled;
    private int vao = 0;
    private int vbo_buffer = 0;
    private ByteBuffer vbodata = null;
    private int vcount = 0;
    private int stride = 0;
    private int textureoff = 0;
    private int coloroff = 0;
    private List<ModelRenderer> connected_parts = null;
    private boolean connected = false;
    private float drawoffx;
    private float drawoffy;
    private float drawoffz;
    private float cosrx;
    private float sinrx;
    private float cosry;
    private float sinry;
    private float cosrz;
    private float sinrz;
    private float use_r;
    private float use_g;
    private float use_b;
    private float use_tx;
    private float use_ty;

    public ModelRenderer(int par2, int par3) {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }

    public ModelRenderer(ModelBase mb, int par2, int par3) {
        this.textureOffsetX = par2;
        this.textureOffsetY = par3;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    public void setRotation(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
    }

    public void addCube(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }

    public void addBox(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.offsetX = par1;
        this.offsetY = par2;
        this.offsetZ = par3;
        this.sizeX = par4;
        this.sizeY = par5;
        this.sizeZ = par6;
    }

    public void setTextureSize(int par1, int par2) {
        this.textureWidth = par1;
        this.textureHeight = par2;
    }

    public void connectPart(ModelRenderer inpart) {
        if (inpart.connected_parts != null) {
            return;
        }
        if (this.connected) {
            return;
        }
        if (this.connected_parts == null) {
            this.connected_parts = new ArrayList<ModelRenderer>();
        }
        this.connected_parts.add(inpart);
        inpart.connected = true;
    }

    public void render(float deathfactorscale) {
        if (this.connected) {
            return;
        }
        boolean did_translate = false;
        boolean will_do_something = false;
        if (!this.compiled) {
            this.compileDisplayList();
        }
        if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            will_do_something = true;
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
            will_do_something = true;
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            will_do_something = true;
        }
        float my = -(this.rotationPointY * deathfactorscale - 24.0f);
        if (this.rotationPointX != 0.0f || this.rotationPointZ != 0.0f || my != 0.0f) {
            if (deathfactorscale >= 1.1f && my < 0.0f) {
                my = -my;
            }
            MatrixStack.pushMatrix();
            MatrixStack.translate(this.rotationPointX * deathfactorscale, my, -this.rotationPointZ * deathfactorscale);
            did_translate = true;
            MatrixStack.sendCurrentStack();
        }
        if (will_do_something) {
            MatrixStack.pushMatrix();
        }
        if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            my = -this.offsetY * deathfactorscale;
            if (deathfactorscale > 1.25f && my < 0.0f) {
                my = -my;
            }
            MatrixStack.translate(this.offsetX * deathfactorscale, my, -this.offsetZ * deathfactorscale);
        }
        if (this.rotateAngleX != 0.0f) {
            MatrixStack.rotate((float)((double)(-this.rotateAngleX) * 57.29577951308232), 1.0f, 0.0f, 0.0f);
        }
        if (this.rotateAngleY != 0.0f) {
            MatrixStack.rotate((float)((double)this.rotateAngleY * 57.29577951308232), 0.0f, 1.0f, 0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            MatrixStack.rotate((float)((double)this.rotateAngleZ * 57.29577951308232), 0.0f, 0.0f, 1.0f);
        }
        if (this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f) {
            MatrixStack.scale(this.scaleX, this.scaleY, this.scaleZ);
        }
        if (this.vao != 0) {
            if (will_do_something) {
                MatrixStack.sendCurrentStack();
            }
            MatrixStack.sendFinalStack();
            GL30.glBindVertexArray((int)this.vao);
            GL11.glDrawArrays((int)7, (int)0, (int)this.vcount);
            GL30.glBindVertexArray((int)0);
        }
        if (will_do_something) {
            MatrixStack.popMatrix();
        }
        if (did_translate) {
            MatrixStack.popMatrix();
        }
    }

    public void renderRaw() {
        if (this.connected) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList();
        }
        this.render(0.0f);
    }

    public void finishConnect() {
        this.compileDisplayList();
    }

    private void compileDisplayList() {
        if (this.compiled) {
            return;
        }
        if (DangerZone.wr == null) {
            return;
        }
        int nparts = 1;
        if (this.connected_parts != null) {
            nparts += this.connected_parts.size();
        }
        this.begin_compile(nparts);
        this.compile_part();
        if (this.connected_parts != null) {
            int i = 0;
            while (i < this.connected_parts.size()) {
                this.compile_connected_part(this.connected_parts.get(i));
                ++i;
            }
            this.connected_parts = null;
        }
        this.finish_compile();
        this.compiled = true;
    }

    private void begin_compile(int nparts) {
        this.textureoff = this.stride = 12;
        this.stride += 8;
        this.coloroff = this.stride;
        this.stride += 12;
        this.vcount = 0;
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glEnableVertexAttribArray((int)2);
        this.vbodata = BufferUtils.createByteBuffer(nparts * 24 * this.stride);
    }

    private void finish_compile() {
        this.vbodata.flip();
        this.vbo_buffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo_buffer);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vbodata, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)0L);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)this.stride, (long)this.textureoff);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)this.stride, (long)this.coloroff);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
        GL20.glDisableVertexAttribArray((int)2);
        GL20.glDisableVertexAttribArray((int)1);
        GL20.glDisableVertexAttribArray((int)0);
    }

    private void compile_connected_part(ModelRenderer inpart) {
        this.cosrx = (float)Math.cos(this.rotateAngleX);
        this.sinrx = (float)Math.sin(this.rotateAngleX);
        this.cosry = (float)Math.cos(this.rotateAngleY);
        this.sinry = (float)Math.sin(this.rotateAngleY);
        this.cosrz = (float)Math.cos(this.rotateAngleZ);
        this.sinrz = (float)Math.sin(this.rotateAngleZ);
        float pdrawx = this.offsetX;
        float pdrawy = this.offsetY;
        float pdrawz = this.offsetZ;
        float newx = pdrawx * this.cosrz - pdrawy * this.sinrz;
        float newy = pdrawy * this.cosrz + pdrawx * this.sinrz;
        pdrawx = newx;
        pdrawy = newy;
        newx = pdrawx * this.cosry - pdrawz * this.sinry;
        float newz = pdrawz * this.cosry + pdrawx * this.sinry;
        pdrawx = newx;
        pdrawz = newz;
        newy = pdrawy * this.cosrx - pdrawz * this.sinrx;
        newz = pdrawz * this.cosrx + pdrawy * this.sinrx;
        pdrawy = newy;
        pdrawz = newz;
        pdrawx += this.rotationPointX;
        pdrawy += this.rotationPointY;
        pdrawz += this.rotationPointZ;
        this.cosrx = (float)Math.cos(inpart.rotateAngleX);
        this.sinrx = (float)Math.sin(inpart.rotateAngleX);
        this.cosry = (float)Math.cos(inpart.rotateAngleY);
        this.sinry = (float)Math.sin(inpart.rotateAngleY);
        this.cosrz = (float)Math.cos(inpart.rotateAngleZ);
        this.sinrz = (float)Math.sin(inpart.rotateAngleZ);
        float drawx = inpart.offsetX;
        float drawy = inpart.offsetY;
        float drawz = inpart.offsetZ;
        newx = drawx * this.cosrz - drawy * this.sinrz;
        newy = drawy * this.cosrz + drawx * this.sinrz;
        drawx = newx;
        drawy = newy;
        newx = drawx * this.cosry - drawz * this.sinry;
        newz = drawz * this.cosry + drawx * this.sinry;
        drawx = newx;
        drawz = newz;
        newy = drawy * this.cosrx - drawz * this.sinrx;
        newz = drawz * this.cosrx + drawy * this.sinrx;
        drawy = newy;
        drawz = newz;
        this.drawoffx = (drawx += inpart.rotationPointX) - pdrawx;
        this.drawoffy = pdrawy - (drawy += inpart.rotationPointY);
        this.drawoffz = pdrawz - (drawz += inpart.rotationPointZ);
        while (this.rotateAngleX < 0.0f) {
            this.rotateAngleX = (float)((double)this.rotateAngleX + Math.PI * 2);
        }
        while ((double)this.rotateAngleX >= Math.PI * 2) {
            this.rotateAngleX = (float)((double)this.rotateAngleX - Math.PI * 2);
        }
        while (this.rotateAngleY < 0.0f) {
            this.rotateAngleY = (float)((double)this.rotateAngleY + Math.PI * 2);
        }
        while ((double)this.rotateAngleY >= Math.PI * 2) {
            this.rotateAngleY = (float)((double)this.rotateAngleY - Math.PI * 2);
        }
        this.cosrx = (float)Math.cos(Math.PI * 2 - (double)this.rotateAngleX);
        this.sinrx = (float)Math.sin(Math.PI * 2 - (double)this.rotateAngleX);
        this.cosry = (float)Math.cos(Math.PI * 2 - (double)this.rotateAngleY);
        this.sinry = (float)Math.sin(Math.PI * 2 - (double)this.rotateAngleY);
        this.cosrz = (float)Math.cos(this.rotateAngleZ);
        this.sinrz = (float)Math.sin(this.rotateAngleZ);
        newx = this.drawoffx * this.cosrz - this.drawoffy * this.sinrz;
        newy = this.drawoffy * this.cosrz + this.drawoffx * this.sinrz;
        this.drawoffx = newx;
        this.drawoffy = newy;
        newx = this.drawoffx * this.cosry - this.drawoffz * this.sinry;
        newz = this.drawoffz * this.cosry + this.drawoffx * this.sinry;
        this.drawoffx = newx;
        this.drawoffz = newz;
        newy = this.drawoffy * this.cosrx - this.drawoffz * this.sinrx;
        newz = this.drawoffz * this.cosrx + this.drawoffy * this.sinrx;
        this.drawoffy = newy;
        this.drawoffz = newz;
        float relrotX = inpart.rotateAngleX - this.rotateAngleX;
        float relrotY = inpart.rotateAngleY - this.rotateAngleY;
        float relrotZ = this.rotateAngleZ - inpart.rotateAngleZ;
        this.cosrx = (float)Math.cos(relrotX);
        this.sinrx = (float)Math.sin(relrotX);
        this.cosry = (float)Math.cos(relrotY);
        this.sinry = (float)Math.sin(relrotY);
        this.cosrz = (float)Math.cos(relrotZ);
        this.sinrz = (float)Math.sin(relrotZ);
        this.compile_this_thing(inpart);
    }

    private void relative_point(float x, float y, float z) {
        float relx = x;
        float rely = y;
        float relz = z;
        float newx = relx * this.cosrz - rely * this.sinrz;
        float newy = rely * this.cosrz + relx * this.sinrz;
        relx = newx;
        rely = newy;
        newx = relx * this.cosry - relz * this.sinry;
        float newz = relz * this.cosry + relx * this.sinry;
        relx = newx;
        relz = newz;
        newy = rely * this.cosrx - relz * this.sinrx;
        newz = relz * this.cosrx + rely * this.sinrx;
        rely = newy;
        relz = newz;
        this.addVertexInfoToVBO(relx + this.drawoffx, rely + this.drawoffy, relz + this.drawoffz, this.use_tx, this.use_ty, this.use_r, this.use_g, this.use_b);
    }

    private void set_use_color(float r, float g, float b) {
        this.use_r = r;
        this.use_g = g;
        this.use_b = b;
    }

    private void set_use_tex(float x, float y) {
        this.use_tx = x;
        this.use_ty = y;
    }

    private void compile_this_thing(ModelRenderer inpart) {
        if (this.mirror) {
            if (inpart.sizeX != 0.0f && inpart.sizeZ != 0.0f) {
                this.set_use_color(1.0f, 1.0f, 1.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_color(0.93f, 0.93f, 0.93f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
            if (inpart.sizeX != 0.0f && inpart.sizeY != 0.0f) {
                this.set_use_color(0.98f, 0.98f, 0.98f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_color(0.97f, 0.97f, 0.97f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
            if (inpart.sizeZ != 0.0f && inpart.sizeY != 0.0f) {
                this.set_use_color(0.95f, 0.95f, 0.95f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex(inpart.textureOffsetX / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex(inpart.textureOffsetX / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_color(0.95f, 0.95f, 0.95f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
        } else {
            if (inpart.sizeX != 0.0f && inpart.sizeZ != 0.0f) {
                this.set_use_color(1.0f, 1.0f, 1.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_color(0.93f, 0.93f, 0.93f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeX) / this.textureWidth, inpart.textureOffsetY / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
            if (inpart.sizeX != 0.0f && inpart.sizeY != 0.0f) {
                this.set_use_color(0.98f, 0.98f, 0.98f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_color(0.97f, 0.97f, 0.97f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
            if (inpart.sizeZ != 0.0f && inpart.sizeY != 0.0f) {
                this.set_use_color(0.95f, 0.95f, 0.95f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(0.0f, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ + inpart.sizeX) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(0.0f, -inpart.sizeY, 0.0f);
                this.set_use_color(0.95f, 0.95f, 0.95f);
                this.set_use_tex(inpart.textureOffsetX / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, -inpart.sizeZ);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ) / this.textureHeight);
                this.relative_point(inpart.sizeX, 0.0f, 0.0f);
                this.set_use_tex((inpart.textureOffsetX + inpart.sizeZ) / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, 0.0f);
                this.set_use_tex(inpart.textureOffsetX / this.textureWidth, (inpart.textureOffsetY + inpart.sizeZ + inpart.sizeY) / this.textureHeight);
                this.relative_point(inpart.sizeX, -inpart.sizeY, -inpart.sizeZ);
                this.vcount += 8;
            }
        }
    }

    private void addVertexInfoToVBO(float vx, float vy, float vz, float tx, float ty, float br, float bg, float bb) {
        this.vbodata.putFloat(vx);
        this.vbodata.putFloat(vy);
        this.vbodata.putFloat(vz);
        this.vbodata.putFloat(tx);
        this.vbodata.putFloat(ty);
        this.vbodata.putFloat(br);
        this.vbodata.putFloat(bg);
        this.vbodata.putFloat(bb);
    }

    private void compile_part() {
        if (this.mirror) {
            if (this.sizeX != 0.0f && this.sizeZ != 0.0f) {
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ) / this.textureWidth, this.textureOffsetY / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.vcount += 8;
            }
            if (this.sizeX != 0.0f && this.sizeY != 0.0f) {
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.vcount += 8;
            }
            if (this.sizeZ != 0.0f && this.sizeY != 0.0f) {
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, this.textureOffsetX / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, this.textureOffsetX / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.vcount += 8;
            }
        } else {
            if (this.sizeX != 0.0f && this.sizeZ != 0.0f) {
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ) / this.textureWidth, this.textureOffsetY / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 1.0f, 1.0f, 1.0f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth, this.textureOffsetY / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.93f, 0.93f, 0.93f);
                this.vcount += 8;
            }
            if (this.sizeX != 0.0f && this.sizeY != 0.0f) {
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.98f, 0.98f, 0.98f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.97f, 0.97f, 0.97f);
                this.vcount += 8;
            }
            if (this.sizeZ != 0.0f && this.sizeY != 0.0f) {
                this.addVertexInfoToVBO(0.0f, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, 0.0f, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, -this.sizeZ, (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(0.0f, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, -this.sizeZ, this.textureOffsetX / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, 0.0f, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, 0.0f, (this.textureOffsetX + this.sizeZ) / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.addVertexInfoToVBO(this.sizeX, -this.sizeY, -this.sizeZ, this.textureOffsetX / this.textureWidth, (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight, 0.95f, 0.95f, 0.95f);
                this.vcount += 8;
            }
        }
    }

    public void renderToVBO(VBOBuffer v, StitchedTexture st, float red, float green, float blue, int xo, int yo, int zo, int roty) {
        float mxy;
        float mny;
        float mnx;
        float mxx;
        float xs = this.rotationPointX + this.offsetX;
        float xe = xs + this.sizeX;
        float ye = 16.0f - (this.rotationPointY + this.offsetY);
        float ys = ye - this.sizeY;
        float ze = -(this.rotationPointZ + this.offsetZ);
        float zs = ze - this.sizeZ;
        float cosr = (float)Math.cos(Math.toRadians(roty));
        float sinr = (float)Math.sin(Math.toRadians(roty));
        ys += (float)yo;
        ye += (float)yo;
        if (Math.abs(xs - xe) > 0.01f && Math.abs(zs - ze) > 0.01f) {
            if (Math.abs(ys - ye) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + this.textureOffsetY / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBO(v, cosr, sinr, xe, ye, ze, mxx, mny, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xe, ye, zs, mxx, mxy, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ye, zs, mnx, mxy, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ye, ze, mnx, mny, red, green, blue, xo, zo);
            }
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + this.textureOffsetY / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBO(v, cosr, sinr, xe, ys, ze, mxx, mny, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xe, ys, zs, mxx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xs, ys, zs, mnx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xs, ys, ze, mnx, mny, red, green, blue, xo, zo);
        }
        if (Math.abs(xs - xe) > 0.01f && Math.abs(ys - ye) > 0.01f) {
            if (Math.abs(zs - ze) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBO(v, cosr, sinr, xe, ye, ze, mxx, mny, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ye, ze, mnx, mny, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ys, ze, mnx, mxy, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xe, ys, ze, mxx, mxy, red, green, blue, xo, zo);
            }
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBO(v, cosr, sinr, xe, ye, zs, mxx, mny, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xe, ys, zs, mxx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xs, ys, zs, mnx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xs, ye, zs, mnx, mny, red, green, blue, xo, zo);
        }
        if (Math.abs(zs - ze) > 0.01f && Math.abs(ys - ye) > 0.01f) {
            if (Math.abs(xs - xe) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + this.textureOffsetX / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBO(v, cosr, sinr, xs, ye, ze, mxx, mny, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ye, zs, mnx, mny, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ys, zs, mnx, mxy, red, green, blue, xo, zo);
                this.rotateIntoVBO(v, cosr, sinr, xs, ys, ze, mxx, mxy, red, green, blue, xo, zo);
            }
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBO(v, cosr, sinr, xe, ye, ze, mxx, mny, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xe, ys, ze, mxx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xe, ys, zs, mnx, mxy, red, green, blue, xo, zo);
            this.rotateIntoVBO(v, cosr, sinr, xe, ye, zs, mnx, mny, red, green, blue, xo, zo);
        }
    }

    public void rotateIntoVBO(VBOBuffer v, float cosr, float sinr, float x, float y, float z, float txx, float txy, float r, float g, float b, int xo, int zo) {
        v.addVertexInfoToVBO(x * cosr + z * sinr + (float)xo, y, z * cosr + x * sinr + (float)zo, txx, txy, r, g, b);
    }

    public void renderRotatedToVBO(VBOBuffer v, StitchedTexture st, float red, float green, float blue, int xo, int yo, int zo, int rotx, int roty, int rotz) {
        float mxy;
        float mny;
        float mnx;
        float mxx;
        float xs = this.offsetX;
        float xe = xs + this.sizeX;
        float ye = this.offsetY;
        float ys = ye + this.sizeY;
        float zs = this.offsetZ;
        float ze = zs + this.sizeZ;
        float cosrx = (float)Math.cos(Math.toRadians(rotx) + (double)this.rotateAngleX);
        float sinrx = (float)Math.sin(Math.toRadians(rotx) + (double)this.rotateAngleX);
        float cosry = (float)Math.cos(Math.toRadians(roty) + (double)this.rotateAngleY);
        float sinry = (float)Math.sin(Math.toRadians(roty) + (double)this.rotateAngleY);
        float cosrz = (float)Math.cos(Math.toRadians(rotz) + (double)this.rotateAngleZ);
        float sinrz = (float)Math.sin(Math.toRadians(rotz) + (double)this.rotateAngleZ);
        if (Math.abs(xs - xe) > 0.01f && Math.abs(zs - ze) > 0.01f) {
            if (Math.abs(ys - ye) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + this.textureOffsetY / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, ze, mxx, mny, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, zs, mxx, mxy, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, zs, mnx, mxy, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, ze, mnx, mny, red, green, blue, xo, yo, zo);
            }
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + this.textureOffsetY / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, ze, mxx, mny, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, zs, mxx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, zs, mnx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, ze, mnx, mny, red, green, blue, xo, yo, zo);
        }
        if (Math.abs(xs - xe) > 0.01f && Math.abs(ys - ye) > 0.01f) {
            if (Math.abs(zs - ze) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, ze, mxx, mny, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, ze, mnx, mny, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, ze, mnx, mxy, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, ze, mxx, mxy, red, green, blue, xo, yo, zo);
            }
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, zs, mxx, mny, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, zs, mxx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, zs, mnx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, zs, mnx, mny, red, green, blue, xo, yo, zo);
        }
        if (Math.abs(zs - ze) > 0.01f && Math.abs(ys - ye) > 0.01f) {
            if (Math.abs(xs - xe) > 0.01f) {
                mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mnx = st.xoffsetmin + this.textureOffsetX / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
                mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, ze, mxx, mny, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ye, zs, mnx, mny, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, zs, mnx, mxy, red, green, blue, xo, yo, zo);
                this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xs, ys, ze, mxx, mxy, red, green, blue, xo, yo, zo);
            }
            mnx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX + this.sizeZ) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mxx = st.xoffsetmin + (this.textureOffsetX + this.sizeZ + this.sizeX) / this.textureWidth * (st.xoffsetmax - st.xoffsetmin);
            mny = st.yoffsetmin + (this.textureOffsetY + this.sizeZ) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            mxy = st.yoffsetmin + (this.textureOffsetY + this.sizeZ + this.sizeY) / this.textureHeight * (st.yoffsetmax - st.yoffsetmin);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, ze, mxx, mny, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, ze, mxx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ys, zs, mnx, mxy, red, green, blue, xo, yo, zo);
            this.rotateIntoVBOXYZ(v, cosrx, sinrx, cosry, sinry, cosrz, sinrz, xe, ye, zs, mnx, mny, red, green, blue, xo, yo, zo);
        }
    }

    private void rotateIntoVBOXYZ(VBOBuffer v, float cosrx, float sinrx, float cosry, float sinry, float cosrz, float sinrz, float x, float y, float z, float txx, float txy, float r, float g, float b, int xo, int yo, int zo) {
        this.rotateIntoVBOXY(v, cosrx, sinrx, cosry, sinry, x * cosrz - y * sinrz, y * cosrz + x * sinrz, z, txx, txy, r, g, b, xo, yo, zo);
    }

    private void rotateIntoVBOXY(VBOBuffer v, float cosrx, float sinrx, float cosry, float sinry, float x, float y, float z, float txx, float txy, float r, float g, float b, int xo, int yo, int zo) {
        this.rotateIntoVBOX(v, cosrx, sinrx, x * cosry - z * sinry, y, z * cosry + x * sinry, txx, txy, r, g, b, xo, yo, zo);
    }

    private void rotateIntoVBOX(VBOBuffer v, float cosrx, float sinrx, float x, float y, float z, float txx, float txy, float r, float g, float b, int xo, int yo, int zo) {
        this.stuffIntoVBO(v, x, y * cosrx - z * sinrx, z * cosrx + y * sinrx, txx, txy, r, g, b, xo, yo, zo);
    }

    private void stuffIntoVBO(VBOBuffer v, float x, float y, float z, float txx, float txy, float r, float g, float b, int xo, int yo, int zo) {
        v.addVertexInfoToVBO(x + this.rotationPointX + (float)xo, 16.0f - (y + this.rotationPointY) + (float)yo, z + this.rotationPointZ + (float)zo, txx, txy, r, g, b);
    }
}

