/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.rendering.Vector3f;
import java.util.Arrays;
import org.lwjgl.openvr.HmdQuaternion;

public class Matrix4f {
    private static final int SIZE = 4;
    public float[] elements = new float[16];

    public static void identity(Matrix4f mat) {
        int i = 0;
        while (i < 16) {
            mat.elements[i] = 0.0f;
            ++i;
        }
        mat.elements[0] = 1.0f;
        mat.elements[5] = 1.0f;
        mat.elements[10] = 1.0f;
        mat.elements[15] = 1.0f;
    }

    public static void translate(Matrix4f mat, float x, float y, float z) {
        mat.set(3, 0, mat.get(3, 0) + x);
        mat.set(3, 1, mat.get(3, 1) + y);
        mat.set(3, 2, mat.get(3, 2) + z);
    }

    public static void scale(Matrix4f mat, float x, float y, float z) {
        mat.set(0, 0, mat.get(0, 0) * x);
        mat.set(1, 1, mat.get(1, 1) * y);
        mat.set(2, 2, mat.get(2, 2) * z);
    }

    public static void rotate(Matrix4f mat, float angle, float x, float y, float z) {
        Matrix4f presult = new Matrix4f();
        Matrix4f.identity(presult);
        Matrix4f temp = new Matrix4f();
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float C = 1.0f - cos;
        presult.set(0, 0, cos + x * x * C);
        presult.set(0, 1, x * y * C - z * sin);
        presult.set(0, 2, x * z * C + y * sin);
        presult.set(1, 0, y * x * C + z * sin);
        presult.set(1, 1, cos + y * y * C);
        presult.set(1, 2, y * z * C - x * sin);
        presult.set(2, 0, z * x * C - y * sin);
        presult.set(2, 1, z * y * C + x * sin);
        presult.set(2, 2, cos + z * z * C);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                temp.set(i, j, mat.get(i, j));
                ++j;
            }
            ++i;
        }
        Matrix4f.multiply(mat, temp, presult);
    }

    private static Matrix4f translate(Vector3f translate) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        result.set(3, 0, translate.getX());
        result.set(3, 1, translate.getY());
        result.set(3, 2, translate.getZ());
        return result;
    }

    private static Matrix4f rotate(float angle, Vector3f axis) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float C = 1.0f - cos;
        result.set(0, 0, cos + axis.getX() * axis.getX() * C);
        result.set(0, 1, axis.getX() * axis.getY() * C - axis.getZ() * sin);
        result.set(0, 2, axis.getX() * axis.getZ() * C + axis.getY() * sin);
        result.set(1, 0, axis.getY() * axis.getX() * C + axis.getZ() * sin);
        result.set(1, 1, cos + axis.getY() * axis.getY() * C);
        result.set(1, 2, axis.getY() * axis.getZ() * C - axis.getX() * sin);
        result.set(2, 0, axis.getZ() * axis.getX() * C - axis.getY() * sin);
        result.set(2, 1, axis.getZ() * axis.getY() * C + axis.getX() * sin);
        result.set(2, 2, cos + axis.getZ() * axis.getZ() * C);
        return result;
    }

    private static Matrix4f scale(Vector3f scalar) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        result.set(0, 0, scalar.getX());
        result.set(1, 1, scalar.getY());
        result.set(2, 2, scalar.getZ());
        return result;
    }

    public static Matrix4f transform(Vector3f position, Vector3f rotation, Vector3f scale) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        Matrix4f translationMatrix = Matrix4f.translate(position);
        Matrix4f rotXMatrix = Matrix4f.rotate(rotation.getX(), new Vector3f(1.0f, 0.0f, 0.0f));
        Matrix4f rotYMatrix = Matrix4f.rotate(rotation.getY(), new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f rotZMatrix = Matrix4f.rotate(rotation.getZ(), new Vector3f(0.0f, 0.0f, 1.0f));
        Matrix4f scaleMatrix = Matrix4f.scale(scale);
        Matrix4f rotationMatrix = Matrix4f.multiply(rotXMatrix, Matrix4f.multiply(rotYMatrix, rotZMatrix));
        result = Matrix4f.multiply(translationMatrix, Matrix4f.multiply(rotationMatrix, scaleMatrix));
        return result;
    }

    public static void projection(Matrix4f mat, float fov, float aspect, float near, float far) {
        float tanFOV = (float)Math.tan(Math.toRadians(fov / 2.0f));
        float range = far - near;
        Matrix4f.identity(mat);
        mat.set(0, 0, 1.0f / (aspect * tanFOV));
        mat.set(1, 1, 1.0f / tanFOV);
        mat.set(2, 2, -((far + near) / range));
        mat.set(2, 3, -1.0f);
        mat.set(3, 2, -(2.0f * far * near / range));
        mat.set(3, 3, 0.0f);
    }

    public static void ortho(Matrix4f mat, float left, float right, float top, float bottom, float near, float far) {
        Matrix4f.identity(mat);
        mat.set(0, 0, 2.0f / (right - left));
        mat.set(1, 1, 2.0f / (top - bottom));
        mat.set(2, 2, -(2.0f / (far - near)));
        mat.set(3, 0, -((right + left) / (right - left)));
        mat.set(3, 1, -((top + bottom) / (top - bottom)));
        mat.set(3, 2, -((far + near) / (far - near)));
        mat.set(3, 3, 1.0f);
    }

    public static Matrix4f view(Vector3f position, Vector3f rotation) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        Vector3f negative = new Vector3f(-position.getX(), -position.getY(), -position.getZ());
        Matrix4f translationMatrix = Matrix4f.translate(negative);
        Matrix4f rotXMatrix = Matrix4f.rotate(rotation.getX(), new Vector3f(1.0f, 0.0f, 0.0f));
        Matrix4f rotYMatrix = Matrix4f.rotate(rotation.getY(), new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f rotZMatrix = Matrix4f.rotate(rotation.getZ(), new Vector3f(0.0f, 0.0f, 1.0f));
        Matrix4f rotationMatrix = Matrix4f.multiply(rotYMatrix, Matrix4f.multiply(rotZMatrix, rotXMatrix));
        result = Matrix4f.multiply(translationMatrix, rotationMatrix);
        return result;
    }

    private static Matrix4f multiply(Matrix4f matrix, Matrix4f other) {
        Matrix4f result = new Matrix4f();
        Matrix4f.identity(result);
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                result.set(i, j, matrix.get(i, 0) * other.get(0, j) + matrix.get(i, 1) * other.get(1, j) + matrix.get(i, 2) * other.get(2, j) + matrix.get(i, 3) * other.get(3, j));
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void multiply(Matrix4f result, Matrix4f matrix, Matrix4f other) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                result.set(i, j, matrix.get(i, 0) * other.get(0, j) + matrix.get(i, 1) * other.get(1, j) + matrix.get(i, 2) * other.get(2, j) + matrix.get(i, 3) * other.get(3, j));
                ++j;
            }
            ++i;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix4f other = (Matrix4f)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public float get(int x, int y) {
        return this.elements[y * 4 + x];
    }

    public void set(int x, int y, float value) {
        this.elements[y * 4 + x] = value;
    }

    public void set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.set(0, 0, m00);
        this.set(1, 0, m01);
        this.set(2, 0, m02);
        this.set(3, 0, m03);
        this.set(0, 1, m10);
        this.set(1, 1, m11);
        this.set(2, 1, m12);
        this.set(3, 1, m13);
        this.set(0, 2, m20);
        this.set(2, 2, m21);
        this.set(2, 2, m22);
        this.set(3, 2, m23);
        this.set(0, 3, m30);
        this.set(1, 3, m31);
        this.set(2, 3, m32);
        this.set(3, 3, m33);
    }

    public static void quaternion_to_rotation(HmdQuaternion quat, Matrix4f mat) {
        double x = quat.x();
        double y = quat.y();
        double z = quat.z();
        double w = quat.w();
        double sqw = w * w;
        double sqx = x * x;
        double sqy = y * y;
        double sqz = z * z;
        Matrix4f.identity(mat);
        double invs = 1.0 / (sqx + sqy + sqz + sqw);
        mat.set(0, 0, (float)((sqx - sqy - sqz + sqw) * invs));
        mat.set(1, 1, (float)((-sqx + sqy - sqz + sqw) * invs));
        mat.set(2, 2, (float)((-sqx - sqy + sqz + sqw) * invs));
        double tmp1 = x * y;
        double tmp2 = z * w;
        mat.set(0, 1, (float)(2.0 * (tmp1 + tmp2) * invs));
        mat.set(1, 0, (float)(2.0 * (tmp1 - tmp2) * invs));
        tmp1 = x * z;
        tmp2 = y * w;
        mat.set(0, 2, (float)(2.0 * (tmp1 - tmp2) * invs));
        mat.set(2, 0, (float)(2.0 * (tmp1 + tmp2) * invs));
        tmp1 = y * z;
        tmp2 = x * w;
        mat.set(1, 2, (float)(2.0 * (tmp1 + tmp2) * invs));
        mat.set(2, 1, (float)(2.0 * (tmp1 - tmp2) * invs));
    }
}

